/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.net.UnknownHostException;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.asst.profile.NetTCPSAddr;
import oracle.net.nl.NVPair;

public class NetTCPAddr
extends NetProtocolAddr {
    public static final String TCP_PROTOCOL_PREFIX = "TCP";
    public static final String TCP_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=TCP))";
    private static final String[] TCP_ADDR_PARAM = new String[]{"HOST", "PORT"};
    private static final String[] TCP_ADDR_PARAM_LABEL = new String[]{"PFCaddrHostLabel", "PFCaddrPortLabel"};
    private int inValidField;

    public NetTCPAddr() {
        super(TCP_PROTOCOL_PREFIX, TCP_ADDR_FORMAT, TCP_ADDR_PARAM, TCP_ADDR_PARAM_LABEL);
    }

    public NetTCPAddr(NVPair nVPair) {
        this();
        this.setAddr(nVPair);
    }

    public boolean areDataValid() {
        this.devTrc("NetTCPAddr: areDataValid():");
        if (this.addrParamText[0].getText().length() == 0 || !this.netValidate.validateHostName(this.addrParamText[0])) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[1].getText().length() == 0 || !this.netValidate.validateNumber(this.addrParamText[1], 1, 65535)) {
            this.inValidField = 1;
            return false;
        }
        this.devTrc("NetTCPAddr: areDataValid(): true ");
        return true;
    }

    public void setFocus() {
        this.devTrc("NetTCPAddr: setFocus():");
        switch (this.inValidField) {
            case 0: {
                this.netValidate.showDialog(TCP_ADDR_PARAM[this.inValidField]);
                break;
            }
            case 1: {
                this.netValidate.showDialog(TCP_ADDR_PARAM[this.inValidField], 1, 65535);
            }
        }
        this.addrParamText[this.inValidField].selectAll();
        this.addrParamText[this.inValidField].requestFocus();
    }

    public String getProtocol() {
        return TCP_PROTOCOL_PREFIX;
    }

    public boolean sameEndpoint(NetProtocolAddr netProtocolAddr) {
        if (netProtocolAddr == null) {
            return false;
        }
        if (!(netProtocolAddr instanceof NetTCPAddr) && !(netProtocolAddr instanceof NetTCPSAddr)) {
            return false;
        }
        String string = this.addrParamText[0].getText();
        String string2 = netProtocolAddr.addrParamText[0].getText();
        String string3 = this.addrParamText[1].getText().toUpperCase();
        String string4 = netProtocolAddr.addrParamText[1].getText().toUpperCase();
        try {
            return NetUtils.isSameHost(string, string2) && string3.equalsIgnoreCase(string4);
        }
        catch (UnknownHostException unknownHostException) {
            return string.equalsIgnoreCase(string2) && string3.equalsIgnoreCase(string4);
        }
    }
}

