/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetBAuth
extends NetLayout
implements ProfileCache,
ActionListener,
NetButtonListener {
    private static final String[] NET_AUTH_BUTTONS = new String[]{"PFChelp"};
    private static final String[] PANEL_LABEL = new String[]{"PFCselectedANO", "PFCavailableANO"};
    private static final String[] CTRLPANEL_LABEL = new String[]{"PFCaddButtonLabel", "PFCremoveButtonLabel", "PFCpromoteButtonLabel", "PFCdemoteButtonLabel"};
    private static final String authservice = "sqlnet.authentication_services";
    private static final String OPEN_PAREN = "=(BEQ, TCPS, ";
    private static final String EMPTY = "";
    private static final String NO_ADAPTER = "";
    private static final String CLOSE_PAREN = ")";
    private static final String COMMA = ",";
    private static final int PANEL_SIZE = 10;
    private String[] availDefault;
    private String[] selectDefault;
    private String[] removeList;
    private String helpTopic;
    private String authName;
    private String[] ctrlButtons = new String[CTRLPANEL_LABEL.length];
    private String[] netAuthButton = new String[NET_AUTH_BUTTONS.length];
    private LWList selectList;
    private LWList availList;
    private EwtContainer lpanel;
    private EwtContainer cpanel;
    private EwtContainer rpanel;
    private LWButton[] button;
    private NLParamParser nlpa;
    private NetStrings netStrings = new NetStrings();
    private boolean foundnone;
    private boolean selected;
    private boolean emptyAdp = true;
    private boolean emptyRm = false;

    public NetBAuth(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = 0;
        while (n < NET_AUTH_BUTTONS.length) {
            this.netAuthButton[n] = this.netStrings.getString(NET_AUTH_BUTTONS[n]);
            ++n;
        }
        this.foundnone = true;
        this.removeList = stringArray;
        this.selectDefault = stringArray2;
        this.availDefault = stringArray3;
        this.helpTopic = new String(string);
        this.selected = false;
        this.authName = string;
        this.lpanel = new EwtContainer();
        this.lpanel.setLayout(new GridBagLayout());
        this.availList = new LWList(10, false);
        n = 0;
        while (n < this.availDefault.length) {
            this.availList.addItem(this.availDefault[n]);
            ++n;
        }
        this.constrain((Container)this.lpanel, (Component)new LWLabel(this.netStrings.getString(PANEL_LABEL[1])), 0, 0, 1, 1);
        this.constrain((Container)this.lpanel, (Component)this.availList, 0, 1, 1, 1, 5, 5, 0, 5, 1);
        this.cpanel = new EwtContainer();
        this.cpanel.setLayout(new GridBagLayout());
        this.button = new LWButton[CTRLPANEL_LABEL.length];
        this.ctrlButtons[0] = this.netStrings.getString(CTRLPANEL_LABEL[0]);
        this.button[0] = new LWButton(this.ctrlButtons[0]);
        this.button[0].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[0], 0, 0, 1, 1, 2, 15, 1.0, 5.0, 0, 5, 0, 5);
        this.ctrlButtons[1] = this.netStrings.getString(CTRLPANEL_LABEL[1]);
        this.button[1] = new LWButton(this.ctrlButtons[1]);
        this.button[1].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[1], 0, 1, 1, 1, 2, 10, 1.0, 0.0, 10, 5, 0, 5);
        this.ctrlButtons[2] = this.netStrings.getString(CTRLPANEL_LABEL[2]);
        this.button[2] = new LWButton(this.ctrlButtons[2]);
        this.button[2].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[2], 0, 2, 1, 1, 2, 10, 1.0, 0.0, 10, 5, 0, 5);
        this.ctrlButtons[3] = this.netStrings.getString(CTRLPANEL_LABEL[3]);
        this.button[3] = new LWButton(this.ctrlButtons[3]);
        this.button[3].addActionListener((ActionListener)this);
        this.constrain((Container)this.cpanel, (Component)this.button[3], 0, 3, 1, 1, 2, 11, 1.0, 5.0, 10, 5, 0, 5);
        this.rpanel = new EwtContainer();
        this.rpanel.setLayout(new GridBagLayout());
        this.selectList = new LWList(10, false);
        n = 0;
        while (n < this.selectDefault.length) {
            this.selectList.addItem(this.selectDefault[n]);
            ++n;
        }
        this.constrain((Container)this.rpanel, (Component)new LWLabel(this.netStrings.getString(PANEL_LABEL[0])), 0, 0, 1, 1);
        this.constrain((Container)this.rpanel, (Component)this.selectList, 0, 1, 1, 1, 5, 5, 0, 5, 1);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.constrain((Container)((Object)this), (Component)this.lpanel, 0, 0, 1, 1);
        this.constrain((Container)((Object)this), (Component)this.cpanel, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.rpanel, 2, 0, 1, 1);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("NetBAuth: setNLP():");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NetBAuth: cacheIt():");
        this.checkEmptyAdp();
        int n = this.selectList.getItemCount();
        this.devTrc("NetBAuth: cacheIt():" + this.selected);
        if (!this.selected) {
            return;
        }
        this.selected = false;
        if (n == 0) {
            this.nlpa.removeNLPListElement(authservice);
            return;
        }
        this.cacheSelectList();
    }

    public void refresh() {
        this.devTrc("NetBAuth: refresh():");
        this.makeAllNamingAvailable();
        NVPair nVPair = this.nlpa.getNLPListElement(authservice);
        if (nVPair != null) {
            int n = 0;
            while (n < nVPair.getListSize()) {
                NVPair nVPair2 = nVPair.getListElement(n);
                String string = nVPair2.getAtom().toUpperCase();
                if (this.checkAdd(string)) {
                    this.selectList.addItem(string);
                    this.checkEmptyAdp();
                    if (this.checkRemove(string)) {
                        this.availList.remove(string);
                        this.checkRmEmpty();
                    }
                }
                ++n;
            }
        }
        this.selected = false;
    }

    public boolean checkAdd(String string) {
        int n = 0;
        while (n < this.removeList.length) {
            if (string.equalsIgnoreCase(this.removeList[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkRemove(String string) {
        int n = this.availList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(this.availList.getItem(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.selected = true;
        this.devTrc("ACTION selected :" + this.selected);
        if (object instanceof LWButton) {
            int n = 0;
            while (n < CTRLPANEL_LABEL.length) {
                if (actionEvent.getActionCommand().compareTo(this.netStrings.getString(CTRLPANEL_LABEL[n])) == 0) break;
                ++n;
            }
            switch (n) {
                case 0: {
                    int n2 = this.availList.getSelectedIndex();
                    if (n2 < 0) break;
                    String string = this.availList.getSelectedItem();
                    this.availList.remove(n2);
                    this.selectList.addItem(string);
                    this.checkEmptyAdp();
                    return;
                }
                case 1: {
                    int n3 = this.selectList.getSelectedIndex();
                    if (n3 < 0) break;
                    String string = this.selectList.getSelectedItem();
                    this.selectList.remove(n3);
                    this.availList.addItem(string);
                    this.checkRmEmpty();
                    return;
                }
                case 3: {
                    int n4 = this.selectList.getSelectedIndex();
                    if (n4 < 0 || n4 >= this.selectList.getItemCount() - 1) break;
                    String string = this.selectList.getSelectedItem();
                    String string2 = this.selectList.getItem(n4 + 1);
                    this.selectList.replaceItem(string2, n4);
                    this.selectList.replaceItem(string, n4 + 1);
                    this.selectList.deselect(n4);
                    this.selectList.select(n4 + 1);
                    return;
                }
                case 2: {
                    int n5 = this.selectList.getSelectedIndex();
                    if (n5 <= 0) break;
                    String string = this.selectList.getSelectedItem();
                    String string3 = this.selectList.getItem(n5 - 1);
                    this.selectList.replaceItem(string3, n5);
                    this.selectList.replaceItem(string, n5 - 1);
                    this.selectList.deselect(n5);
                    this.selectList.select(n5 - 1);
                    return;
                }
            }
        }
    }

    private void makeAllNamingAvailable() {
        this.devTrc("NetBAuth: makeAllNamingAvailable():");
        this.availList.removeAll();
        this.selectList.removeAll();
        int n = 0;
        while (n < this.availDefault.length) {
            this.availList.addItem(this.availDefault[n]);
            ++n;
        }
        if (!this.emptyAdp) {
            return;
        }
        n = 0;
        while (n < this.selectDefault.length) {
            this.selectList.addItem(this.selectDefault[n]);
            ++n;
        }
    }

    private void cacheSelectList() {
        this.devTrc("NetBAuth: cacheSelectList():");
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.selectList.getItemCount();
        stringBuffer.append(OPEN_PAREN);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.selectList.getItem(n2));
            if (++n2 >= n) continue;
            stringBuffer.append(COMMA);
        }
        stringBuffer.append(CLOSE_PAREN);
        try {
            this.devTrc("NetBAuth selectList CacheOut");
            this.nlpa.addNLPListElement(authservice + stringBuffer.toString());
            return;
        }
        catch (NLException nLException) {
            System.err.println("exception during write: " + nLException);
            return;
        }
    }

    public boolean hasChanged() {
        return this.selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void reset() {
        this.selected = false;
        this.makeAllNamingAvailable();
    }

    public NetButton createNetButton() {
        this.devTrc("NetBAuth: createNetButton()");
        NetButton netButton = new NetButton(this.netAuthButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetBAuth: buttonPushed()");
        if (string.equalsIgnoreCase(this.netAuthButton[0])) {
            this.devTrc("NetBAuth: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic(this.helpTopic);
        }
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public void checkEmptyAdp() {
        if (this.emptyAdp) {
            this.selectList.remove("");
            this.emptyAdp = false;
        }
    }

    public void checkRmEmpty() {
        int n = this.availList.getItemCount();
        this.devTrc("NetBAuth checkRmEmpty()" + n);
        if (n == 0) {
            this.emptyRm = true;
            this.availList.addItem("");
            return;
        }
        if (this.emptyRm) {
            this.availList.remove("");
            this.emptyRm = false;
        }
    }
}

