/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.security.NetKRBAuth;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetBAuthParam
extends NetLayout
implements KeyListener {
    boolean hasChanged = false;
    private String authService;
    private String[] hiddenParam;
    private String[] hiddenParamVal;
    private String[] defaultVal;
    public String[] authParamLabel;
    public String[] authParam;
    NVPair auth;
    NVFactory nvfactory = new NVFactory();
    NVNavigator nvnav = new NVNavigator();
    LWTextField[] authParamText;
    private NLParamParser nlpa;
    protected String[] authParamName;
    private String os;
    protected int currentField;
    private static String[] ADAPTER = new String[]{"SECURID", "NTS"};
    private boolean refreshDef;
    private static int MAX_CLOCKSKEW = 6000;
    private static int MIN_CLOCKSKEW;

    public NetBAuthParam() {
    }

    public NetBAuthParam(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6) {
        NetStrings netStrings = new NetStrings();
        this.refreshDef = true;
        this.currentField = -1;
        this.os = System.getProperty("os.name");
        this.authService = string;
        this.authParamLabel = stringArray;
        this.authParam = stringArray2;
        this.hiddenParam = stringArray3;
        this.hiddenParamVal = stringArray4;
        this.defaultVal = this.os.startsWith("Windows") ? stringArray6 : stringArray5;
        this.authParamName = new String[this.authParamLabel.length];
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(3, 3, 3, 3));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.authParamText = new LWTextField[this.authParamLabel.length];
        int n = 0;
        while (n < this.authParamLabel.length) {
            this.authParamName[n] = netStrings.getString(this.authParamLabel[n]);
            ++n;
        }
        String string2 = ":";
        n = 0;
        while (n < ADAPTER.length) {
            if (this.authService.equalsIgnoreCase(ADAPTER[n])) {
                string2 = "!";
            }
            n = 0;
            while (n < this.authParamName.length) {
                this.constrain((Container)((Object)this), (Component)new LWLabel(String.valueOf(this.authParamName[n]) + string2, 1), 0, n, 1, 1, 0, 10, 5, 8);
                this.authParamText[n] = new LWTextField(20);
                this.authParamText[n].addKeyListener(this);
                if (!this.authService.equalsIgnoreCase(ADAPTER[0]) && !this.authService.equalsIgnoreCase(ADAPTER[1])) {
                    this.constrain((Container)((Object)this), (Component)this.authParamText[n], 1, n, 1, 1, 0, 10, 5, 8);
                }
                ++n;
            }
            this.showDefault();
            this.setDefault();
            ++n;
        }
    }

    public boolean isAuthValid() {
        this.devTrc("NetBAuthParam: isAuthValid():");
        return true;
    }

    public boolean hasChanged() {
        this.devTrc("NetBAuthParam: hasChanged():");
        return this.hasChanged;
    }

    public void refresh() {
        this.devTrc("NetBAuthParam: refresh():");
        this.hasChanged = false;
        int n = 0;
        while (n < this.authParam.length) {
            String string = this.authParam[n];
            if (string != null) {
                String string2;
                NVPair nVPair = this.nlpa.getNLPListElement(string);
                if (nVPair != null && (string2 = nVPair.getAtom()) != null) {
                    this.authParamText[n].setText(string2);
                } else if (this.defaultVal != null) {
                    this.authParamText[n].setText(this.defaultVal[n]);
                } else {
                    this.authParamText[n].setText("");
                }
            }
            ++n;
        }
        if (!this.authParamText[0].getText().equals("")) {
            this.showDefaultEditable();
        }
    }

    public void cacheIt() {
        String string;
        NVPair nVPair;
        String string2;
        this.devTrc("NetBAuthParam: cacheIt():" + this.authService);
        int n = 0;
        while (n < this.authParam.length) {
            string2 = this.authParam[n];
            if (string2 != null) {
                nVPair = this.nlpa.getNLPListElement(string2);
                string = this.authParamText[n].getText();
                int n2 = string.length();
                this.devTrc("NetBAuthParam: cacheIt() paramlen:" + n2);
                if (n == 0 && n2 == 0) {
                    this.removeAll(this.nlpa);
                    return;
                }
                if (n2 >= 0) {
                    this.nlpa.removeNLPListElement(string2);
                }
                if (n2 > 0) {
                    try {
                        if (this.defaultVal != null) {
                            if (!string.equals(this.defaultVal[n])) {
                                this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                            }
                        } else {
                            this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                        }
                    }
                    catch (NLException nLException) {}
                }
            }
            ++n;
        }
        if (this.hiddenParam != null) {
            n = 0;
            while (n < this.hiddenParam.length) {
                string2 = this.hiddenParam[n];
                nVPair = this.nlpa.getNLPListElement(string2);
                string = this.hiddenParamVal[n];
                while (nVPair != null) {
                    this.nlpa.removeNLPListElement(string2);
                    nVPair = this.nlpa.getNLPListElement(string2);
                }
                try {
                    this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                }
                catch (NLException nLException) {}
                ++n;
            }
        }
    }

    public String toString() {
        this.devTrc("NetBAuthParam: toString():");
        return this.auth.toString();
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nLParamParser;
    }

    public void removeAll(NLParamParser nLParamParser) {
        String string;
        int n = 0;
        while (n < this.authParam.length) {
            string = this.authParam[n];
            this.devTrc("NetBAuthParam: cacheIt() remove:" + string);
            nLParamParser.removeNLPListElement(string);
            ++n;
        }
        if (this.hiddenParam != null) {
            n = 0;
            while (n < this.hiddenParam.length) {
                string = this.hiddenParam[n];
                nLParamParser.removeNLPListElement(string);
                ++n;
            }
        }
    }

    public String getFirstParam() {
        return this.authParamText[0].getText();
    }

    protected void setDefault() {
        this.devTrc("NetAuthParam: setDefault()");
        String string = this.getFirstParam();
        if (string.equals("") || string == null) {
            this.refreshDef = true;
            this.showDefaultUnEditable();
            return;
        }
        if (this.refreshDef) {
            this.showDefaultEditable();
            this.refreshDef = false;
        }
    }

    protected void showDefault() {
        this.devTrc("NetAuthParam: showDefault()");
        int n = 0;
        while (n < this.authParam.length) {
            String string = this.authParamText[n].getText();
            if (string.equals("") && this.defaultVal != null) {
                this.authParamText[n].setText(this.defaultVal[n]);
            }
            ++n;
        }
        if (this instanceof NetKRBAuth) {
            this.authParamText[0].setText("");
        }
    }

    protected void showDefaultEditable() {
        this.devTrc("NetAuthParam: showDefaultEditable()");
        int n = 1;
        while (n < this.authParam.length) {
            String string = this.authParamText[n].getText();
            if (string.equals("") && this.defaultVal != null) {
                this.authParamText[n].setText(this.defaultVal[n]);
            }
            this.authParamText[n].setEditable(true);
            ++n;
        }
    }

    protected void showDefaultUnEditable() {
        this.devTrc("NetAuthParam: showDefaultUnEditable()");
        String string = this.authParamText[0].getText();
        if (!string.equals("")) {
            return;
        }
        int n = 1;
        while (n < this.authParam.length) {
            string = this.authParamText[n].getText();
            if (string.equals("") && this.defaultVal != null) {
                this.authParamText[n].setText(this.defaultVal[n]);
            }
            this.authParamText[n].setEditable(false);
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        LWTextField lWTextField = (LWTextField)component;
        lWTextField.getText();
        int n = this.authParamText.length;
        this.hasChanged = true;
        this.devTrc("NetBAuthParam : keyTyped()");
        if (component instanceof LWTextField) {
            this.setDefault();
        }
        if (lWTextField.equals(this.authParamText[n - 1])) {
            this.devTrc("NetBAuthParam : keyTyped() character typed:" + c);
            this.netValidate.validateNumber(lWTextField, MIN_CLOCKSKEW, MAX_CLOCKSKEW);
            return;
        }
        if (!this.validateCharset(c)) {
            keyEvent.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        int n = this.authParamText.length;
        this.devTrc("NetBAuthParam areDataValid:");
        String string = this.authParamText[0].getText();
        if (!string.equals("")) {
            if (this.netValidate != null) {
                if (this.authParamText.length > 1) {
                    if (!this.netValidate.validateNumber(this.authParamText[n - 1], MIN_CLOCKSKEW, MAX_CLOCKSKEW)) {
                        this.currentField = n - 1;
                        return false;
                    }
                } else if (!this.netValidate.validateName(this.authParamText[0])) {
                    this.devTrc("NetBAuthParam areDataValid:false");
                    this.currentField = 0;
                    return false;
                }
            }
            this.devTrc("NetBAuthParam areDataValid:true");
        }
        return true;
    }

    public boolean validateCharset(char c) {
        this.devTrc("NetBAuthParam : validateCharset():" + c);
        if (this.os.startsWith("Windows") ? Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '\\' || c == ':' : Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '/') {
            return true;
        }
        return c == '\b' || Character.digit(c, 10) == -1;
    }

    public void setFocus() {
        this.devTrc("NetBAuthParam : setFocus():currentField:" + this.currentField);
        LWTextField lWTextField = this.authParamText[this.currentField];
        if (this.currentField != -1) {
            if (this.currentField != 0) {
                this.netValidate.showDialog(lWTextField.getText(), MIN_CLOCKSKEW, MAX_CLOCKSKEW);
            }
            if (this.currentField == 0) {
                this.netValidate.showDialog(lWTextField.getText());
            }
            lWTextField.requestFocus();
            lWTextField.selectAll();
        }
    }
}

