/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.event.KeyEvent;
import java.io.File;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.security.NetBAuthParam;
import oracle.net.common.NetGetEnv;

public class NetRADAuth
extends NetBAuthParam {
    private static final String authService = "RADIUS";
    private static final String oracle_home;
    private static final String[] paramStrings;
    private static final String[] paramNames;
    private static final String[] solarisDefaults;
    private static final String[] ntDefaults;

    public NetRADAuth() {
        super(authService, paramStrings, paramNames, null, null, solarisDefaults, ntDefaults);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        this.devTrc("NetRADAuth : keyTyped()");
        this.hasChanged = true;
        if (!this.validateCharset(c)) {
            keyEvent.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetBAuthParam areDataValid:");
        String string = this.authParamText[0].getText();
        if (!this.netValidate.validateHostName(this.authParamText[0])) {
            this.currentField = 0;
            return false;
        }
        int n = 1;
        while (n <= 3) {
            if (!this.netValidate.validateNumber(this.authParamText[n], 0, Integer.MAX_VALUE) || this.authParamText[n].getText().equals("")) {
                this.currentField = n;
                return false;
            }
            ++n;
        }
        this.devTrc("NetBAuthParam areDataValid:true");
        this.currentField = -1;
        return true;
    }

    public void setFocus() {
        this.devTrc("NetBAuthParam : setFocus():currentField:" + this.currentField);
        LWTextField lWTextField = this.authParamText[this.currentField];
        if (this.currentField != -1) {
            this.netValidate.showDialog(this.authParamName[this.currentField]);
            lWTextField.requestFocus();
            lWTextField.selectAll();
        }
    }

    static {
        String string = NetGetEnv.getOracleHome();
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) != File.separatorChar) break;
            string = string.substring(0, n + 1);
            --n;
        }
        oracle_home = String.valueOf(string) + File.separatorChar;
        paramStrings = new String[]{"PFCRADParamPrimaryHost", "PFCRADParamPrimaryPort", "PFCRADParamPrimaryTimeout", "PFCRADParamPrimaryRetries", "PFCRADParamSecretFile", "PFCRADParamSendAccounting", "PFCRADParamChallengeResponse", "PFCRADParamChallengeKeyword", "PFCRADParamAuthInterface"};
        paramNames = new String[]{"sqlnet.radius_authentication", "sqlnet.radius_authentication_port", "sqlnet.radius_authentication_timeout", "sqlnet.radius_authentication_retries", "sqlnet.radius_secret", "sqlnet.radius_send_accounting", "sqlnet.radius_challenge_response", "sqlnet.radius_default_challenge_keyword", "sqlnet.radius_authentication_interface"};
        solarisDefaults = new String[]{"localhost", "1645", "15", "3", String.valueOf(oracle_home) + "network/security/radius.key", "OFF", "OFF", "challenge", "DefaultRadiusInterface"};
        ntDefaults = new String[]{"localhost", "1645", "15", "3", String.valueOf(oracle_home) + "network\\security\\radius.key", "OFF", "OFF", "challenge", "DefaultRadiusInterface"};
    }
}

