/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NullFieldMessage;
import oracle.net.asst.listener.ListenerComponent;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.SSLCipherSuitePanel;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetSSL
extends NetLayout
implements ProfileCache,
NetButtonListener,
ItemListener {
    private static final String walletParam = "oss.source.my_wallet";
    private static final String suiteParam = "ssl_cipher_suites";
    private static final String versionParam = "ssl_version";
    private static final String clientParam = "ssl_client_authentication";
    private static String defaultWallet = System.getProperty("os.name", "DEFAULTVAL").startsWith("Windows") ? "C:\\WINNT\\Profiles\\DATABASES\\" : "/etc/ORACLE/WALLETS/DATABASES";
    private static final NetStrings netStrings = new NetStrings();
    private static final String STATE_NONE = "NONE";
    private static final String STATE_CLIENT = netStrings.getString("PFCSSLclient");
    private static final String STATE_SERVER = netStrings.getString("PFCSSLserver");
    private String instructionString;
    private final String roleChooserString = netStrings.getString("PFCSSLrole");
    private final String walletLabelString = netStrings.getString("PFCSSLwallet");
    private final String chooseWalletString = netStrings.getString("PFCSSLchooseWallet");
    private final String walletDialogString = netStrings.getString("PFCSSLwalletDialog");
    private final String clientAuthString = netStrings.getString("PFCSSLclientAuth");
    private final String browseButtonString = netStrings.getString("PFCSSLbrowse");
    private final String sslVersionString = netStrings.getString("PFCSSLversion");
    private final String anyVersionString = netStrings.getString("PFCSSLanyVersion");
    private final String messageStringClient = netStrings.getString("PFCSSLmessageClient");
    private final String messageStringServer = netStrings.getString("PFCSSLmessageServer");
    private final String[] helpButtonString = new String[]{netStrings.getString("PFChelp")};
    private final String netSSLHelpFile = "TOPICanoSSL";
    private final String[] versions = new String[]{this.anyVersionString, "3.0"};
    private LWTextField walletField;
    private LWChoice versionChoice;
    private MultiLineLabel message;
    private LWLabel versionLabel;
    private LWLabel walletLabel;
    private LWLabel cipherSuiteLabel;
    private LWCheckboxGroup roleBoxGroup;
    private LWCheckbox clientAuthBox;
    private LWCheckbox domesticBox;
    private LWCheckbox roleClientBox;
    private LWCheckbox roleServerBox;
    private LWButton browseButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private LWButton addButton;
    private LWButton removeButton;
    private SSLCipherSuitePanel csPanel;
    private GroupBoxContainer groupBoxPanel;
    private EwtContainer componentPanel;
    private EwtContainer roleChooser;
    private EwtContainer messagePanel;
    private boolean changed = false;
    private boolean guiInitialized = false;
    private boolean fontInitialized = false;
    private String state = "NONE";
    private Container treeParent;
    private Component invalidField;
    private GridBagConstraints gbc = new GridBagConstraints();
    private NLParamParser nlpa;
    private Component[] allComponents;

    public NetSSL() {
        try {
            this.instructionString = netStrings.getString("PFCSSLinstructions");
        }
        catch (MissingResourceException missingResourceException) {
            this.instructionString = "";
        }
        this.roleChooser = new EwtContainer();
        this.roleChooser.setLayout(new FlowLayout(1, 0, 0));
        this.roleChooser.add((Component)new LWLabel(this.roleChooserString));
        this.roleBoxGroup = new LWCheckboxGroup();
        this.roleClientBox = new LWCheckbox(STATE_CLIENT, false, this.roleBoxGroup);
        this.roleClientBox.addItemListener((ItemListener)this);
        this.roleServerBox = new LWCheckbox(STATE_SERVER, false, this.roleBoxGroup);
        this.roleServerBox.addItemListener((ItemListener)this);
        this.roleChooser.add((Component)this.roleClientBox);
        this.roleChooser.add((Component)new LWLabel("  "));
        this.roleChooser.add((Component)this.roleServerBox);
        this.walletLabel = new LWLabel(this.walletLabelString);
        this.walletField = new LWTextField();
        this.walletField.addKeyListener(new 1());
        this.versionLabel = new LWLabel(this.sslVersionString);
        this.versionChoice = new LWChoice();
        this.versionChoice.addItemListener((ItemListener)this);
        int n = 0;
        while (n < this.versions.length) {
            this.versionChoice.addItem(this.versions[n]);
            ++n;
        }
        this.browseButton = new LWButton(this.browseButtonString);
        this.browseButton.addActionListener((ActionListener)new 2());
        this.message = new MultiLineLabel(WordWrapper.getTextWrapper(), this.instructionString);
        this.message.setPreferredAspectRatio(15.0f);
        this.messagePanel = new EwtContainer();
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(2, 10, 0, 10));
        this.messagePanel.add((Component)this.message, "Center");
        this.csPanel = new SSLCipherSuitePanel(null);
        this.clientAuthBox = new LWCheckbox(this.clientAuthString, true);
        this.clientAuthBox.addItemListener((ItemListener)this);
        this.componentPanel = new EwtContainer();
        this.componentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 10, 5, 10));
        this.componentPanel.setLayout(new GridBagLayout());
        this.groupBoxPanel = new GroupBoxContainer();
        this.groupBoxPanel.setTitle((Component)this.roleChooser);
        this.groupBoxPanel.setContent((Component)this.componentPanel);
        this.layoutComponents();
        this.allComponents = new Component[]{this.walletLabel, this.walletField, this.cipherSuiteLabel, this.csPanel, this.versionLabel, this.versionChoice, this.clientAuthBox, this.browseButton};
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 10, 5, 10));
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Container)((Object)this)).add((Component)this.groupBoxPanel, "Center");
        ((Container)((Object)this)).add((Component)this.messagePanel, "South");
        ((Component)((Object)this)).addComponentListener(new 3());
    }

    public NetSSL(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void addNotify() {
        Font font;
        super.addNotify();
        if (!this.fontInitialized && (font = this.message.getFont()) != null) {
            this.message.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 2));
            this.messagePanel.invalidate();
            this.fontInitialized = true;
        }
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        if (this.state == STATE_NONE) {
            return;
        }
        try {
            String string = this.walletField.getText();
            if (string == null || string == "") {
                throw new NullPointerException("Null wallet string in NetSSL");
            }
            String string2 = "oss.source.my_wallet=(SOURCE=(METHOD=FILE)(METHOD_DATA=(DIRECTORY=" + string + ")))";
            NetContainer netContainer = NetUtils.getApplication().getContainer();
            ListenerComponent listenerComponent = (ListenerComponent)netContainer.getListenerComponent();
            NLParamParser nLParamParser = listenerComponent.getNLPA();
            listenerComponent.markChangedFlag();
            nLParamParser.addNLPListElement(string2);
            nLParamParser.addNLPListElement("(ssl_client_authentication = FALSE)");
            this.nlpa.addNLPListElement(string2);
            String string3 = this.versionChoice.getSelectedItem();
            if (string3 == this.anyVersionString) {
                string3 = "0";
            }
            this.nlpa.addNLPListElement("ssl_version=" + string3);
            String[] stringArray = this.csPanel.getSelectedSuites();
            String string4 = "";
            if (stringArray.length == 0) {
                this.nlpa.removeNLPListElement(suiteParam);
            } else {
                String string5 = "";
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        string4 = String.valueOf(string4) + string5 + stringArray[n];
                        string5 = ", ";
                    }
                    ++n;
                }
                if (string4 == null || string4 == "") {
                    this.nlpa.removeNLPListElement(suiteParam);
                } else {
                    this.nlpa.addNLPListElement("ssl_cipher_suites=( " + string4 + " )");
                }
            }
            if (this.clientAuthBox.getState()) {
                this.nlpa.addNLPListElement("ssl_client_authentication=TRUE");
            } else {
                this.nlpa.addNLPListElement("ssl_client_authentication=FALSE");
            }
            this.changed = false;
            this.csPanel.setChanged(false);
            return;
        }
        catch (NLException nLException) {
            System.err.println(nLException);
            return;
        }
    }

    public void refresh() {
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = null;
        NVPair nVPair2 = null;
        Vector<String> vector = new Vector<String>(10, 5);
        this.changed = false;
        this.csPanel.setChanged(false);
        this.state = STATE_NONE;
        nVPair = this.nlpa.getNLPListElement(walletParam);
        if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "DIRECTORY")) != null) {
            this.walletField.setText(nVPair2.getAtom());
            this.state = STATE_CLIENT;
        }
        nVPair = null;
        nVPair2 = null;
        nVPair = this.nlpa.getNLPListElement(suiteParam);
        if (nVPair != null) {
            int n = 0;
            while (n < nVPair.getListSize()) {
                nVPair2 = nVPair.getListElement(n);
                vector.addElement(nVPair2.getAtom());
                ++n;
            }
            String[] stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            this.csPanel.setSelectedSuites(stringArray);
            this.state = STATE_CLIENT;
        } else {
            this.csPanel.setSelectedSuites(null);
        }
        nVPair = null;
        nVPair2 = null;
        nVPair = this.nlpa.getNLPListElement(versionParam);
        if (nVPair != null) {
            String string = nVPair.getAtom();
            if (string != null) {
                if (string == "0" || string == "0.0") {
                    this.versionChoice.select(this.anyVersionString);
                } else {
                    int n = this.versions.length - 1;
                    while (n >= 0) {
                        if (string == this.versions[n]) {
                            this.versionChoice.select(string);
                        }
                        --n;
                    }
                }
                this.state = STATE_CLIENT;
            }
        } else {
            this.versionChoice.select(0);
        }
        nVPair = null;
        nVPair2 = null;
        nVPair = this.nlpa.getNLPListElement(clientParam);
        if (nVPair != null) {
            String string = nVPair.getAtom();
            if (string.equalsIgnoreCase("FALSE")) {
                this.clientAuthBox.setState(false);
            }
            this.state = STATE_SERVER;
        } else {
            this.clientAuthBox.setState(true);
        }
        this.roleClientBox.setState(false);
        this.roleServerBox.setState(false);
        if (this.state == STATE_CLIENT) {
            this.roleClientBox.setState(true);
        } else if (this.state == STATE_SERVER) {
            this.roleServerBox.setState(true);
        }
        this.toggleState(this.state);
        this.changed = false;
        this.csPanel.setChanged(false);
        if (this.guiInitialized) {
            this.toggleState(this.state);
            this.roleBoxGroup.setSelectedCheckbox(this.state == STATE_CLIENT ? this.roleClientBox : this.roleServerBox);
        }
    }

    public boolean hasChanged() {
        return this.changed || this.csPanel.hasChanged();
    }

    public boolean areDataValid() {
        if (this.state == STATE_NONE) {
            return true;
        }
        String string = this.walletField.getText();
        if (string == null || string == "") {
            this.invalidField = this.walletField;
            return false;
        }
        return true;
    }

    public void setFocus() {
        if (this.invalidField == null) {
            return;
        }
        String string = this.walletLabelString.substring(0, this.walletLabelString.length() - 1);
        Container container = null;
        container = ((Component)((Object)this)).getParent();
        while (!(container instanceof BufferedFrame)) {
            container = container.getParent();
        }
        NullFieldMessage.display((Component)((Object)this), string);
        this.invalidField.requestFocus();
        if (this.invalidField instanceof LWTextField) {
            ((LWTextField)this.invalidField).selectAll();
        }
    }

    public NetButton createNetButton() {
        NetButton netButton = new NetButton(this.helpButtonString);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        if (string.equalsIgnoreCase(this.helpButtonString[0])) {
            NetUtils.getHelpContext().showTopic("TOPICanoSSL");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        this.changed = true;
        if (itemEvent.getStateChange() == 1) {
            if (object == STATE_CLIENT) {
                this.toggleState(STATE_CLIENT);
                return;
            }
            if (object == STATE_SERVER) {
                this.toggleState(STATE_SERVER);
            }
        }
    }

    private void showAllComponents(boolean bl) {
        int n = 0;
        while (n < this.allComponents.length) {
            if (this.allComponents[n] != null) {
                this.allComponents[n].setVisible(bl);
            }
            ++n;
        }
    }

    protected void toggleState(String string) {
        if (string == STATE_NONE) {
            this.showAllComponents(false);
            this.message.setText(this.instructionString);
        } else if (string == STATE_CLIENT) {
            this.showAllComponents(true);
            this.clientAuthBox.setVisible(false);
            this.message.setText(this.messageStringClient);
        } else {
            this.showAllComponents(true);
            this.message.setText(this.messageStringServer);
            if (this.walletField.getText().equals("")) {
                this.walletField.setText(defaultWallet);
                this.changed = true;
            }
        }
        this.messagePanel.invalidate();
        if (this.state == STATE_NONE && string != STATE_NONE) {
            try {
                NetContainer netContainer = NetUtils.getApplication().getContainer();
                ((Container)((Object)netContainer)).getLayout().layoutContainer((Container)((Object)netContainer));
                ((Container)((Object)netContainer)).validate();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            ((Container)((Object)this)).getLayout().layoutContainer((Container)((Object)this));
            this.validate();
        }
        this.state = string;
    }

    protected void layoutComponents() {
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 1;
        this.gbc.fill = 2;
        this.gbc.anchor = 16;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets.right = 0;
        this.gbc.insets.left = 0;
        this.gbc.insets.bottom = 0;
        this.gbc.insets.top = 0;
        this.componentPanel.add((Component)this.walletLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 1;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 0.0;
        this.componentPanel.add((Component)this.walletField, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets.left = 5;
        this.componentPanel.add((Component)this.browseButton, this.gbc);
        this.gbc.insets.left = 0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 10.0;
        this.gbc.insets.top = 5;
        this.componentPanel.add((Component)((Object)this.csPanel), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 0;
        this.gbc.insets.top = 10;
        this.componentPanel.add((Component)this.versionLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 10.0;
        this.gbc.fill = 0;
        this.gbc.insets.left = 5;
        this.componentPanel.add((Component)this.versionChoice, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 3;
        this.gbc.anchor = 16;
        this.gbc.fill = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets.bottom = 0;
        this.gbc.insets.left = 0;
        this.gbc.insets.top = 5;
        this.componentPanel.add((Component)this.clientAuthBox, this.gbc);
    }

    protected String pickDirectory() {
        Container container = null;
        container = ((Component)((Object)this)).getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        DirectoryDialog directoryDialog = new DirectoryDialog((Frame)container, this.chooseWalletString);
        directoryDialog.setMessage(this.walletDialogString);
        directoryDialog.setCenterOver((Component)container);
        directoryDialog.setCreateAllowed(true);
        File file = new File(this.walletField.getText());
        if (!file.isDirectory()) {
            file = new File(File.separator);
        }
        if ((file = directoryDialog.runDialog(file)) != null) {
            return file.toString();
        }
        return null;
    }

    static /* synthetic */ boolean access$0(NetSSL netSSL) {
        return netSSL.changed;
    }

    static /* synthetic */ void access$1(NetSSL netSSL, boolean bl) {
        netSSL.changed = bl;
    }

    static /* synthetic */ LWTextField access$2(NetSSL netSSL) {
        return netSSL.walletField;
    }

    static /* synthetic */ boolean access$3(NetSSL netSSL) {
        return netSSL.guiInitialized;
    }

    static /* synthetic */ String access$4(NetSSL netSSL) {
        return netSSL.state;
    }

    static /* synthetic */ String access$5() {
        return STATE_NONE;
    }

    static /* synthetic */ LWCheckboxGroup access$6(NetSSL netSSL) {
        return netSSL.roleBoxGroup;
    }

    static /* synthetic */ String access$7() {
        return STATE_CLIENT;
    }

    static /* synthetic */ LWCheckbox access$8(NetSSL netSSL) {
        return netSSL.roleClientBox;
    }

    static /* synthetic */ LWCheckbox access$9(NetSSL netSSL) {
        return netSSL.roleServerBox;
    }

    static /* synthetic */ void access$10(NetSSL netSSL, boolean bl) {
        netSSL.guiInitialized = bl;
    }

    private final class 1
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            NetSSL netSSL = NetSSL.this;
            netSSL.changed = true;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = NetSSL.this.pickDirectory();
            if (string != null) {
                NetSSL netSSL = NetSSL.this;
                netSSL.walletField.setText(string);
                netSSL = NetSSL.this;
                netSSL.changed = true;
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends ComponentAdapter {
        public void componentShown(ComponentEvent componentEvent) {
            NetSSL netSSL = NetSSL.this;
            if (!netSSL.guiInitialized) {
                netSSL = NetSSL.this;
                if (netSSL.state != NetSSL.STATE_NONE) {
                    LWCheckbox lWCheckbox;
                    netSSL = NetSSL.this;
                    LWCheckboxGroup lWCheckboxGroup = netSSL.roleBoxGroup;
                    netSSL = NetSSL.this;
                    if (netSSL.state == STATE_CLIENT) {
                        netSSL = NetSSL.this;
                        lWCheckbox = netSSL.roleClientBox;
                    } else {
                        netSSL = NetSSL.this;
                        lWCheckbox = netSSL.roleServerBox;
                    }
                    lWCheckboxGroup.setSelectedCheckbox(lWCheckbox);
                }
                netSSL = NetSSL.this;
                NetSSL.this.toggleState(netSSL.state);
                netSSL = NetSSL.this;
                netSSL.guiInitialized = true;
            }
        }

        /* synthetic */ 3() {
        }
    }
}

