/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.event.Cancelable;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderSelectAdapter;
import oracle.ewt.header.HeaderSelectListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableCellSelectAdapter;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableEvent;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.security.SSLCipherSuitePanel;
import oracle.net.common.NetProperties;

public class SSLCipherSuitePanel
extends NetLayout
implements ActionListener {
    private static final int DLG_WIDTH = 350;
    private static final int DLG_HEIGHT = 350;
    private static Hashtable exportDict = new Hashtable(25);
    private static Hashtable domesticDict = new Hashtable(25);
    private static Hashtable toolTipDict = new Hashtable(50);
    private static final NetStrings netStrings;
    private final String[] cols = new String[]{netStrings.getString("PFCSSLCSauthentication"), netStrings.getString("PFCSSLCSencryption"), netStrings.getString("PFCSSLCSdataIntegrity")};
    private final String cipherSuiteString = netStrings.getString("PFCSSLCScipherSuite");
    private final String addButtonString = netStrings.getString("PFCSSLCSadd");
    private final String removeButtonString = netStrings.getString("PFCSSLCSremove");
    private final String promoteButtonString = netStrings.getString("PFCSSLCSpromote");
    private final String demoteButtonString = netStrings.getString("PFCSSLCSdemote");
    private ArrayOneDDataSource colLabels;
    private SortableTwoDDataSource csData;
    private static SortableTwoDDataSource allData;
    private SpreadTable csTable;
    private ScrollBox tableSBox;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private Grid csGrid;
    private GridSelection csSelect;
    private Header csHeader;
    private NetProperties props;
    private int csTableInnerWidth = -1;
    private boolean enableUSDomestic = true;
    private boolean changed = false;
    private boolean allDataContainsDomestic = false;

    public SSLCipherSuitePanel(String[] stringArray) {
        Object object;
        try {
            this.props = NetProperties.getInstance();
            object = this.props.getProperty("USDOMESTIC");
            this.enableUSDomestic = object == null || !((String)object).equalsIgnoreCase("YES") ? true : true;
        }
        catch (Exception exception) {
            this.props = null;
            this.enableUSDomestic = true;
        }
        this.csData = this.initDataSource(stringArray, this.enableUSDomestic);
        this.colLabels = new ArrayOneDDataSource((Object[])this.cols);
        this.csTable = new SpreadTable((TwoDDataSource)this.csData, (OneDDataSource)this.colLabels, null);
        this.csTable.setVerticalSeparatorsVisible(false);
        this.csTable.setHorizontalSeparatorsVisible(false);
        this.csTable.addCellSelectListener((TableCellSelectListener)new 1());
        this.csHeader = this.csTable.getColumnHeader();
        this.csHeader.setCanResizeItems(true);
        this.csHeader.addSelectListener((HeaderSelectListener)new 2());
        this.csGrid = this.csTable.getGrid();
        this.csGrid.setToolTipValue((ToolTipClient)new CipherSuiteToolTipClient(this.csTable));
        this.csGrid.setPreferredRowsOnScreen(4);
        this.csGrid.setPreferredColumnsOnScreen(3);
        this.csSelect = this.csGrid.getGridSelection();
        this.tableSBox = new ScrollBox((Component)this.csTable, 2, 0);
        this.addButton = new LWButton(this.addButtonString);
        this.addButton.setActionCommand("ADD");
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeButtonString);
        this.removeButton.setActionCommand("REMOVE");
        this.removeButton.addActionListener((ActionListener)this);
        this.promoteButton = new LWButton();
        this.promoteButton.setActionCommand("PROMOTE");
        this.promoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.upArrow"), 1));
        this.promoteButton.setFocusable(false);
        this.promoteButton.addActionListener((ActionListener)this);
        this.demoteButton = new LWButton();
        this.demoteButton.setActionCommand("DEMOTE");
        this.demoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.downArrow"), 1));
        this.demoteButton.setFocusable(false);
        this.demoteButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 2;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets.left = 5;
        ((GridBagConstraints)object).insets.top = 5;
        ((Container)((Object)this)).add((Component)this.tableSBox, object);
        ++((GridBagConstraints)object).gridx;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 5.0;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 15;
        ((GridBagConstraints)object).insets.left = 5;
        ((GridBagConstraints)object).insets.right = 5;
        ((GridBagConstraints)object).insets.top = 1;
        ((GridBagConstraints)object).insets.bottom = 1;
        ((Container)((Object)this)).add((Component)this.promoteButton, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).anchor = 11;
        ((Container)((Object)this)).add((Component)this.demoteButton, object);
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setLayout(new GridLayout(1, 2));
        ewtContainer.add((Component)this.addButton);
        ewtContainer.add((Component)this.removeButton);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets.top = 4;
        ((GridBagConstraints)object).insets.bottom = 5;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).fill = 0;
        ((Container)((Object)this)).add((Component)ewtContainer, object);
        this.setBorderPainter(UIManager.createGroupBoxPainter((String)this.cipherSuiteString));
        if (this.csGrid.getRowCount() != 0) {
            this.csSelect.setRowSelected(0, true);
        }
    }

    public void setSelectedSuites(String[] stringArray) {
        this.csTable.setDataSources((TwoDDataSource)this.initDataSource(stringArray, this.enableUSDomestic), (OneDDataSource)this.colLabels, null);
        this.csGrid = this.csTable.getGrid();
        this.csData = (SortableTwoDDataSource)this.csGrid.getDataSource();
        this.csTableInnerWidth = -1;
    }

    public void paint(Graphics graphics) {
        int n = this.csTable.getInnerSize().width;
        if (this.csTableInnerWidth != n) {
            int n2 = n / this.cols.length;
            int n3 = 0;
            while (n3 < this.cols.length) {
                this.csTable.setColumnWidth(n3, n2);
                ++n3;
            }
            this.csTableInnerWidth = n;
        }
        super.paint(graphics);
    }

    public String[] getSelectedSuites() {
        String string = "";
        String string2 = "";
        String string3 = null;
        String[] stringArray = new String[this.csData.getRowCount()];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < this.cols.length) {
                string = String.valueOf(string) + string2 + (String)this.csData.getData(n2, n);
                string2 = "*";
                ++n2;
            }
            string3 = this.unHashSuite(string);
            if (string3 == null) {
                throw new NullPointerException("null suite");
            }
            stringArray[n] = string3;
            string2 = "";
            string = "";
            ++n;
        }
        return stringArray;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ADD")) {
            String[] stringArray = null;
            BufferedFrame bufferedFrame = this.findParentFrame();
            SuiteDialog suiteDialog = new SuiteDialog(bufferedFrame, true);
            ((Component)((Object)suiteDialog)).setSize(350, 350);
            Rectangle rectangle = bufferedFrame.getBounds();
            ((Component)((Object)suiteDialog)).setLocation(rectangle.x + rectangle.width / 2 - 175, rectangle.y + rectangle.height / 2 - 175);
            ((Component)((Object)suiteDialog)).setVisible(true);
            String string2 = System.getProperty("os.name");
            if (string2.equals("Windows 95") || string2.equals("Windows NT")) {
                bufferedFrame.toFront();
            }
            if ((stringArray = suiteDialog.getSelectedSuite()) != null) {
                this.changed = true;
                boolean bl = false;
                int n = this.csData.getRowCount();
                int n2 = 0;
                while (n2 < n) {
                    if (((String)this.csData.getData(0, n2)).equals(stringArray[0]) && ((String)this.csData.getData(1, n2)).equals(stringArray[1]) && ((String)this.csData.getData(2, n2)).equals(stringArray[2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    int n3 = 0;
                    int[] nArray = this.csSelect.getSelectedRows();
                    n3 = nArray == null || nArray.length == 0 ? n : nArray[0] + 1;
                    this.csData.addRows(n3, 1);
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        this.csData.setData(n4, n3, (Object)stringArray[n4]);
                        ++n4;
                    }
                    if (nArray != null && nArray.length != 0) {
                        this.csSelect.setRowSelected(nArray[0], false);
                    }
                    this.csSelect.setRowSelected(n3, true);
                    return;
                }
            }
        } else {
            if (string.equals("REMOVE")) {
                int[] nArray = this.csSelect.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                this.csData.removeRows(nArray[0], 1);
                this.changed = true;
                if (this.csData.getRowCount() == 0) {
                    return;
                }
                if (nArray[0] == 0) {
                    this.csSelect.setRowSelected(0, true);
                    return;
                }
                this.csSelect.setRowSelected(nArray[0] - 1, true);
                return;
            }
            if (string.equals("PROMOTE")) {
                if (this.moveSelectedRow(1)) {
                    this.changed = true;
                    return;
                }
            } else if (string.equals("DEMOTE") && this.moveSelectedRow(-1)) {
                this.changed = true;
            }
        }
    }

    private boolean moveSelectedRow(int n) {
        n = n >= 0 ? -1 : 1;
        int[] nArray = this.csSelect.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        if (n == -1 && nArray[0] == 0) {
            return false;
        }
        if (n == 1 && nArray[0] == this.csData.getRowCount() - 1) {
            return false;
        }
        Object[] objectArray = new Object[this.csData.getColumnCount()];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray[n2] = this.csData.getData(n2, nArray[0]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.csData.setData(n3, nArray[0], this.csData.getData(n3, nArray[0] + n));
            ++n3;
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            this.csData.setData(n4, nArray[0] + n, objectArray[n4]);
            ++n4;
        }
        this.csSelect.setRowSelected(nArray[0], false);
        this.csSelect.setRowSelected(nArray[0] + n, true);
        int n5 = this.csSelect.getSelectedRows()[0];
        int n6 = this.csTable.getFirstRowOnScreen();
        if (!this.csGrid.isRowOnScreen(n5) || n5 < n6) {
            if (n5 < n6) {
                this.csTable.setFirstRowOnScreen(n5);
            } else {
                n6 = n5 - this.csTable.getOnScreenRowCount() + 1;
                this.csTable.setFirstRowOnScreen(n6);
            }
        }
        return true;
    }

    private SortableTwoDDataSource initDataSource(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return new SortableTwoDDataSource(this.cols.length, 0);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (exportDict.get(stringArray[n2]) != null || bl && domesticDict.get(stringArray[n2]) != null) {
                ++n;
            }
            ++n2;
        }
        SortableTwoDDataSource sortableTwoDDataSource = new SortableTwoDDataSource(this.cols.length, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            String[] stringArray2 = this.parseSuite((String)exportDict.get(stringArray[n4]));
            if (stringArray2 == null && bl) {
                stringArray2 = this.parseSuite((String)domesticDict.get(stringArray[n4]));
            }
            if (stringArray2 != null) {
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    sortableTwoDDataSource.setData(n5, n3, (Object)stringArray2[n5]);
                    ++n5;
                }
                ++n3;
            }
            ++n4;
        }
        return sortableTwoDDataSource;
    }

    private BufferedFrame findParentFrame() {
        Container container = ((Component)((Object)this)).getParent();
        while (!(container instanceof BufferedFrame)) {
            container = container.getParent();
        }
        if (container instanceof BufferedFrame) {
            return (BufferedFrame)container;
        }
        return null;
    }

    private String unHashSuite(String string) {
        String string2;
        Enumeration enumeration = exportDict.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string.compareTo((String)exportDict.get(string2)) != 0) continue;
            return string2;
        }
        if (this.enableUSDomestic) {
            enumeration = domesticDict.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string.compareTo((String)domesticDict.get(string2)) != 0) continue;
                return string2;
            }
        }
        return null;
    }

    private String[] parseSuite(String string) {
        String[] stringArray = new String[3];
        if (string == null) {
            return null;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        while (stringTokenizer.hasMoreTokens() && n < 3) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private String getToolTipByCell(TwoDDataSource twoDDataSource, int n, int n2) {
        if (n < 0 || n >= twoDDataSource.getRowCount() || n2 < 0 || n2 >= twoDDataSource.getColumnCount()) {
            return null;
        }
        Object object = twoDDataSource.getData(n2, n);
        if (object == null) {
            return null;
        }
        return (String)toolTipDict.get(object);
    }

    static /* synthetic */ GridSelection access$0(SSLCipherSuitePanel sSLCipherSuitePanel) {
        return sSLCipherSuitePanel.csSelect;
    }

    static /* synthetic */ String access$1(SSLCipherSuitePanel sSLCipherSuitePanel, TwoDDataSource twoDDataSource, int n, int n2) {
        return sSLCipherSuitePanel.getToolTipByCell(twoDDataSource, n, n2);
    }

    static /* synthetic */ NetStrings access$2() {
        return netStrings;
    }

    static /* synthetic */ SortableTwoDDataSource access$3() {
        return allData;
    }

    static /* synthetic */ String[] access$4(SSLCipherSuitePanel sSLCipherSuitePanel) {
        return sSLCipherSuitePanel.cols;
    }

    static /* synthetic */ void access$5(SortableTwoDDataSource sortableTwoDDataSource) {
        allData = sortableTwoDDataSource;
    }

    static /* synthetic */ ArrayOneDDataSource access$6(SSLCipherSuitePanel sSLCipherSuitePanel) {
        return sSLCipherSuitePanel.colLabels;
    }

    static /* synthetic */ Hashtable access$7() {
        return exportDict;
    }

    static /* synthetic */ String[] access$8(SSLCipherSuitePanel sSLCipherSuitePanel, String string) {
        return sSLCipherSuitePanel.parseSuite(string);
    }

    static /* synthetic */ boolean access$9(SSLCipherSuitePanel sSLCipherSuitePanel) {
        return sSLCipherSuitePanel.allDataContainsDomestic;
    }

    static /* synthetic */ Hashtable access$10() {
        return domesticDict;
    }

    static /* synthetic */ void access$11(SSLCipherSuitePanel sSLCipherSuitePanel, boolean bl) {
        sSLCipherSuitePanel.allDataContainsDomestic = bl;
    }

    static {
        domesticDict.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "RSA*3DES_EDE_CBC*SHA");
        domesticDict.put("SSL_RSA_WITH_RC4_128_MD5", "RSA*RC4_128*MD5");
        domesticDict.put("SSL_RSA_WITH_RC4_128_SHA", "RSA*RC4_128*SHA");
        domesticDict.put("SSL_RSA_WITH_DES_CBC_SHA", "RSA*DES_CBC*SHA");
        domesticDict.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "DH_anon*3DES_EDE_CBC*SHA");
        domesticDict.put("SSL_DH_anon_WITH_RC4_128_MD5", "DH_anon*RC4_128*MD5");
        domesticDict.put("SSL_DH_anon_WITH_DES_CBC_SHA", "DH_anon*DES_CBC*SHA");
        exportDict.put("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "RSA_EXPORT*RC4_40*MD5");
        exportDict.put("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "RSA_EXPORT*DES40_CBC*SHA");
        exportDict.put("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "DH_anon*RC4_40*MD5");
        exportDict.put("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "DH_anon*DES40_CBC*SHA");
        exportDict.put("SSL_RSA_WITH_NULL_SHA", "RSA*NULL*SHA");
        exportDict.put("SSL_RSA_WITH_NULL_MD5", "RSA*NULL*MD5");
        toolTipDict.put("RSA_EXPORT", "RSA signature (40 bit)");
        toolTipDict.put("RSA", "RSA signature (40 bit)");
        toolTipDict.put("DH_anon", "Diffie Hellman, Anonymous (No certificate)");
        toolTipDict.put("NULL", "(No data encryption)");
        toolTipDict.put("DES", "Data Encryption Standard (56 bit)");
        toolTipDict.put("DES_CBC", "Data Encryption Standard (56 bit) - Cipher Block Chaining");
        toolTipDict.put("DES40", "Data Encryption Standard (40 bit)");
        toolTipDict.put("DES40_CBC", "Data Encryption Standard (40 bit) - Cipher Block Chaining");
        toolTipDict.put("RC4_40", "RC4 Encryption [RSA] (40 bit)");
        toolTipDict.put("RC4_128", "RC4 Encryption [RSA] (128 bit)");
        toolTipDict.put("3DES_EDE_CBC", "Data Encryption Standard (3 56 bit keys) - Cipher Block Chaining");
        toolTipDict.put("MD5", "Message Digest 5");
        toolTipDict.put("SHA", "Secure Hash Algorithm");
        netStrings = new NetStrings();
    }

    private final class 1
    extends TableCellSelectAdapter {
        public void cellSelected(TableEvent tableEvent) {
            if (tableEvent.getRow() == -1) {
                return;
            }
            int n = tableEvent.getRow();
            SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
            sSLCipherSuitePanel.csSelect.setRowSelected(n, true);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends HeaderSelectAdapter {
        public void itemSelecting(HeaderEvent headerEvent) {
            ((Cancelable)headerEvent).cancel();
        }

        /* synthetic */ 2() {
        }
    }

    private class SuiteDialog
    extends BufferedDialog
    implements ActionListener {
        private final String okButtonString = netStrings.getString("PFCSSLCSDok");
        private final String cancelButtonString = netStrings.getString("PFCSSLCSDcancel");
        private final String titleString = netStrings.getString("PFCSSLCSDtitle");
        private final String domesticString = netStrings.getString("PFCSSLCSDshowUSDomestic");
        private SpreadTable allTable;
        private Grid allGrid;
        private GridSelection allSelect;
        private Header allHeader;
        private ScrollBox allTableSBox;
        private EwtContainer buttonPanel;
        private LWButton okButton;
        private LWButton cancelButton;
        private String[] selectedSuite;
        private int allTableInnerWidth = -1;

        SuiteDialog(BufferedFrame bufferedFrame, boolean bl) {
            super((Frame)bufferedFrame, bl);
            Object object;
            SSLCipherSuitePanel.this = SSLCipherSuitePanel.this;
            if (allData == null) {
                allData = object = new SortableTwoDDataSource(SSLCipherSuitePanel.this.cols.length, 0);
                this.addExportSuites();
                allData.sort(0, false);
            }
            this.allTable = new SpreadTable((TwoDDataSource)allData, (OneDDataSource)SSLCipherSuitePanel.this.colLabels, null);
            this.allTable.setVerticalSeparatorsVisible(false);
            this.allTable.setHorizontalSeparatorsVisible(false);
            this.allTable.addCellSelectListener((TableCellSelectListener)new 3(this));
            this.allHeader = this.allTable.getColumnHeader();
            this.allHeader.setCanResizeItems(false);
            this.allHeader.addSelectListener((HeaderSelectListener)new 4());
            this.allGrid = this.allTable.getGrid();
            SSLCipherSuitePanel sSLCipherSuitePanel2 = SSLCipherSuitePanel.this;
            sSLCipherSuitePanel2.getClass();
            this.allGrid.setToolTipValue((ToolTipClient)sSLCipherSuitePanel2.new CipherSuiteToolTipClient(this.allTable));
            this.allSelect = this.allGrid.getGridSelection();
            this.allTableSBox = new ScrollBox((Component)this.allTable, 2, 0);
            this.buttonPanel = new EwtContainer();
            this.okButton = new LWButton(this.okButtonString);
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener((ActionListener)this);
            this.cancelButton = new LWButton(this.cancelButtonString);
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener((ActionListener)this);
            this.addDomesticSuites();
            allData.sort(0, false);
            this.buttonPanel.setLayout(new FlowLayout(1, 10, 5));
            this.buttonPanel.add((Component)this.okButton);
            this.buttonPanel.add((Component)this.cancelButton);
            this.setLayout(new GridBagLayout());
            object = new GridBagConstraints();
            object.gridx = 0;
            object.gridy = 0;
            object.gridwidth = 1;
            object.gridheight = 1;
            object.weightx = 1.0;
            object.weighty = 1.0;
            object.anchor = 10;
            object.fill = 1;
            object.insets.left = 10;
            object.insets.right = 10;
            object.insets.top = 10;
            object.insets.bottom = 5;
            ((Container)((Object)this)).add((Component)this.allTableSBox, object);
            object.gridy = 1;
            object.weighty = 0.0;
            object.anchor = 18;
            object.insets.top = 0;
            object.gridy = 2;
            ((Container)((Object)this)).add((Component)this.buttonPanel, object);
            ((Dialog)((Object)this)).setTitle(this.titleString);
        }

        public String[] getSelectedSuite() {
            return this.selectedSuite;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        public void paint(Graphics graphics) {
            block2: {
                SSLCipherSuitePanel sSLCipherSuitePanel;
                int n;
                int n2;
                block3: {
                    if (this.allTableInnerWidth == this.allTable.getInnerSize().width) break block2;
                    this.allTableInnerWidth = this.allTable.getInnerSize().width;
                    SSLCipherSuitePanel sSLCipherSuitePanel2 = SSLCipherSuitePanel.this;
                    n2 = this.allTableInnerWidth / sSLCipherSuitePanel2.cols.length;
                    n = 0;
                    if (!true) break block3;
                    sSLCipherSuitePanel = SSLCipherSuitePanel.this;
                    if (n >= sSLCipherSuitePanel.cols.length) break block2;
                }
                do {
                    this.allTable.setColumnWidth(n, n2);
                    ++n;
                    sSLCipherSuitePanel = SSLCipherSuitePanel.this;
                } while (n < sSLCipherSuitePanel.cols.length);
            }
            super.paint(graphics);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                int[] nArray = this.allSelect.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    this.selectedSuite = null;
                } else {
                    SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
                    this.selectedSuite = new String[sSLCipherSuitePanel.cols.length];
                    int n = 0;
                    while (n < this.selectedSuite.length) {
                        this.selectedSuite[n] = (String)allData.getData(n, nArray[0]);
                        ++n;
                    }
                }
                ((Component)((Object)this)).setVisible(false);
                return;
            }
            if (string.equals("CANCEL")) {
                this.selectedSuite = null;
                ((Component)((Object)this)).setVisible(false);
            }
        }

        protected void addExportSuites() {
            int n = 0;
            Enumeration enumeration = exportDict.elements();
            while (enumeration.hasMoreElements()) {
                SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
                String string = (String)enumeration.nextElement();
                String[] stringArray = sSLCipherSuitePanel.parseSuite(string);
                allData.addRows(n, 1);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    allData.setData(n2, n, (Object)stringArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        protected void addDomesticSuites() {
            SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
            if (sSLCipherSuitePanel.allDataContainsDomestic) {
                return;
            }
            allData.addRows(exportDict.size(), domesticDict.size());
            int n = exportDict.size();
            Enumeration enumeration = domesticDict.elements();
            String[] stringArray = null;
            while (enumeration.hasMoreElements()) {
                SSLCipherSuitePanel sSLCipherSuitePanel2 = SSLCipherSuitePanel.this;
                String string = (String)enumeration.nextElement();
                stringArray = sSLCipherSuitePanel2.parseSuite(string);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    allData.setData(n2, n, (Object)stringArray[n2]);
                    ++n2;
                }
                ++n;
            }
            SSLCipherSuitePanel sSLCipherSuitePanel3 = SSLCipherSuitePanel.this;
            sSLCipherSuitePanel3.allDataContainsDomestic = true;
        }

        protected void removeDomesticSuites() {
            SSLCipherSuitePanel sSLCipherSuitePanel = SSLCipherSuitePanel.this;
            if (!sSLCipherSuitePanel.allDataContainsDomestic) {
                return;
            }
            allData.removeRows(0, allData.getRowCount());
            this.addExportSuites();
            sSLCipherSuitePanel = SSLCipherSuitePanel.this;
            sSLCipherSuitePanel.allDataContainsDomestic = false;
        }

        static /* synthetic */ GridSelection access$0(SuiteDialog suiteDialog) {
            return suiteDialog.allSelect;
        }
    }

    private class CipherSuiteToolTipClient
    implements ToolTipClient {
        private SpreadTable table;

        public CipherSuiteToolTipClient(SpreadTable spreadTable) {
            SSLCipherSuitePanel.this = SSLCipherSuitePanel.this;
            this.table = spreadTable;
        }

        public ToolTipSite getToolTipSite(Component component, int n, int n2) {
            int n3 = this.table.getGrid().getRowAt(n2) + this.table.getFirstRowOnScreen();
            int n4 = this.table.getGrid().getColumnAt(n) + this.table.getFirstColumnOnScreen();
            if (n3 == -1) {
                return null;
            }
            Object object = SSLCipherSuitePanel.this;
            TwoDDataSource twoDDataSource = this.table.getGrid().getDataSource();
            if ((object = ((SSLCipherSuitePanel)object).getToolTipByCell(twoDDataSource, n3, n4)) == null) {
                return null;
            }
            return new ToolTipSite(object, this._getBoundsOfLabel(n, n2), null, null);
        }

        private Rectangle _getBoundsOfLabel(int n, int n2) {
            Grid grid = this.table.getGrid();
            int n3 = grid.getRowAt(n2);
            int n4 = grid.getColumnAt(n);
            if (n3 == -1) {
                return new Rectangle(n, n2, 1, 1);
            }
            return new Rectangle(grid.getColumnPosition(n4), grid.getRowPosition(n3), grid.getColumnWidth(n4), grid.getRowHeight(n3));
        }
    }
}

