/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.event.Cancelable;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.servicename.NetClientAddressPage;
import oracle.net.asst.uniword.UniWordWrapper;
import oracle.net.common.netObject.AddressList;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NVFactory;

public class AddressListPanel
extends EwtContainer
implements ActionListener,
TabPanelListener,
ItemListener {
    private static final int ADV_WIDTH = 400;
    private static final int ADV_HEIGHT = 400;
    public static final int SERVICE_DISPLAY_MODE = 0;
    public static final int DBSERVICE_DISPLAY_MODE = 1;
    public static final int NETSERVICE_DISPLAY_MODE = 2;
    private int m_currentMode;
    private NetStrings ns = new NetStrings();
    private String backCompatString = this.ns.getString("SNCBackCompatClient");
    private String addressString = this.ns.getString("SNCAddress");
    private String tcpString = this.ns.getString("SNCTCP");
    private String tcpsString = this.ns.getString("SNCTCPS");
    private String addressOptionString = this.ns.getString("SNCAddressOptions");
    private String newAddressString = this.ns.getString("SNCNew");
    private String deleteAddressString = this.ns.getString("SNCDelete");
    private String promoteAddressString = this.ns.getString("SNCPromote");
    private String demoteAddressString = this.ns.getString("SNCDemote");
    private String optionsString = this.ns.getString("SNCAdvanced");
    private String optionLBString = this.ns.getString("SNCAddrOptionLB");
    private String optionDefaultString = this.ns.getString("SNCAddrOptionDefault");
    private String optionNoFOString = this.ns.getString("SNCAddrOptionNoFO");
    private String optionSRString = this.ns.getString("SNCAddrOptionSR");
    private String optionNoneString = this.ns.getString("SNCAddrOptionNone");
    private String advancedTitleString = this.ns.getString("SNCAdvancedDialogTitle");
    private String addressOptionGroupString = this.ns.getString("SNCAddressOptionGroup");
    private String okString = this.ns.getString("SNCOK");
    private String cancelString = this.ns.getString("SNCCancel");
    private String helpString = this.ns.getString("SNCHelp");
    private String addAddressString = this.ns.getString("SNCAddAddress");
    private String svcHelpTopicString = "TOPICsnAdvancedAList";
    private String netSvcHelpTopicString = "TOPICsnAdvancedAList";
    private TabPanel tabPanel;
    private TabPanelPage currPage;
    private MultiLineLabel message;
    private LWButton newButton;
    private LWButton deleteButton;
    private LWButton optionsButton;
    private LWButton promoteButton;
    private LWButton demoteButton;
    private LWButton okButton;
    private LWButton cancelButton;
    private LWButton helpButton;
    private LWCheckbox backCompatBox;
    private LWCheckboxGroup cbg;
    private LWCheckbox optionBoxLB;
    private LWCheckbox optionBoxDefault;
    private LWCheckbox optionBoxNoFO;
    private LWCheckbox optionBoxSR;
    private LWCheckbox optionBoxNone;
    private EwtContainer addressPanel;
    private EwtContainer newDeletePanel;
    private EwtContainer optionGroupPanel;
    private EwtContainer advancedPanel;
    private EwtContainer buttonPanel;
    private BufferedDialog advancedDialog;
    private GridBagConstraints gbc = new GridBagConstraints();
    LWCheckbox currentCheckbox;
    boolean currentBCState;
    private boolean enabled = true;
    private boolean m_changed = false;
    private boolean dialogChanged = false;
    private int addrCounter;
    private EwtContainer m_cards;
    private CardLayout m_cardLayout;
    private AddressList m_aList;

    public AddressListPanel() {
        this.message = new 1();
        this.message.setTextWrapper(UniWordWrapper.getTextWrapper());
        this.message.setText("\n" + this.addAddressString);
        this.message.setAlignment(1);
        this.tabPanel = new TabPanel();
        this.tabPanel.addTabPanelListener((TabPanelListener)this);
        this.newDeletePanel = new EwtContainer();
        Toolkit toolkit = this.newDeletePanel.getToolkit();
        String string = NetUtils.getImageDirectory();
        this.newButton = new LWButton();
        this.newButton.setImage(toolkit.getImage(String.valueOf(string) + "create.gif"));
        this.newButton.setActionCommand("NEW");
        this.newButton.setLeftmost(true);
        this.newButton.setFocusable(false);
        this.newButton.addActionListener((ActionListener)this);
        this.deleteButton = new LWButton();
        this.deleteButton.setImage(toolkit.getImage(String.valueOf(string) + "delete.gif"));
        this.deleteButton.setActionCommand("DELETE");
        this.deleteButton.setRightmost(true);
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener((ActionListener)this);
        this.promoteButton = new LWButton();
        this.promoteButton.setActionCommand("PROMOTE");
        this.promoteButton.setLeftmost(true);
        this.promoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.leftArrow"), 1));
        this.promoteButton.setFocusable(false);
        this.promoteButton.addActionListener((ActionListener)this);
        this.demoteButton = new LWButton();
        this.demoteButton.setActionCommand("DEMOTE");
        this.demoteButton.setRightmost(true);
        this.demoteButton.setImageSet((ImageSet)new ImageStrip(UIManager.getDefaults().getImage((Object)"Shuttle.rightArrow"), 1));
        this.demoteButton.setFocusable(false);
        this.demoteButton.addActionListener((ActionListener)this);
        this.optionsButton = new LWButton(this.optionsString);
        this.optionsButton.setLeftmost(true);
        this.optionsButton.setRightmost(true);
        this.optionsButton.setActionCommand("ADVANCED");
        this.optionsButton.setFocusable(false);
        this.optionsButton.addActionListener((ActionListener)this);
        this.newDeletePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 3;
        this.newDeletePanel.add((Component)this.newButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.newDeletePanel.add((Component)this.deleteButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.newDeletePanel.add((Component)this.promoteButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.newDeletePanel.add((Component)this.demoteButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        this.newDeletePanel.add((Component)this.optionsButton, gridBagConstraints);
        this.m_cardLayout = new CardLayout();
        this.m_cards = new EwtContainer();
        this.m_cards.setLayout(this.m_cardLayout);
        this.m_cards.add((Component)this.tabPanel, "TABPANEL");
        this.m_cards.add((Component)this.message, "MESSAGE");
        this.addressPanel = new EwtContainer();
        this.addressPanel.setLayout(new BorderLayout(0, 3));
        this.addressPanel.add((Component)this.m_cards, "Center");
        this.addressPanel.add((Component)this.newDeletePanel, "South");
        this.cbg = new LWCheckboxGroup();
        this.optionBoxLB = new LWCheckbox(this.optionLBString, this.cbg, false);
        this.optionBoxDefault = new LWCheckbox(this.optionDefaultString, this.cbg, false);
        this.optionBoxNoFO = new LWCheckbox(this.optionNoFOString, this.cbg, false);
        this.optionBoxSR = new LWCheckbox(this.optionSRString, this.cbg, false);
        this.optionBoxNone = new LWCheckbox(this.optionNoneString, this.cbg, false);
        this.optionBoxLB.addItemListener((ItemListener)this);
        this.optionBoxDefault.addItemListener((ItemListener)this);
        this.optionBoxNoFO.addItemListener((ItemListener)this);
        this.optionBoxSR.addItemListener((ItemListener)this);
        this.optionBoxNone.addItemListener((ItemListener)this);
        this.optionGroupPanel = new EwtContainer();
        this.optionGroupPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(5, 10, 5, 10), (String)this.addressOptionGroupString));
        this.optionGroupPanel.setLayout(new GridBagLayout());
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 17;
        this.optionGroupPanel.add((Component)this.optionBoxDefault, this.gbc);
        this.gbc.gridy = 1;
        this.gbc.insets.top = 5;
        this.optionGroupPanel.add((Component)this.optionBoxLB, this.gbc);
        this.gbc.gridy = 2;
        this.optionGroupPanel.add((Component)this.optionBoxNoFO, this.gbc);
        this.gbc.gridy = 3;
        this.optionGroupPanel.add((Component)this.optionBoxSR, this.gbc);
        this.gbc.gridy = 4;
        this.optionGroupPanel.add((Component)this.optionBoxNone, this.gbc);
        this.backCompatBox = new LWCheckbox(this.backCompatString);
        this.backCompatBox.addItemListener((ItemListener)this);
        this.okButton = new LWButton(this.okString);
        this.okButton.setLeftmost(true);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener((ActionListener)this);
        this.cancelButton = new LWButton(this.cancelString);
        this.cancelButton.setRightmost(true);
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener((ActionListener)this);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.setRightmost(true);
        this.helpButton.setLeftmost(true);
        this.helpButton.setActionCommand("HELP");
        this.helpButton.addActionListener((ActionListener)this);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 0, 5, 0);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.buttonPanel.add((Component)this.helpButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets.right = 3;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 13;
        this.buttonPanel.add((Component)this.okButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets.right = 0;
        this.buttonPanel.add((Component)this.cancelButton, this.gbc);
        this.advancedPanel = new EwtContainer();
        this.advancedPanel.setLayout(new BorderLayout(5, 5));
        this.advancedPanel.add((Component)this.optionGroupPanel, "Center");
        this.advancedPanel.add((Component)this.backCompatBox, "South");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.addressPanel, "Center");
    }

    public void setAddressList(AddressList addressList, int n) {
        this.m_currentMode = n;
        this.m_aList = addressList;
        this.revert();
    }

    public AddressList getAddressList() {
        if (this.m_aList == null || this.m_aList.getNumAddresses() == 0) {
            return null;
        }
        return this.m_aList;
    }

    public void revert() {
        NetClientAddressPage netClientAddressPage;
        this.addrCounter = 0;
        this.backCompatBox.setState(this.m_aList.isBackCompat());
        this.tabPanel.removeTabPanelListener((TabPanelListener)this);
        this.tabPanel.removeAllPages();
        this.currPage = null;
        if (this.m_aList == null && this.m_currentMode == 2) {
            netClientAddressPage = new NetClientAddressPage(NetUtils.getApplication());
            this.tabPanel.addPage(String.valueOf(this.addressString) + ++this.addrCounter, (Component)((Object)netClientAddressPage));
            this.m_changed = true;
        }
        if (this.m_aList != null) {
            netClientAddressPage = null;
            int n = this.m_aList.getNumAddresses();
            int n2 = 0;
            while (n2 < n) {
                netClientAddressPage = new NetClientAddressPage(NetUtils.getApplication());
                netClientAddressPage.setAddressInfo(this.m_aList.getAddressAt(n2));
                this.tabPanel.addPage(String.valueOf(this.addressString) + ++this.addrCounter, (Component)((Object)netClientAddressPage));
                ++n2;
            }
        }
        this.tabPanel.addTabPanelListener((TabPanelListener)this);
        if (this.isAttribEnabled(this.m_aList.getSOURCE_ROUTE())) {
            this.optionBoxSR.setState(true);
        } else if (this.isAttribDisabled(this.m_aList.getFAILOVER())) {
            if (this.isAttribDisabled(this.m_aList.getLOAD_BALANCE())) {
                this.optionBoxNone.setState(true);
            } else {
                this.optionBoxNoFO.setState(true);
            }
        } else if (this.isAttribDisabled(this.m_aList.getLOAD_BALANCE())) {
            this.optionBoxDefault.setState(true);
        } else {
            this.optionBoxLB.setState(true);
        }
        if (this.tabPanel.getPageCount() == 0) {
            this.m_cardLayout.show((Container)this.m_cards, "MESSAGE");
        } else {
            this.currPage = this.tabPanel.getPage(0);
            this.m_cardLayout.show((Container)this.m_cards, "TABPANEL");
        }
        this.updateGUIState();
        this.updateBackCompatState();
        this.m_changed = false;
    }

    public boolean isChanged() {
        if (this.m_changed) {
            return true;
        }
        int n = 0;
        while (n < this.tabPanel.getPageCount()) {
            if (((NetClientAddressPage)((Object)this.tabPanel.getPage(n).getContent())).getChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.currPage != null) {
            return ((NetClientAddressPage)((Object)this.currPage.getContent())).checkFields();
        }
        return true;
    }

    public void apply() {
        if (!this.areDataValid()) {
            return;
        }
        if (this.m_aList == null) {
            if (this.tabPanel.getPageCount() > 0) {
                try {
                    this.m_aList = new AddressList(new NVFactory().createNVPair("(ADDRESS=(PROTOCOL=TCP)(HOST=1)(PORT=1))"));
                }
                catch (NetObjectException netObjectException) {
                    System.err.println(netObjectException.getMessage());
                    netObjectException.printStackTrace();
                }
                this.m_aList.removeAllAddresses();
            }
        } else {
            this.m_aList.removeAllAddresses();
            this.m_aList.removeAllAttributes();
        }
        if (this.m_aList != null) {
            int n = this.tabPanel.getPageCount();
            int n2 = 0;
            while (n2 < n) {
                NetClientAddressPage netClientAddressPage = (NetClientAddressPage)((Object)this.tabPanel.getPage(n2).getContent());
                netClientAddressPage.saveAddressInfo(this.m_aList);
                ++n2;
            }
            try {
                this.m_aList.setBackCompat(this.backCompatBox.getState());
                if (this.optionBoxDefault.getState()) {
                    this.m_aList.setSOURCE_ROUTE("OFF");
                    this.m_aList.setLOAD_BALANCE("OFF");
                    this.m_aList.setFAILOVER("ON");
                } else if (this.optionBoxLB.getState()) {
                    this.m_aList.setSOURCE_ROUTE("OFF");
                    this.m_aList.setLOAD_BALANCE("ON");
                    this.m_aList.setFAILOVER("ON");
                } else if (this.optionBoxNoFO.getState()) {
                    this.m_aList.setSOURCE_ROUTE("OFF");
                    this.m_aList.setLOAD_BALANCE("ON");
                    this.m_aList.setFAILOVER("OFF");
                } else if (this.optionBoxSR.getState()) {
                    this.m_aList.setSOURCE_ROUTE("ON");
                    this.m_aList.setLOAD_BALANCE("OFF");
                    this.m_aList.setFAILOVER("OFF");
                } else if (this.optionBoxNone.getState()) {
                    this.m_aList.setSOURCE_ROUTE("OFF");
                    this.m_aList.setFAILOVER("OFF");
                    this.m_aList.setLOAD_BALANCE("OFF");
                }
            }
            catch (Exception exception) {
                System.err.println("AddressListPanel.saveAddressInfo(): Exception while saving field data" + exception);
            }
        }
        this.m_changed = false;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        super.setEnabled(bl);
        this.tabPanel.setEnabled(bl);
        this.tabPanel.getSelectedPage().getContent().setEnabled(bl);
        Component[] componentArray = this.newDeletePanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        if (bl) {
            this.updateGUIState();
            this.updateBackCompatState();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.backCompatBox) {
            this.updateBackCompatState();
        }
        this.dialogChanged = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Component component = (Component)actionEvent.getSource();
        component.setEnabled(false);
        if (string.equals("HELP")) {
            if (this.m_currentMode == 2) {
                NetUtils.getHelpContext().showTopic(this.netSvcHelpTopicString);
            } else {
                NetUtils.getHelpContext().showTopic(this.svcHelpTopicString);
            }
        } else if (string.equals("ADVANCED")) {
            this.saveDialogSettings();
            this.displayAdvancedDialog();
        } else if (string.equals("CANCEL")) {
            this.cancelDialog();
        } else if (string.equals("OK")) {
            if (this.dialogChanged) {
                this.m_changed = true;
                this.dialogChanged = false;
            }
            this.advancedDialog.setVisible(false);
        } else if (string.equals("NEW")) {
            this.createNewAddressPage();
            this.m_changed = true;
        } else if (string.equals("DELETE")) {
            this.deleteCurrentAddressPage();
            this.m_changed = true;
        } else if (string.equals("PROMOTE")) {
            this.promoteCurrentAddressPage();
            this.m_changed = true;
        } else if (string.equals("DEMOTE")) {
            this.demoteCurrentAddressPage();
            this.m_changed = true;
        }
        component.setEnabled(true);
        this.updateGUIState();
    }

    protected void cancelDialog() {
        this.advancedDialog.setVisible(false);
        this.revertDialogSettings();
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        this.currPage = tabPanelEvent.getPage();
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (this.currPage != null && !((NetClientAddressPage)((Object)this.currPage.getContent())).checkFields()) {
            ((Cancelable)tabPanelEvent).cancel();
        }
    }

    private void createNewAddressPage() {
        if (this.currPage != null && !((NetClientAddressPage)((Object)this.currPage.getContent())).checkFields()) {
            return;
        }
        this.tabPanel.removeTabPanelListener((TabPanelListener)this);
        NetClientAddressPage netClientAddressPage = new NetClientAddressPage(NetUtils.getApplication());
        if (netClientAddressPage.getProtocolChoice().equals(this.tcpString) || netClientAddressPage.getProtocolChoice().equals(this.tcpsString)) {
            int n = 0;
            while (n < this.tabPanel.getPageCount()) {
                NetClientAddressPage netClientAddressPage2 = (NetClientAddressPage)((Object)this.tabPanel.getPage(n).getContent());
                if (netClientAddressPage2.getProtocolChoice().equals(this.tcpsString) || netClientAddressPage2.getProtocolChoice().equals(this.tcpString)) {
                    netClientAddressPage.setHost(netClientAddressPage2.getHost());
                    break;
                }
                ++n;
            }
        }
        if (this.tabPanel.getPageCount() == 0) {
            this.m_cardLayout.show((Container)this.m_cards, "TABPANEL");
        }
        this.currPage = this.tabPanel.addPage(String.valueOf(this.addressString) + ++this.addrCounter, (Component)((Object)netClientAddressPage));
        this.currPage.setSelected(true);
        this.tabPanel.addTabPanelListener((TabPanelListener)this);
        this.m_changed = true;
        this.updateGUIState();
    }

    private void deleteCurrentAddressPage() {
        if (this.currPage == null) {
            return;
        }
        this.tabPanel.removeTabPanelListener((TabPanelListener)this);
        this.tabPanel.removePage(this.currPage);
        this.tabPanel.addTabPanelListener((TabPanelListener)this);
        if (this.tabPanel.getPageCount() > 0) {
            this.currPage = this.tabPanel.getSelectedPage();
            int n = this.tabPanel.getPageCount();
            int n2 = this.tabPanel.getIndexOf(this.currPage);
            while (n2 < n) {
                this.tabPanel.getPage(n2).setLabel(String.valueOf(this.addressString) + (n2 + 1));
                ++n2;
            }
        } else {
            this.currPage = null;
            this.m_cardLayout.show((Container)this.m_cards, "MESSAGE");
        }
        --this.addrCounter;
        this.m_changed = true;
        this.updateGUIState();
    }

    private void displayAdvancedDialog() {
        Object object;
        if (this.advancedDialog == null) {
            this.advancedDialog = new BufferedDialog((Frame)((BufferedFrame)NetUtils.getApplication().getFrame()), this.advancedTitleString, true);
            this.advancedDialog.addWindowListener(new 2());
            this.advancedDialog.setLayout((LayoutManager)new GridBagLayout());
            object = new GridBagConstraints();
            ((GridBagConstraints)object).gridy = 0;
            ((GridBagConstraints)object).gridx = 0;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).gridwidth = 1;
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).insets = new Insets(10, 10, 5, 10);
            this.advancedDialog.add((Component)this.advancedPanel, object);
            ((GridBagConstraints)object).gridy = 1;
            ((GridBagConstraints)object).fill = 2;
            this.advancedDialog.add((Component)this.buttonPanel, object);
            this.advancedDialog.pack();
        }
        NetUtils.centerDialog((Dialog)this.advancedDialog, NetUtils.getApplication().getFrame());
        this.advancedDialog.setVisible(true);
        object = System.getProperty("os.name");
        if (((String)object).equals("Windows NT") || ((String)object).equals("Windows 95") || ((String)object).equals("Windows 98")) {
            NetUtils.getApplication().getFrame().toFront();
        }
        this.advancedDialog.dispose();
    }

    private void saveDialogSettings() {
        if (this.cbg != null) {
            this.currentCheckbox = this.cbg.getSelectedCheckbox();
        }
        if (this.backCompatBox != null) {
            this.currentBCState = this.backCompatBox.getState();
        }
    }

    private void revertDialogSettings() {
        if (this.currentCheckbox != null) {
            this.cbg.setSelectedCheckbox(this.currentCheckbox);
            this.backCompatBox.setState(this.currentBCState);
            this.updateBackCompatState();
        }
    }

    private void promoteCurrentAddressPage() {
        if (this.currPage == null) {
            return;
        }
        int n = this.tabPanel.getIndexOf(this.currPage);
        if (n == 0) {
            return;
        }
        if (!((NetClientAddressPage)((Object)this.currPage.getContent())).checkFields()) {
            return;
        }
        TabPanelPage tabPanelPage = this.tabPanel.getPage(n - 1);
        if (tabPanelPage == null) {
            return;
        }
        Component component = this.currPage.getContent();
        String string = this.currPage.getLabel();
        this.tabPanel.removePage(this.currPage);
        this.currPage = this.tabPanel.addPage(string, component, tabPanelPage, false);
        this.currPage.setSelected(true);
        this.m_changed = true;
    }

    private void demoteCurrentAddressPage() {
        if (this.currPage == null) {
            return;
        }
        int n = this.tabPanel.getIndexOf(this.currPage);
        if (n >= this.tabPanel.getPageCount() - 1) {
            return;
        }
        if (!((NetClientAddressPage)((Object)this.currPage.getContent())).checkFields()) {
            return;
        }
        TabPanelPage tabPanelPage = this.tabPanel.getPage(n + 1);
        if (tabPanelPage == null) {
            return;
        }
        Component component = tabPanelPage.getContent();
        String string = tabPanelPage.getLabel();
        this.tabPanel.removePage(tabPanelPage);
        this.tabPanel.addPage(string, component, this.currPage, false);
        this.currPage.setSelected(true);
        this.m_changed = true;
    }

    private void updateGUIState() {
        int n = this.tabPanel.getPageCount();
        this.newButton.setEnabled(true);
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.helpButton.setEnabled(true);
        this.promoteButton.setEnabled(false);
        this.demoteButton.setEnabled(false);
        this.optionsButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        if (n == 1 && this.m_currentMode != 2) {
            this.deleteButton.setEnabled(true);
        } else if (n > 1) {
            this.deleteButton.setEnabled(true);
            this.promoteButton.setEnabled(true);
            this.demoteButton.setEnabled(true);
            this.optionsButton.setEnabled(true);
        }
        if (((Component)((Object)this)).getParent() != null) {
            this.invalidate();
            ((Component)((Object)this)).getParent().validate();
        }
    }

    private void updateBackCompatState() {
        boolean bl = this.backCompatBox.getState();
        if (bl && (this.optionBoxLB.getState() || this.optionBoxNoFO.getState() || this.optionBoxNone.getState())) {
            this.optionBoxLB.setState(false);
            this.optionBoxNoFO.setState(false);
            this.optionBoxNone.setState(false);
            this.optionBoxDefault.setState(true);
        }
        this.optionBoxLB.setEnabled(!bl);
        this.optionBoxNoFO.setEnabled(!bl);
        this.optionBoxNone.setEnabled(!bl);
    }

    private boolean isAttribEnabled(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toUpperCase()).equals("ON") || string.equals("YES") || string.equals("TRUE") || string.equals("OK") || string.equals("USE");
    }

    private boolean isAttribDisabled(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toUpperCase()).equals("OFF") || string.equals("NO") || string.equals("FALSE");
    }

    private final class 1
    extends MultiLineLabel {
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AddressListPanel.this.cancelDialog();
        }

        /* synthetic */ 2() {
        }
    }
}

