/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.net.asst.container.ExceptionMessage;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.servicename.AddressListPanel;
import oracle.net.asst.servicename.ApplyChangesListener;
import oracle.net.asst.servicename.DBPanel;
import oracle.net.common.netObject.DBService;
import oracle.net.common.netObject.Description;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.common.netObject.NetService;
import oracle.net.common.netObject.Service;
import oracle.net.nl.NVFactory;

public class ConnectInfoEditor
extends EwtContainer
implements ActionListener {
    private NetObject m_serviceObject;
    private AddressListPanel m_addressPanel;
    private DBPanel m_dbPanel;
    private LWButton m_applyButton;
    private LWButton m_revertButton;
    private LWButton m_helpButton;
    private String m_helpTopic;
    private ApplyChangesListener m_changeListener;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private static final String HELP_TOPIC_NSVC = "TOPICsn";
    private static final String HELP_TOPIC_DBSVC = "TOPICsn";
    private static final String HELP_TOPIC_SVC = "TOPICsn";
    private boolean m_changedFlag;

    public ConnectInfoEditor(ApplyChangesListener applyChangesListener, boolean bl) {
        this.m_changeListener = applyChangesListener;
        NetStrings netStrings = new NetStrings();
        this.m_addressPanel = new AddressListPanel();
        this.m_addressPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 10, 10, 10), (String)netStrings.getString("SNCAddressGroup")));
        this.m_dbPanel = new DBPanel();
        this.m_dbPanel.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 10, 10, 10), (String)netStrings.getString("SNCServiceGroup")));
        this.m_applyButton = new LWButton(netStrings.getString("SNCApply"));
        this.m_applyButton.addActionListener((ActionListener)this);
        this.m_applyButton.setLeftmost(true);
        this.m_revertButton = new LWButton(netStrings.getString("SNCRevert"));
        this.m_revertButton.setRightmost(true);
        this.m_revertButton.addActionListener((ActionListener)this);
        this.m_helpButton = new LWButton(netStrings.getString("SNCHelp"));
        this.m_helpButton.addActionListener((ActionListener)this);
        this.m_helpButton.setLeftmost(true);
        this.m_helpButton.setRightmost(true);
        this.gbc = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.gridy = 0;
        ((Container)((Object)this)).add((Component)((Object)this.m_dbPanel), this.gbc);
        this.gbc.gridy = 1;
        this.gbc.fill = 2;
        this.gbc.insets.top = 15;
        ((Container)((Object)this)).add((Component)((Object)this.m_addressPanel), this.gbc);
        EwtContainer ewtContainer = new EwtContainer();
        if (bl) {
            ewtContainer.add((Component)this.m_applyButton);
            ewtContainer.add((Component)this.m_revertButton);
        }
        ewtContainer.add((Component)this.m_helpButton);
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(15, 2, 10, 0);
        this.gbc.gridy = 2;
        ((Container)((Object)this)).add((Component)ewtContainer, this.gbc);
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 20, 0, 20));
    }

    public void setService(NetObject netObject) {
        int n;
        Description description = null;
        this.m_serviceObject = netObject;
        this.m_changedFlag = false;
        if (this.m_serviceObject instanceof NetService) {
            description = ((NetService)this.m_serviceObject).getFirstDescription();
            n = 2;
            this.m_helpTopic = "TOPICsn";
        } else if (netObject instanceof DBService) {
            NetService netService = ((DBService)this.m_serviceObject).getNetService();
            description = netService != null ? netService.getFirstDescription() : this.createDummyDescription((Service)this.m_serviceObject);
            n = 1;
            this.m_helpTopic = "TOPICsn";
        } else if (this.m_serviceObject instanceof Service) {
            NetService netService = ((Service)this.m_serviceObject).getNetService();
            description = netService != null ? netService.getFirstDescription() : this.createDummyDescription((Service)this.m_serviceObject);
            n = 0;
            this.m_helpTopic = "TOPICsn";
        } else {
            throw new ClassCastException("unable to retrieve network information from class " + this.m_serviceObject.getClass());
        }
        this.m_dbPanel.setDescription(description, n);
        this.m_addressPanel.setAddressList(description != null ? description.getAddressList() : null, n);
    }

    public NetObject getService() {
        return this.m_serviceObject;
    }

    public void apply() {
        this.m_dbPanel.apply();
        this.m_addressPanel.apply();
        if (this.m_serviceObject instanceof Service) {
            if (this.m_addressPanel.getAddressList() == null || this.m_addressPanel.getAddressList().getNumAddresses() == 0) {
                ((Service)this.m_serviceObject).setNetService(null);
            } else if (((Service)this.m_serviceObject).getNetService() == null) {
                try {
                    ((Service)this.m_serviceObject).setNetService(new NetService("none", this.m_dbPanel.getDescription().toNVString()));
                }
                catch (NetObjectException netObjectException) {
                    netObjectException.printStackTrace();
                }
            }
        }
        this.m_changedFlag = false;
    }

    public void revert() {
        this.m_dbPanel.revert();
        this.m_addressPanel.revert();
    }

    public void markChanged() {
        this.m_changedFlag = true;
    }

    public boolean isChanged() {
        return this.m_changedFlag || this.m_addressPanel.isChanged() || this.m_dbPanel.isChanged();
    }

    public boolean areDataValid() {
        return this.m_addressPanel.areDataValid() && this.m_dbPanel.areDataValid();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(this.m_helpButton.getActionCommand())) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic(this.m_helpTopic);
            return;
        }
        if (string.equalsIgnoreCase(this.m_applyButton.getActionCommand())) {
            if (this.isChanged()) {
                this.apply();
                if (this.m_changeListener != null) {
                    try {
                        this.m_changeListener.applyChanges(this.m_serviceObject);
                        return;
                    }
                    catch (Exception exception) {
                        ExceptionMessage.display((Component)((Object)this), "Unable to write changes to directory.", exception);
                        this.markChanged();
                        return;
                    }
                }
            }
        } else if (string.equalsIgnoreCase(this.m_revertButton.getActionCommand())) {
            this.revert();
        }
    }

    private Description createDummyDescription(Service service) {
        String string;
        String string2 = service.getSID();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=null)(PORT=1))");
        stringBuffer.append("(CONNECT_DATA=");
        if (service instanceof DBService) {
            string = ((DBService)service).getGlobalName();
            if (string != null && !string.equals("")) {
                stringBuffer.append("(SERVICE_NAME=" + string + ")");
            } else if (string2 != null && !string2.equals("")) {
                stringBuffer.append("(SID=" + string2 + ")");
            } else {
                stringBuffer.append("(SERVICE_NAME=" + service.getName() + ")");
            }
        } else if (string2 != null && !string2.equals("")) {
            stringBuffer.append("(SID=" + string2 + ")");
        } else {
            stringBuffer.append("(SERVICE_NAME=" + service.getName() + ")");
        }
        string = service.getOracleHome();
        if (string != null) {
            stringBuffer.append("(ORACLE_HOME=" + string + ")");
        }
        stringBuffer.append("))");
        try {
            Description description = new Description(new NVFactory().createNVPair(stringBuffer.toString()));
            description.getAddressList().removeAllAddresses();
            return description;
        }
        catch (NetObjectException netObjectException) {
            netObjectException.printStackTrace();
            System.err.println("Unable to create default description - " + netObjectException.getMessage());
            return null;
        }
    }
}

