/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.alert.Alert;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.ExceptionMessage;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetNameDialog;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.servicename.ApplyChangesListener;
import oracle.net.asst.servicename.ConnectInfoEditor;
import oracle.net.asst.servicewizard.ServiceWizard;
import oracle.net.asst.servicewizard.TestConnDialog;
import oracle.net.common.dataStore.DBServiceDataStorer;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.NetObjectHandler;
import oracle.net.common.dataStore.NetServiceDataStorer;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.dataStore.ServiceDataStorer;
import oracle.net.common.netObject.DBService;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.common.netObject.Service;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeChildNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItemData;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeParentNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;

public class ServiceNameComponent
extends NetComponent
implements ApplyChangesListener {
    private WebApplication m_app;
    private NetContainer m_container;
    private NetVector m_objectVector;
    private NetVector m_unsupportedVector;
    private NetVector m_menuVector;
    private NetObjectMenu m_menuCreate;
    private NetObjectMenu m_menuDelete;
    private NetObjectMenu m_menuRename;
    private NetObjectMenu m_menuConnect;
    private NetVector m_toolbarVector;
    private NetObjectToolbar m_toolbarDelete;
    private NetObjectToolbar m_toolbarConnect;
    private NetPanel m_introPanel;
    private NetObject m_activeObject;
    private ServiceWizard m_theServiceWizard;
    private NetStrings m_ns;
    private String m_componentName;
    private boolean m_loaded;
    private boolean m_changed;
    private TreeParentNode m_treeNode;
    private DataStore m_dataStore;
    private ConnectInfoEditor m_serviceDisplay;

    public ServiceNameComponent(WebApplication webApplication, DataStore dataStore) {
        this.m_app = webApplication;
        this.m_container = NetUtils.getContainer();
        this.m_dataStore = dataStore;
        this.m_ns = new NetStrings();
        this.m_objectVector = new NetVector();
        this.m_unsupportedVector = new NetVector();
        this.m_componentName = this.m_ns.getString("SNCComponentName");
        this.m_serviceDisplay = new ConnectInfoEditor(this, dataStore instanceof LDAPDataStore);
        String string = null;
        string = dataStore instanceof LDAPDataStore ? this.m_ns.getString("SNCLDAPIntroMessage") : this.m_ns.getString("SNCIntroMessage");
        this.m_introPanel = new NetPanel(this.m_app, "SN_placebo.gif", string);
        this.m_menuVector = new NetVector();
        this.m_menuVector.addElement(new NetObjectMenu(this.m_ns.getString("CNTEdit"), this.m_ns.getString("CNTCreate"), true));
        this.m_menuDelete = new NetObjectMenu(this.m_ns.getString("CNTEdit"), this.m_ns.getString("CNTDelete"), false);
        this.m_menuVector.addElement(this.m_menuDelete);
        this.m_menuRename = new NetObjectMenu(this.m_ns.getString("CNTEdit"), this.m_ns.getString("CNTRename"), false);
        this.m_menuVector.addElement(this.m_menuRename);
        this.m_menuConnect = new NetObjectMenu(this.m_ns.getString("CNTTools"), this.m_ns.getString("SNCConnectMenu"), false);
        this.m_menuVector.addElement(this.m_menuConnect);
        this.m_toolbarVector = new NetVector();
        Image image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "test.gif");
        this.m_toolbarConnect = new NetObjectToolbar(this.m_ns.getString("SNCConnectMenu"), image, false);
        this.m_toolbarVector.addElement(this.m_toolbarConnect);
        this.m_toolbarVector.addElement(new NetObjectToolbar(this.m_ns.getString("CNTCreate"), null, true));
        this.m_toolbarDelete = new NetObjectToolbar(this.m_ns.getString("CNTDelete"), null, false);
        this.m_toolbarVector.addElement(this.m_toolbarDelete);
    }

    public DataStore getDataStore() {
        return this.m_dataStore;
    }

    public TreeItem getTreeNode(DataDrivenTree dataDrivenTree) {
        if (this.m_treeNode == null) {
            this.m_treeNode = new TreeParentNode((TreeDataSource)new ServiceCompDataSource(dataDrivenTree), (TreeProxy)new ServiceCompProxy(dataDrivenTree), "oracle_sysman_netasst_sn_comp");
        }
        this.m_treeNode.setExpanded(false);
        return this.m_treeNode;
    }

    public boolean save(DataStore dataStore) {
        boolean bl = false;
        if (this.m_activeObject != null && this.m_serviceDisplay.isChanged()) {
            if (!this.m_serviceDisplay.areDataValid()) {
                return false;
            }
            this.m_serviceDisplay.apply();
            bl = true;
        }
        if (this.m_dataStore instanceof FileDataStore) {
            try {
                if (!this.m_loaded) {
                    this.loadData();
                }
                NetServiceHandler netServiceHandler = ((FileDataStore)dataStore).getNetServiceHandler();
                int n = this.m_objectVector.size() - 1;
                while (n >= 0) {
                    netServiceHandler.addElement((NetService)this.m_objectVector.elementAt(n));
                    --n;
                }
                int n2 = this.m_unsupportedVector.size() - 1;
                while (n2 >= 0) {
                    netServiceHandler.addElement((NetService)this.m_unsupportedVector.elementAt(n2));
                    --n2;
                }
                netServiceHandler.save();
            }
            catch (DataStoreException dataStoreException) {
                ExceptionMessage.display((Component)((Object)this.m_container), "Error writing entry to local tnsnames.ora file", dataStoreException);
                return false;
            }
        }
        if (this.m_dataStore instanceof LDAPDataStore) {
            if (!this.m_loaded) {
                return true;
            }
            if (bl) {
                try {
                    this.writeLDAPEntry(this.m_serviceDisplay.getService());
                }
                catch (DataStoreException dataStoreException) {
                    dataStoreException.printStackTrace();
                    ExceptionMessage.display((Component)((Object)this.m_container), "Error writing: " + this.m_serviceDisplay.getService() + " to directory.", dataStoreException);
                }
            }
        }
        this.m_changed = false;
        return true;
    }

    public void refresh(DataStore dataStore) {
        if (this.m_dataStore instanceof FileDataStore && dataStore instanceof FileDataStore) {
            this.m_dataStore = dataStore;
        } else if (this.m_dataStore instanceof LDAPDataStore && dataStore instanceof LDAPDataStore) {
            this.m_dataStore = dataStore;
        }
        if (this.m_loaded) {
            this.loadData();
            ((DataDrivenTree)this.m_treeNode.getTree()).refreshTree((DTreeItem)this.m_treeNode);
            this.m_treeNode.setExpanded(false);
        }
    }

    public void create(Object object) {
        NetService netService;
        if (!this.m_loaded && !this.loadData()) {
            return;
        }
        if (this.m_activeObject != null && !this.m_treeNode.getTree().getSelection().selectItem((DTreeItem)this.m_treeNode)) {
            return;
        }
        BufferedFrame bufferedFrame = (BufferedFrame)this.m_app.getFrame();
        Vector vector = new Vector(this.m_objectVector.size() + this.m_unsupportedVector.size());
        int n = this.m_objectVector.size() - 1;
        while (n >= 0) {
            vector.addElement(this.m_objectVector.elementAt(n));
            --n;
        }
        int n2 = this.m_unsupportedVector.size() - 1;
        while (n2 >= 0) {
            vector.addElement(this.m_unsupportedVector.elementAt(n2));
            --n2;
        }
        String string = this.m_dataStore instanceof FileDataStore ? NetUtils.getDefaultDomain() : "";
        char[] cArray = null;
        cArray = this.m_dataStore instanceof LDAPDataStore ? new char[]{'.'} : new char[]{};
        this.m_theServiceWizard = new ServiceWizard(bufferedFrame, vector, string, cArray);
        this.m_theServiceWizard.go();
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            bufferedFrame.toFront();
        }
        if ((netService = this.m_theServiceWizard.getTheAddress()) != null) {
            if (this.m_dataStore instanceof LDAPDataStore) {
                try {
                    this.writeLDAPEntry(netService);
                }
                catch (DataStoreException dataStoreException) {
                    ExceptionMessage.display((Component)((Object)this.m_container), "Error writing service entry: " + netService, dataStoreException);
                    dataStoreException.printStackTrace();
                    return;
                }
            } else {
                this.m_changed = true;
            }
            this.m_objectVector.addElement(netService);
            ((DataDrivenTree)this.m_treeNode.getTree()).refreshTree((DTreeItem)this.m_treeNode);
            this.m_treeNode.setExpanded(true);
            this.selectChildNode(netService.getName());
        }
    }

    public void delete() {
        if (!this.m_loaded) {
            return;
        }
        if (this.m_activeObject == null) {
            return;
        }
        if (!(this.m_activeObject instanceof NetService)) {
            return;
        }
        this.m_objectVector.removeElement(this.m_activeObject);
        try {
            NetServiceHandler netServiceHandler = ((NetServiceDataStorer)((Object)this.m_dataStore)).getNetServiceHandler();
            netServiceHandler.removeElement(this.m_activeObject.getName());
        }
        catch (DataStoreException dataStoreException) {
            ExceptionMessage.display((Component)((Object)this.m_container), "Error removing: " + this.m_activeObject, dataStoreException);
            dataStoreException.printStackTrace();
        }
        if (this.m_dataStore instanceof FileDataStore) {
            this.m_changed = true;
        }
        this.m_activeObject = null;
        ((DataDrivenTree)this.m_treeNode.getTree()).refreshTree((DTreeItem)this.m_treeNode);
        if (this.m_treeNode.getItemCount() > 0) {
            this.m_treeNode.setExpanded(true);
        }
        this.m_treeNode.getTree().getSelection().selectItem((DTreeItem)this.m_treeNode);
    }

    public boolean isChanged() {
        if (!this.m_loaded) {
            return false;
        }
        return this.m_changed || this.m_activeObject != null && this.m_serviceDisplay.isChanged();
    }

    public String toString() {
        return this.m_componentName;
    }

    public NetVector getComponentMenus() {
        return this.m_menuVector;
    }

    public NetVector getComponentToolbar() {
        return this.m_toolbarVector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeComponentMenu(String string) {
        NetServiceHandler netServiceHandler;
        if (string.equals(this.m_ns.getString("SNCConnectMenu")) && this.m_activeObject != null) {
            if (!this.m_serviceDisplay.areDataValid()) return false;
            BufferedFrame bufferedFrame = (BufferedFrame)this.m_app.getFrame();
            NetObject netObject = this.m_serviceDisplay.getService();
            if (netObject instanceof Service) {
                netObject = ((Service)netObject).getNetService();
            }
            TestConnDialog testConnDialog = new TestConnDialog(bufferedFrame, this.m_ns, (NetService)netObject);
            NetUtils.centerDialog((Dialog)((Object)testConnDialog), (Component)bufferedFrame);
            ((Dialog)((Object)testConnDialog)).show();
            String string2 = System.getProperty("os.name");
            if (!string2.startsWith("Windows")) return true;
            bufferedFrame.toFront();
            return true;
        }
        if (!string.equals(this.m_ns.getString("CNTRename"))) return true;
        if (this.m_activeObject == null) {
            return true;
        }
        if (!(this.m_activeObject instanceof NetService)) {
            return true;
        }
        NetNameDialog netNameDialog = new NetNameDialog((BufferedFrame)this.m_app.getFrame(), null, this.m_ns.getString("SNCRenameInstructions"), null, null, null);
        String string3 = null;
        NetValidate netValidate = new NetValidate((BufferedFrame)this.m_app.getFrame());
        while (true) {
            ((Component)((Object)netNameDialog)).setVisible(true);
            string3 = netNameDialog.getName();
            if (string3 == null) {
                return true;
            }
            if ((string3 = string3.toLowerCase()).equals(this.m_activeObject.getName())) {
                return true;
            }
            if (string3.equals("") || !netValidate.validateName(string3)) {
                netValidate.showDialog(this.m_ns.getString("CNTNetNameFieldLabel"));
                continue;
            }
            if (this.m_dataStore instanceof LDAPDataStore && string3.indexOf(46) != -1) {
                netValidate.showDialog(this.m_ns.getString("CNTNetNameFieldLabel"));
                continue;
            }
            if (this.m_objectVector.findObjectByName(string3) == null && this.m_unsupportedVector.findObjectByName(string3) == null) break;
            netServiceHandler = new Alert(this.m_app.getFrame(), this.m_ns.getString("SNWDuplicate", new Object[]{string3}), 0, 1);
            netServiceHandler.runAlert();
        }
        try {
            netServiceHandler = ((NetServiceDataStorer)((Object)this.m_dataStore)).getNetServiceHandler();
            netServiceHandler.renameElement(this.m_activeObject.getName(), string3);
        }
        catch (DataStoreException dataStoreException) {
            ExceptionMessage.display((Component)((Object)this.m_container), "Unable to rename element in directory.", dataStoreException);
            dataStoreException.printStackTrace();
            return false;
        }
        this.m_changed = true;
        ((DataDrivenTree)this.m_treeNode.getTree()).refreshTree((DTreeItem)this.m_treeNode);
        this.m_treeNode.setExpanded(true);
        this.selectChildNode(string3);
        return true;
    }

    public boolean executeComponentToolbar(String string) {
        return true;
    }

    private boolean loadData() {
        this.m_objectVector.removeAllElements();
        this.m_unsupportedVector.removeAllElements();
        this.m_activeObject = null;
        this.m_changed = false;
        this.m_loaded = true;
        try {
            NetObject netObject;
            Enumeration enumeration;
            NetObjectHandler netObjectHandler;
            String string;
            if (this.m_dataStore instanceof LDAPDataStore) {
                if (!((LDAPDataStore)this.m_dataStore).isAuthenticated() && !NetUtils.authenticateLDAP((LDAPDataStore)this.m_dataStore, this.m_ns.getString("CNTAuthTitle"), this.m_ns.getString("CNTAuthMessage"))) {
                    throw new DataStoreException(this.m_ns.getString("CNTAuthError"));
                }
                this.m_dataStore.refresh();
            }
            if (this.m_dataStore instanceof DBServiceDataStorer) {
                string = null;
                netObjectHandler = ((DBServiceDataStorer)((Object)this.m_dataStore)).getDBServiceHandler();
                enumeration = netObjectHandler.enum();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        netObject = (DBService)netObjectHandler.getElement(string);
                        if (((Service)netObject).isSupported()) {
                            this.m_objectVector.addElement(netObject);
                            continue;
                        }
                        this.m_unsupportedVector.addElement(netObject);
                    }
                    catch (DataStoreException dataStoreException) {
                        ExceptionMessage.display((Component)((Object)this.m_container), "Error retreiving DBService: " + string, dataStoreException);
                        dataStoreException.printStackTrace();
                    }
                }
            }
            if (this.m_dataStore instanceof ServiceDataStorer) {
                string = null;
                netObjectHandler = ((ServiceDataStorer)((Object)this.m_dataStore)).getServiceHandler();
                enumeration = netObjectHandler.enum();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        netObject = (Service)netObjectHandler.getElement(string);
                        if (((Service)netObject).isSupported()) {
                            this.m_objectVector.addElement(netObject);
                            continue;
                        }
                        this.m_unsupportedVector.addElement(netObject);
                    }
                    catch (DataStoreException dataStoreException) {
                        ExceptionMessage.display((Component)((Object)this.m_container), "Error retreiving Service: " + string, dataStoreException);
                        dataStoreException.printStackTrace();
                    }
                }
            }
            if (this.m_dataStore instanceof NetServiceDataStorer) {
                string = null;
                netObjectHandler = ((NetServiceDataStorer)((Object)this.m_dataStore)).getNetServiceHandler();
                enumeration = netObjectHandler.enum();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        netObject = (NetService)netObjectHandler.getElement(string);
                        if (((NetService)netObject).isSupported()) {
                            this.m_objectVector.addElement(netObject);
                            continue;
                        }
                        this.m_unsupportedVector.addElement(netObject);
                    }
                    catch (DataStoreException dataStoreException) {
                        if (dataStoreException.errno == 4) continue;
                        ExceptionMessage.display((Component)((Object)this.m_container), "Error retreiving net service name: " + string, dataStoreException);
                        dataStoreException.printStackTrace();
                    }
                }
            }
            return true;
        }
        catch (DataStoreException dataStoreException) {
            this.m_objectVector.removeAllElements();
            this.m_unsupportedVector.removeAllElements();
            this.m_loaded = false;
            return false;
        }
    }

    private int applyChangesPrompt() {
        Alert alert = new Alert(this.m_app.getFrame(), this.m_ns.getString("SNCApplyChangesPrompt"), 1, 7);
        alert.setButtonLabel(1, this.m_ns.getString("SNCApply"));
        alert.setButtonLabel(2, this.m_ns.getString("CNTDiscard"));
        alert.setButtonLabel(4, this.m_ns.getString("CNTCancel"));
        alert.setTitle(this.m_ns.getString("CNTSavePromptTitle"));
        int n = alert.runAlert();
        alert.dispose();
        return n;
    }

    private void selectChildNode(String string) {
        ServiceCompDataSource serviceCompDataSource = (ServiceCompDataSource)this.m_treeNode.getDataSource();
        int n = this.m_treeNode.getItemCount() - 1;
        while (n >= 0) {
            if (((TreeItemData)serviceCompDataSource.getData(n)).getLabel().equalsIgnoreCase(string)) {
                this.m_treeNode.getTree().getSelection().selectItem(this.m_treeNode.getItem(n));
                return;
            }
            --n;
        }
    }

    public void applyChanges(Object object) throws Exception {
        if (!this.m_loaded) {
            throw new Exception("Unable to save changes - data not initialized");
        }
        if (this.m_dataStore instanceof LDAPDataStore) {
            this.writeLDAPEntry((NetObject)object);
        }
    }

    private void writeLDAPEntry(NetObject netObject) throws DataStoreException {
        if (netObject == null) {
            System.err.println("Attempted to save null service to Directory: ");
            new Throwable().printStackTrace();
            return;
        }
        if (netObject instanceof NetService) {
            ((LDAPDataStore)this.m_dataStore).getNetServiceHandler().addElement(netObject);
            return;
        }
        if (netObject instanceof DBService) {
            ((LDAPDataStore)this.m_dataStore).getDBServiceHandler().addElement(netObject);
            return;
        }
        if (netObject instanceof Service) {
            ((LDAPDataStore)this.m_dataStore).getServiceHandler().addElement(netObject);
        }
    }

    static /* synthetic */ NetContainer access$0(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_container;
    }

    static /* synthetic */ WebApplication access$1(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_app;
    }

    static /* synthetic */ NetPanel access$2(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_introPanel;
    }

    static /* synthetic */ NetObjectMenu access$3(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_menuConnect;
    }

    static /* synthetic */ NetObjectToolbar access$4(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_toolbarConnect;
    }

    static /* synthetic */ NetObjectMenu access$5(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_menuRename;
    }

    static /* synthetic */ NetObjectMenu access$6(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_menuDelete;
    }

    static /* synthetic */ NetObjectToolbar access$7(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_toolbarDelete;
    }

    static /* synthetic */ NetVector access$8(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_menuVector;
    }

    static /* synthetic */ NetVector access$9(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_toolbarVector;
    }

    static /* synthetic */ NetObject access$10(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_activeObject;
    }

    static /* synthetic */ ConnectInfoEditor access$11(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_serviceDisplay;
    }

    static /* synthetic */ DataStore access$12(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_dataStore;
    }

    static /* synthetic */ int access$13(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.applyChangesPrompt();
    }

    static /* synthetic */ void access$14(ServiceNameComponent serviceNameComponent, NetObject netObject) throws DataStoreException {
        serviceNameComponent.writeLDAPEntry(netObject);
    }

    static /* synthetic */ boolean access$15(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_changed;
    }

    static /* synthetic */ void access$16(ServiceNameComponent serviceNameComponent, boolean bl) {
        serviceNameComponent.m_changed = bl;
    }

    static /* synthetic */ void access$17(ServiceNameComponent serviceNameComponent, NetObject netObject) {
        serviceNameComponent.m_activeObject = netObject;
    }

    static /* synthetic */ NetVector access$18(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_objectVector;
    }

    static /* synthetic */ boolean access$19(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.m_loaded;
    }

    static /* synthetic */ boolean access$20(ServiceNameComponent serviceNameComponent) {
        return serviceNameComponent.loadData();
    }

    private class ServiceCompDataSource
    extends TreeDataSource {
        private TreeProxy sharedProxy;
        private Image svcIcon;
        private Image dbsvcIcon;
        private Image nsvcIcon;
        private boolean m_cleared;

        public ServiceCompDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ServiceNameComponent.this = ServiceNameComponent.this;
            ServiceNameComponent serviceNameComponent2 = ServiceNameComponent.this;
            serviceNameComponent2.getClass();
            this.sharedProxy = serviceNameComponent2.new ServiceProxy(dataDrivenTree);
            this.dbsvcIcon = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "DBService.gif");
            this.svcIcon = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "Service.gif");
            this.nsvcIcon = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "NetService.gif");
        }

        protected void internal_refreshData() {
            this.internal_clearData();
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            if (!serviceNameComponent.m_loaded && !(serviceNameComponent = ServiceNameComponent.this).loadData()) {
                return;
            }
            serviceNameComponent = ServiceNameComponent.this;
            if (serviceNameComponent.m_objectVector.size() > 0) {
                serviceNameComponent = ServiceNameComponent.this;
                serviceNameComponent = new OneDDataSourceEvent((Object)this, 2001, 0, serviceNameComponent.m_objectVector.size());
                this.processEvent((OneDDataSourceEvent)serviceNameComponent);
                this.m_cleared = false;
            }
        }

        protected DTreeItem internal_createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            Object object = ServiceNameComponent.this;
            object = (NetObject)((ServiceNameComponent)object).m_objectVector.elementAt(n);
            if (object instanceof DBService) {
                return new TreeChildNode(this.sharedProxy, "oracle_sysman_netasst_dbsvc_item");
            }
            if (object instanceof Service) {
                return new TreeChildNode(this.sharedProxy, "oracle_sysman_netasst_svc_item");
            }
            if (object instanceof NetService) {
                return new TreeChildNode(this.sharedProxy, "oracle_sysman_netasst_nsvc_item");
            }
            return null;
        }

        protected void internal_setData(int n, Object object) {
        }

        protected Object internal_getData(int n) {
            Object object = ServiceNameComponent.this;
            object = (NetObject)((ServiceNameComponent)object).m_objectVector.elementAt(n);
            if (object instanceof DBService) {
                return new TreeItemData(((NetObject)object).getName(), this.dbsvcIcon);
            }
            if (object instanceof Service) {
                return new TreeItemData(((NetObject)object).getName(), this.svcIcon);
            }
            if (object instanceof NetService) {
                return new TreeItemData(((NetObject)object).getName(), this.nsvcIcon);
            }
            return null;
        }

        protected int internal_getItemCount() {
            if (this.m_cleared) {
                return 0;
            }
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            return serviceNameComponent.m_objectVector.size();
        }

        protected void internal_clearData() {
            if (!this.m_cleared) {
                ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
                serviceNameComponent = new OneDDataSourceEvent((Object)this, 2002, 0, serviceNameComponent.m_objectVector.size());
                this.processEvent((OneDDataSourceEvent)serviceNameComponent);
                this.m_cleared = true;
            }
        }
    }

    private class ServiceCompProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public ServiceCompProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ServiceNameComponent.this = ServiceNameComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_container.setMenuStatus(null);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_container.setToolBarStatus(null);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_app.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_container.display(ServiceNameComponent.this, (Component)((Object)serviceNameComponent.m_introPanel));
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_menuConnect.setEnabled(false);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_toolbarConnect.setEnabled(false);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_menuRename.setEnabled(false);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_menuDelete.setEnabled(false);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_toolbarDelete.setEnabled(false);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_container.setMenuStatus(serviceNameComponent.m_menuVector);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_container.setToolBarStatus(serviceNameComponent.m_toolbarVector);
            serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_app.showStatus("");
        }
    }

    private class ServiceProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public ServiceProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ServiceNameComponent.this = ServiceNameComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            if (serviceNameComponent.m_activeObject == null) {
                return;
            }
            serviceNameComponent = ServiceNameComponent.this;
            if (serviceNameComponent.m_serviceDisplay.isChanged()) {
                serviceNameComponent = ServiceNameComponent.this;
                if (!serviceNameComponent.m_serviceDisplay.areDataValid()) {
                    ((Cancelable)dTreeSelectionEvent).cancel();
                    return;
                }
                serviceNameComponent = ServiceNameComponent.this;
                if (serviceNameComponent.m_dataStore instanceof LDAPDataStore) {
                    serviceNameComponent = ServiceNameComponent.this;
                    int n = serviceNameComponent.applyChangesPrompt();
                    if (n == 4) {
                        ((Cancelable)dTreeSelectionEvent).cancel();
                        return;
                    }
                    if (n == 1) {
                        try {
                            ServiceNameComponent serviceNameComponent2 = ServiceNameComponent.this;
                            serviceNameComponent2.m_serviceDisplay.apply();
                            serviceNameComponent2 = ServiceNameComponent.this;
                            Object object = ServiceNameComponent.this;
                            object = ((ServiceNameComponent)object).m_serviceDisplay.getService();
                            serviceNameComponent2.writeLDAPEntry((NetObject)object);
                        }
                        catch (DataStoreException dataStoreException) {
                            ServiceNameComponent serviceNameComponent3 = ServiceNameComponent.this;
                            ExceptionMessage.display((Component)((Object)serviceNameComponent3.m_container), "Unable to write changes to directory.", dataStoreException);
                            dataStoreException.printStackTrace();
                            ((Cancelable)dTreeSelectionEvent).cancel();
                            serviceNameComponent3 = ServiceNameComponent.this;
                            serviceNameComponent3.m_serviceDisplay.markChanged();
                            return;
                        }
                    }
                } else {
                    serviceNameComponent = ServiceNameComponent.this;
                    serviceNameComponent.m_serviceDisplay.apply();
                    serviceNameComponent = ServiceNameComponent.this;
                    serviceNameComponent.m_changed = true;
                }
            }
            ServiceNameComponent serviceNameComponent4 = ServiceNameComponent.this;
            serviceNameComponent4.m_activeObject = null;
            serviceNameComponent4 = ServiceNameComponent.this;
            serviceNameComponent4.m_container.setMenuStatus(null);
            serviceNameComponent4 = ServiceNameComponent.this;
            serviceNameComponent4.m_container.setToolBarStatus(null);
            serviceNameComponent4 = ServiceNameComponent.this;
            serviceNameComponent4.m_app.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            Object object;
            ServiceNameComponent serviceNameComponent = ServiceNameComponent.this;
            serviceNameComponent.m_activeObject = null;
            serviceNameComponent = ServiceNameComponent.this;
            int n = serviceNameComponent.m_objectVector.size() - 1;
            while (n >= 0) {
                object = ServiceNameComponent.this;
                object = (NetObject)((ServiceNameComponent)object).m_objectVector.elementAt(n);
                if (((NetObject)object).getName().equalsIgnoreCase(treeItem.getLabel())) {
                    ServiceNameComponent serviceNameComponent2 = ServiceNameComponent.this;
                    serviceNameComponent2.m_activeObject = object;
                    break;
                }
                --n;
            }
            object = ServiceNameComponent.this;
            if (((ServiceNameComponent)object).m_activeObject == null) {
                throw new NullPointerException("data for selected tree item not found: " + treeItem.getLabel());
            }
            object = ServiceNameComponent.this;
            if (((ServiceNameComponent)object).m_activeObject instanceof NetService) {
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuConnect.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_toolbarConnect.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuRename.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuDelete.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_toolbarDelete.setEnabled(true);
            } else {
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuConnect.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_toolbarConnect.setEnabled(true);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuRename.setEnabled(false);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_menuDelete.setEnabled(false);
                object = ServiceNameComponent.this;
                ((ServiceNameComponent)object).m_toolbarDelete.setEnabled(false);
            }
            object = ServiceNameComponent.this;
            object = ServiceNameComponent.this;
            ((ServiceNameComponent)object).m_container.setMenuStatus(((ServiceNameComponent)object).m_menuVector);
            object = ServiceNameComponent.this;
            object = ServiceNameComponent.this;
            ((ServiceNameComponent)object).m_container.setToolBarStatus(((ServiceNameComponent)object).m_toolbarVector);
            object = ServiceNameComponent.this;
            object = ServiceNameComponent.this;
            ((ServiceNameComponent)object).m_serviceDisplay.setService(((ServiceNameComponent)object).m_activeObject);
            object = ServiceNameComponent.this;
            object = ServiceNameComponent.this;
            ((ServiceNameComponent)object).m_container.display(ServiceNameComponent.this, (Component)((Object)((ServiceNameComponent)object).m_serviceDisplay));
            object = ServiceNameComponent.this;
            ((Component)((ServiceNameComponent)object).m_app.getFrame()).setCursor(Cursor.getDefaultCursor());
            object = ServiceNameComponent.this;
            ((ServiceNameComponent)object).m_app.showStatus("");
        }
    }
}

