/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class IPCWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_KEY = new String("ORCL");
    private EditTextField m_keyField;

    public IPCWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_contentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        LWLabel lWLabel = new LWLabel(this.m_netStrings.getString("SNWIPCPanTitle"));
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        MultiLineLabel multiLineLabel = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWIPCPanMsg"));
        multiLineLabel.setAlignment(1);
        LWLabel lWLabel2 = new LWLabel(this.m_netStrings.getString("SNWIPCPanKeyLbl"));
        this.m_keyField = new EditTextField(DEFAULT_KEY);
        ((Component)((Object)this.m_keyField)).addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_contentPanel.add((Component)lWLabel);
        gridBagLayout.setConstraints((Component)lWLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)multiLineLabel);
        gridBagLayout.setConstraints((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets.bottom = 50;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)lWLabel2);
        gridBagLayout.setConstraints((Component)lWLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_keyField));
        gridBagLayout.setConstraints((Component)((Object)this.m_keyField), gridBagConstraints);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        if (component.equals(this.m_keyField)) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        return !this.m_keyField.getText().equals("");
    }

    public Component getFocusComponent() {
        return this.m_keyField;
    }

    public void setParams(Address address) {
        if (address != null) {
            this.m_keyField.setText(address._getParameter("KEY"));
            return;
        }
        this.m_keyField.setText(DEFAULT_KEY);
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addressFactory = AddressFactory.getFactory();
        String string = "(ADDRESS=(PROTOCOL=" + IPCAddress.IPC_PROTOCOL + ")" + "(KEY=" + this.m_keyField.getText() + "))";
        return addressFactory.createAddress(string);
    }
}

