/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.BEQAddress;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.addr.SPXAddress;
import oracle.net.asst.addr.TCPAddress;
import oracle.net.asst.addr.TCPSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class ProtocolWizardPanel
extends GenericWizardPanel {
    private static final int VISIBLE_LIST_ITEMS = 5;
    private LWList m_protocolList;
    private String m_protocol;
    private Vector m_avail;

    public ProtocolWizardPanel(NetStrings netStrings, Vector vector) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_avail = vector;
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        MultiLineLabel multiLineLabel = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWProtPanMsg"));
        multiLineLabel.setAlignment(1);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWProtPanInstr"));
        multiLineLabel2.setAlignment(1);
        this.m_protocolList = new LWList(5, false);
        this.setupAvailProtocols();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_contentPanel.add((Component)multiLineLabel);
        gridBagLayout.setConstraints((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)multiLineLabel2);
        gridBagLayout.setConstraints((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 12;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)this.m_protocolList, gridBagConstraints);
        this.m_contentPanel.add((Component)this.m_protocolList);
    }

    public void setProtocol(Address address) {
        String string = "";
        if (address != null) {
            string = address.getProtocol();
            int n = 0;
            boolean bl = false;
            while (n < this.m_avail.size() && !bl) {
                if (this.m_avail.elementAt(n).equals(string)) {
                    this.m_protocolList.select(n);
                    bl = true;
                }
                ++n;
            }
            if (n > this.m_avail.size()) {
                this.m_protocolList.select(0);
                return;
            }
        } else {
            this.m_protocolList.select(0);
        }
    }

    public void setProtocol2(String string) {
        int n = 0;
        boolean bl = false;
        while (n < this.m_avail.size() && !bl) {
            if (((String)this.m_avail.elementAt(n)).equalsIgnoreCase(string)) {
                this.m_protocolList.select(n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.m_protocolList.select(0);
        }
    }

    public String getProtocol() {
        return (String)this.m_avail.elementAt(this.m_protocolList.getSelectedIndex());
    }

    public void setupAvailProtocols() {
        int n = 0;
        while (n < this.m_avail.size()) {
            if (this.m_avail.elementAt(n).equals(TCPAddress.TCP_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanTCP"));
            } else if (this.m_avail.elementAt(n).equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanTCPS"));
            } else if (this.m_avail.elementAt(n).equals(SPXAddress.SPX_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanSPX"));
            } else if (this.m_avail.elementAt(n).equals(NMPAddress.NMP_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanNMP"));
            } else if (this.m_avail.elementAt(n).equals(BEQAddress.BEQ_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanBEQ"));
            } else if (this.m_avail.elementAt(n).equals(IPCAddress.IPC_PROTOCOL)) {
                this.m_protocolList.add(this.m_netStrings.getString("SNWProtPanIPC"));
            }
            ++n;
        }
        this.m_protocolList.select(0);
    }

    public Component getFocusComponent() {
        return this.m_protocolList;
    }
}

