/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;
import oracle.net.common.netObject.NetService;

public class ServiceNameWizardPanel
extends GenericWizardPanel
implements KeyListener {
    private EditTextField m_serviceNameField;
    private String m_domain;
    private MultiLineLabel m_srvcname_label;
    private char[] m_illegalChars;

    public ServiceNameWizardPanel(NetStrings netStrings, String string, char[] cArray) {
        super(netStrings);
        this.setImage("images/NewName.gif");
        this.m_contentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.m_domain = string;
        this.m_illegalChars = cArray;
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        this.m_srvcname_label = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWSrvPanMsgCreate"));
        this.m_srvcname_label.setAlignment(1);
        LWLabel lWLabel = new LWLabel(this.m_netStrings.getString("SNWNewPanLbl"));
        this.m_serviceNameField = new EditTextField();
        ((Component)((Object)this.m_serviceNameField)).addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints((Component)this.m_srvcname_label, gridBagConstraints);
        this.m_contentPanel.add((Component)this.m_srvcname_label);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)lWLabel, gridBagConstraints);
        this.m_contentPanel.add((Component)lWLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)((Object)this.m_serviceNameField));
        gridBagLayout.setConstraints((Component)((Object)this.m_serviceNameField), gridBagConstraints);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        if (component.equals(this.m_serviceNameField)) {
            int n = 0;
            while (n < this.m_illegalChars.length) {
                if (this.m_illegalChars[n] == c) {
                    keyEvent.setKeyChar('\u0000');
                    return;
                }
                ++n;
            }
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (c == '.') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public Component getFocusComponent() {
        return this.m_serviceNameField;
    }

    public void setService(NetService netService) {
        if (netService != null) {
            this.m_serviceNameField.setText(netService.getName());
            return;
        }
        this.m_serviceNameField.setText("");
    }

    public String getService() {
        String string = this.m_serviceNameField.getText();
        if (string.equals("")) {
            return string;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        if (string.indexOf(46) == -1 && this.m_domain != null && !this.m_domain.equals("")) {
            return String.valueOf(string) + "." + this.m_domain;
        }
        return string;
    }

    public void setMessage(String string) {
        if (string != null) {
            this.m_srvcname_label.setText(string);
        }
    }
}

