/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class ServiceWizardPanel
extends GenericWizardPanel
implements ItemListener,
KeyListener {
    public static final int RB_TEST = 0;
    public static final int RB_CREATE = 1;
    public static final int RB_MODIFY = 2;
    public static final int RB_DELETE = 3;
    private static final int VISIBLE_LIST_ITEMS = 4;
    private int m_rememberServiceIndex;
    private EwtContainer m_actionPan;
    private EwtContainer m_targetPan;
    private EditTextField m_serviceField;
    private LWList m_serviceList;
    private LWCheckboxGroup m_radioGroup;
    private LWCheckbox m_modifyChkBox;
    private LWCheckbox m_deleteChkBox;
    private LWCheckbox m_testChkBox;
    private LWCheckbox m_createChkBox;
    private MultiLineLabel m_mainmsg;
    private String m_domain;

    public ServiceWizardPanel(NetStrings netStrings, Vector vector, String string) {
        super(netStrings);
        this.setImage("images/Begin.gif");
        this.m_domain = string;
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        this.m_mainmsg = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWSrvPanMsg"));
        this.m_mainmsg.setAlignment(1);
        LWLabel lWLabel = new LWLabel(this.m_netStrings.getString("SNWSrvPanNewLabel"));
        LWLabel lWLabel2 = new LWLabel(this.m_netStrings.getString("SNWSrvPanPickLabel"));
        this.m_serviceField = new EditTextField(10);
        ((Component)((Object)this.m_serviceField)).addKeyListener(this);
        this.m_serviceList = new LWList(4, false);
        int n = 0;
        while (n < vector.size()) {
            this.m_serviceList.add((String)vector.elementAt(n));
            ++n;
        }
        if (this.m_serviceList.getItemCount() > 0) {
            this.m_serviceList.select(0);
        }
        this.m_radioGroup = new LWCheckboxGroup();
        this.m_modifyChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanModifyCB"), this.m_radioGroup, false);
        this.m_modifyChkBox.addItemListener((ItemListener)this);
        this.m_deleteChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanDeleteCB"), this.m_radioGroup, false);
        this.m_deleteChkBox.addItemListener((ItemListener)this);
        this.m_testChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanTestCB"), this.m_radioGroup, false);
        this.m_testChkBox.addItemListener((ItemListener)this);
        this.m_createChkBox = new LWCheckbox(this.m_netStrings.getString("SNWSrvPanCreateCB"), this.m_radioGroup, true);
        this.m_createChkBox.addItemListener((ItemListener)this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_contentPanel.add((Component)this.m_mainmsg, gridBagConstraints);
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setBorder((Border)new GroupBoxBorder(this.m_netStrings.getString("SNWSrvPanServiceTle"), InsetFramePainter.getFramePainter(), 2));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        ewtContainer.setLayout(gridBagLayout2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.right = 5;
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        ewtContainer.add((Component)lWLabel, gridBagConstraints2);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        ewtContainer.add((Component)((Object)this.m_serviceField), gridBagConstraints2);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.gridy = 2;
        ewtContainer.add((Component)lWLabel2, gridBagConstraints2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridy = 3;
        gridBagLayout2.setConstraints((Component)this.m_serviceList, gridBagConstraints2);
        ewtContainer.add((Component)this.m_serviceList);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)ewtContainer, gridBagConstraints);
        this.m_actionPan = new EwtContainer();
        this.m_actionPan.setBorder((Border)new GroupBoxBorder(this.m_netStrings.getString("SNWSrvPanActionTle"), InsetFramePainter.getFramePainter(), 2));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.m_actionPan.setLayout(gridBagLayout3);
        EwtContainer ewtContainer2 = new EwtContainer();
        ewtContainer2.setLayout(new GridLayout(4, 1, 0, 8));
        ewtContainer2.add((Component)this.m_createChkBox);
        ewtContainer2.add((Component)this.m_modifyChkBox);
        ewtContainer2.add((Component)this.m_deleteChkBox);
        ewtContainer2.add((Component)this.m_testChkBox);
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.insets.left = 20;
        gridBagConstraints3.insets.right = 20;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.bottom = 0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagLayout3.setConstraints((Component)ewtContainer2, gridBagConstraints3);
        this.m_actionPan.add((Component)ewtContainer2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)this.m_actionPan, gridBagConstraints);
        this.setCreate();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        if (component.equals(this.m_serviceField)) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (c == '.') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            LWCheckbox lWCheckbox = this.m_radioGroup.getSelectedCheckbox();
            if (lWCheckbox == this.m_modifyChkBox) {
                this.setAlter();
            }
            if (lWCheckbox == this.m_deleteChkBox) {
                this.setAlter();
            }
            if (lWCheckbox == this.m_testChkBox) {
                this.setAlter();
            }
            if (lWCheckbox == this.m_createChkBox) {
                this.setCreate();
            }
        }
    }

    public Component getFocusComponent() {
        return this.m_serviceField;
    }

    public boolean isServiceSelected() {
        return this.m_serviceList.getSelectedIndex() != -1;
    }

    public String getSelectedService() {
        if (this.isServiceSelected()) {
            return this.m_serviceList.getSelectedItem();
        }
        return null;
    }

    public void removeListElement(String string) {
        this.m_serviceList.remove(string);
    }

    public void removeListElement(int n) {
        this.m_serviceList.remove(n);
    }

    public String getNewName() {
        String string = this.m_serviceField.getText();
        if (string.equals("")) {
            return string;
        }
        if (string.endsWith("." + this.m_domain)) {
            return string;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        if (!this.m_domain.equals("")) {
            return String.valueOf(string) + "." + this.m_domain;
        }
        return string;
    }

    public int getSelection() {
        LWCheckbox lWCheckbox = this.m_radioGroup.getSelectedCheckbox();
        if (lWCheckbox == this.m_modifyChkBox) {
            return 2;
        }
        if (lWCheckbox == this.m_deleteChkBox) {
            return 3;
        }
        if (lWCheckbox == this.m_testChkBox) {
            return 0;
        }
        if (lWCheckbox == this.m_createChkBox) {
            return 1;
        }
        throw new IllegalArgumentException("ServiceWizardPanel: Unexpected error - LWChoice(" + lWCheckbox + ").");
    }

    void setAlter() {
        this.m_serviceField.setEditable(false);
        if (this.m_serviceList.getItemCount() > 0) {
            try {
                this.m_serviceList.select(this.m_rememberServiceIndex);
            }
            catch (Exception exception) {}
        }
        this.m_serviceList.setEnabled(true);
    }

    void setCreate() {
        this.m_serviceField.setEditable(true);
        if (this.m_serviceList.getItemCount() > 0) {
            this.m_rememberServiceIndex = this.m_serviceList.getSelectedIndex();
            if (this.m_rememberServiceIndex == -1) {
                this.m_rememberServiceIndex = 0;
            }
            this.m_serviceList.deselect(this.m_rememberServiceIndex);
        }
        this.m_serviceList.setEnabled(false);
        this.m_serviceField.requestFocus();
    }
}

