/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.io.File;
import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileNetServiceHandler;
import oracle.net.common.dataStore.NetServiceDataStorer;
import oracle.net.common.dataStore.NetServiceHandler;

public class FileDataStore
extends DataStore
implements NetServiceDataStorer {
    private String adminDir;
    private FileNetServiceHandler netServiceHandler;

    public FileDataStore() {
        this(null);
    }

    public FileDataStore(String string) {
        this.adminDir = string == null ? NetGetEnv.getNetworkDir() : string;
        int n = this.adminDir.length() - 1;
        while (n >= 0) {
            if (this.adminDir.charAt(n) != File.separatorChar) break;
            --n;
        }
        this.adminDir = String.valueOf(this.adminDir.substring(0, n + 1)) + File.separatorChar;
    }

    public String getAdminDir() {
        return this.adminDir;
    }

    public NetServiceHandler getNetServiceHandler() throws DataStoreException {
        if (this.netServiceHandler == null) {
            this.netServiceHandler = new FileNetServiceHandler(this);
        }
        return this.netServiceHandler;
    }

    public void refresh() {
        if (this.netServiceHandler != null) {
            this.netServiceHandler.requestRefresh();
        }
    }

    public String toString() {
        return "FileDataStore [dir: " + this.getAdminDir() + "]";
    }

    private void loadNetServiceHandler() throws DataStoreException {
        this.netServiceHandler = new FileNetServiceHandler(this);
    }
}

