/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DBServiceDataStorer;
import oracle.net.common.dataStore.DBServiceHandler;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDBServiceHandler;
import oracle.net.common.dataStore.LDAPNetServiceHandler;
import oracle.net.common.dataStore.LDAPServiceHandler;
import oracle.net.common.dataStore.NetServiceDataStorer;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.dataStore.ServiceDataStorer;
import oracle.net.common.dataStore.ServiceHandler;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;

public class LDAPDataStore
extends DataStore
implements NetServiceDataStorer,
DBServiceDataStorer,
ServiceDataStorer {
    Config config;
    private LDAPNetServiceHandler netServiceHandler;
    private LDAPDBServiceHandler dbServiceHandler;
    private LDAPServiceHandler serviceHandler;
    private String contextAsDomain;
    private int m_authType = -1;
    private String[] m_credentials;
    private boolean m_authenticated;
    public static final String ORACLE_SOFTWARE_NAME = "OracleContext";
    public static final String ORACLE_SOFTWARE_RDN = "cn=OracleContext";

    public LDAPDataStore() throws DataStoreException {
        this._initConfig();
        String string = this.config.namingContext(true);
        if (string == null) {
            throw new DataStoreException("unable to construct LDAPDataStore: null admin context");
        }
        this._init(this.config.getDirectoryServers(true), this.config.getDirectoryType(), "cn=OracleContext," + string, this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String string) throws DataStoreException {
        this._initConfig();
        this._init(this.config.getDirectoryServers(true), this.config.getDirectoryType(), string, this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String[] stringArray, String string, String string2) throws DataStoreException {
        this._initConfig();
        this._init(stringArray, string, string2, this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String[] stringArray, String string, String string2, String string3) throws DataStoreException {
        this._initConfig();
        this._init(stringArray, string, string2, string3);
    }

    private void _init(String[] stringArray, String string, String string2, String string3) throws DataStoreException {
        if (this.config == null) {
            this._initConfig();
        }
        if (stringArray == null || string == null || string2 == null) {
            throw new DataStoreException("unable to construct LDAPDataStore: null parameter");
        }
        if (!string2.substring(0, ORACLE_SOFTWARE_RDN.length()).equalsIgnoreCase(ORACLE_SOFTWARE_RDN)) {
            throw new DataStoreException("unable to construct LDAPDataStore: invalid oracle context: " + string2);
        }
        this.config.setDirectoryServers(stringArray);
        this.config.setDirectoryType(string);
        String string4 = string2.substring(ORACLE_SOFTWARE_RDN.length() + 1, string2.length());
        this.config.namingContext(string4);
        if (string3 != null) {
            this.config.setConnectionTimeout(string3);
        }
        if (string4 != null && !string4.equals("")) {
            this.contextAsDomain = this.toDNSFromDN(string4);
            return;
        }
        this.contextAsDomain = "";
    }

    private void _initConfig() throws DataStoreException {
        try {
            String[] stringArray = new String[]{null, null};
            this.config = new Config(NetGetEnv.getOracleHome(), 1, stringArray);
            this.m_authenticated = false;
            this.config.netConfigUsesLDAP(true);
            return;
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException);
        }
    }

    public void refresh() {
        if (this.netServiceHandler != null) {
            this.netServiceHandler.requestRefresh();
        }
        if (this.dbServiceHandler != null) {
            this.dbServiceHandler.requestRefresh();
        }
        if (this.serviceHandler != null) {
            this.serviceHandler.requestRefresh();
        }
    }

    public ServiceHandler getServiceHandler() throws DataStoreException {
        if (this.serviceHandler == null) {
            this.serviceHandler = new LDAPServiceHandler(this);
        }
        return this.serviceHandler;
    }

    public NetServiceHandler getNetServiceHandler() throws DataStoreException {
        if (this.netServiceHandler == null) {
            this.netServiceHandler = new LDAPNetServiceHandler(this);
        }
        return this.netServiceHandler;
    }

    public DBServiceHandler getDBServiceHandler() throws DataStoreException {
        if (this.dbServiceHandler == null) {
            this.dbServiceHandler = new LDAPDBServiceHandler(this);
        }
        return this.dbServiceHandler;
    }

    public String toString() {
        return "LDAPDataStore [svr: " + this.config.getDirectoryServers(true)[0] + ", type: " + this.config.getDirectoryType() + ", ctxt: " + ORACLE_SOFTWARE_RDN + "," + this.config.namingContext(true) + ", home: " + this.config.OraHomeDir + "]";
    }

    public String getDirectoryType() {
        return this.config.getDirectoryType();
    }

    public String[] getDirectoryServers() {
        return this.config.getDirectoryServers(true);
    }

    public String getOracleContext() {
        return "cn=OracleContext," + this.config.namingContext(true);
    }

    public String getConnectionTimeout() {
        return this.config.getConnectionTimeout();
    }

    public int getAuthType() {
        return this.m_authType;
    }

    public String[] getCredentials() {
        return this.m_credentials;
    }

    public void setAuthInfo(int n, String[] stringArray) throws DataStoreException {
        try {
            this.config.getDS().setAuthInfo(n, stringArray);
            this.config.bind(n, stringArray);
            this.m_authType = n;
            this.m_credentials = stringArray;
            this.m_authenticated = true;
            return;
        }
        catch (ConfigException configException) {
            String string = configException.errno == 6 ? "authentication error" : (configException.errno == 5 ? "directory server error" : "unknown error");
            throw new DataStoreException(string, configException);
        }
    }

    public boolean isAuthenticated() {
        return this.m_authenticated;
    }

    public String[] getAlternateServers(String string, String string2) {
        return Config.getAlternateServers((String)string, (String)string2);
    }

    public String[] getNamingContexts(String string, String string2) {
        return Config.getNamingContexts((String)string, (String)string2);
    }

    public String[] getOracleContexts(String string, String string2, String string3) {
        String[] stringArray;
        int n;
        int n2 = n = this.m_authType != -1 ? this.m_authType : 1;
        if (this.m_credentials != null) {
            stringArray = this.m_credentials;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        String[] stringArray3 = stringArray;
        return Config.getOracleSoftware((String)string, (int)n, (String[])stringArray3, (String)string2, (String)string3);
    }

    public String[] getSubContexts(String string, String string2, String string3) {
        return Config.getSubContexts((String)string, (String)string2, (String)string3);
    }

    public String detectDSType(String string) {
        return Config.detectDSType((String)string);
    }

    String toDNSFromDN(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = this.config.getDS().explodeDN(string, true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                stringBuffer.append(stringArray[0]);
            } else {
                stringBuffer.append("." + stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    String addDNSDomain(String string) {
        if (string.endsWith(this.contextAsDomain)) {
            return string;
        }
        return String.valueOf(string) + "." + this.contextAsDomain;
    }

    String stripDNSDomain(String string) {
        if (string.endsWith(this.contextAsDomain)) {
            return string.substring(0, string.lastIndexOf(this.contextAsDomain) - 1);
        }
        return string;
    }

    private void loadServiceHandler() throws DataStoreException {
        this.serviceHandler = new LDAPServiceHandler(this);
    }

    private void loadDBServiceHandler() throws DataStoreException {
        this.dbServiceHandler = new LDAPDBServiceHandler(this);
    }

    private void loadNetServiceHandler() throws DataStoreException {
        this.netServiceHandler = new LDAPNetServiceHandler(this);
    }
}

