/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.config.Config;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LDAPNetServiceHandler
extends NetServiceHandler {
    private LDAPDataStore lds;

    LDAPNetServiceHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.lds = lDAPDataStore;
    }

    public void save() throws DataStoreException {
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                int n2 = 0;
                while (n2 < n) {
                    ServiceAlias.delete((Config)this.lds.config, (String)this.removeLog.elementAt(n2).toString());
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while removing ServiceAlias from LDAP" + this.lds, exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                ServiceAlias serviceAlias = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[]{2, 3};
                NetService netService = null;
                int n = this.changeLog.size();
                int n3 = 0;
                while (n3 < n) {
                    String string = this.changeLog.elementAt(n3).toString();
                    Object v = this.table.get(string);
                    if (!(v instanceof NetService)) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + netService);
                    }
                    netService = (NetService)v;
                    if (netService == null || netService.equals("NOT_LOADED")) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + netService);
                    }
                    serviceAlias = new ServiceAlias(this.lds.config, string);
                    vector.removeAllElements();
                    vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray));
                    serviceAlias.setEndpoints(vector);
                    serviceAlias.save(this.lds.config, true);
                    ++n3;
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
                return;
            }
            catch (ServiceAliasException serviceAliasException) {
                throw new DataStoreException("error writing ServiceAlias to: " + this.lds, serviceAliasException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new DataStoreException("error saving to: " + this.lds + " msg: ", sOExceptionConfig);
            }
        }
    }

    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = ServiceAlias.enum((Config)this.lds.config, null, (boolean)true);
            String string = null;
            int n = 0;
            while (n < stringArray.length) {
                string = this.lds.config.getDS().getCN(stringArray[n]);
                this.table.put(string, "NOT_LOADED");
                ++n;
            }
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    public String[] enumDomains() throws DataStoreException {
        return new String[]{this.lds.getOracleContext()};
    }

    public String[] enum(String string) throws DataStoreException {
        try {
            return ServiceAlias.enum((Config)this.lds.config, (String)string, (boolean)false);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        try {
            ServiceAlias serviceAlias = new ServiceAlias(this.lds.config, string);
            return new NetService("(" + string + "=" + serviceAlias.toString() + ")");
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }
}

