/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.ServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.common.netObject.Service;
import oracle.net.config.Config;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;

public class LDAPServiceHandler
extends ServiceHandler {
    private LDAPDataStore lds;

    LDAPServiceHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.lds = lDAPDataStore;
    }

    public void save() throws DataStoreException {
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                int n2 = 0;
                while (n2 < n) {
                    ServiceAlias.delete((Config)this.lds.config, (String)this.removeLog.elementAt(n2).toString());
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while removing Service from LDAP" + this.lds, exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                oracle.net.config.Service service = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[]{2, 3};
                Service service2 = null;
                int n = this.changeLog.size();
                int n3 = 0;
                while (n3 < n) {
                    String string = this.changeLog.elementAt(n3).toString();
                    Object v = this.table.get(string);
                    if (!(v instanceof Service)) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + service2);
                    }
                    service2 = (Service)v;
                    service = new oracle.net.config.Service(this.lds.config, string);
                    vector.removeAllElements();
                    NetService netService = service2.getNetService();
                    if (netService != null) {
                        vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray));
                    }
                    if (vector.size() == 0) {
                        service.remEndpoints();
                    } else {
                        service.setEndpoints(vector);
                    }
                    service.systemName = service2.getSystemName();
                    service.serviceType = service2.getServiceType();
                    service.oracleHome = service2.getOracleHome();
                    service.sid = service2.getSID();
                    service.save(this.lds.config, true);
                    ++n3;
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
                return;
            }
            catch (ServiceAliasException serviceAliasException) {
                throw new DataStoreException("error writing ServiceAlias to: " + this.lds, serviceAliasException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new DataStoreException("error saving to: " + this.lds, sOExceptionConfig);
            }
        }
    }

    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = oracle.net.config.Service.enum((Config)this.lds.config, null, (boolean)true);
            String string = null;
            int n = 0;
            while (n < stringArray.length) {
                string = this.lds.config.getDS().getCN(stringArray[n]);
                this.table.put(string, "NOT_LOADED");
                ++n;
            }
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        String string2 = null;
        NetService netService = null;
        oracle.net.config.Service service = null;
        try {
            service = new oracle.net.config.Service(this.lds.config, string);
            string2 = service.toString();
            if (string2 != null) {
                netService = new NetService("(" + string + "=" + service.toString() + ")");
            }
            return new Service(string, service.systemName, service.serviceType, service.oracleHome, service.sid, netService);
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }
}

