/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.netObject.NetObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class NetObjectHandler {
    public static final String NOT_LOADED = "NOT_LOADED";
    protected Hashtable table = new NormalizedHashtable();
    protected Vector changeLog = new Vector();
    protected Vector removeLog = new Vector();
    protected boolean tableInitialized;
    protected boolean refreshRequested;
    protected boolean bufferChanges = false;

    NetObjectHandler(boolean bl) {
        this.bufferChanges = bl;
    }

    public abstract void load() throws DataStoreException;

    public abstract void save() throws DataStoreException;

    protected abstract NetObject getElementFromDataStore(String var1) throws DataStoreException;

    public void discard() throws DataStoreException {
        if (this.isBuffered() && this.tableInitialized) {
            this.load();
        }
    }

    public void requestRefresh() {
        this.refreshRequested = true;
    }

    public NetObject getElement(String string) throws DataStoreException {
        this.deferredInit();
        if (this.table.containsKey(string)) {
            Object object = this.table.get(string);
            if (object == NOT_LOADED) {
                object = this.getElementFromDataStore(string);
                if (object == null) {
                    throw new DataStoreException(String.valueOf(this.getClass()) + ".getElement(): " + "unable to find expected element, " + string + " in dataStore.");
                }
                this.table.put(string, object);
            }
            return (NetObject)object;
        }
        return null;
    }

    public Enumeration enum() throws DataStoreException {
        this.deferredInit();
        return this.table.keys();
    }

    public boolean exists(String string) throws DataStoreException {
        this.deferredInit();
        return this.table.containsKey(string);
    }

    public void addElement(NetObject netObject) throws DataStoreException {
        this.deferredInit();
        if (netObject == null || netObject.getName() == null) {
            throw new DataStoreException("NetObjectHandler.addElement: attempt to add element with null name or null value");
        }
        this.table.put(netObject.getName(), netObject);
        this.changeLog.addElement(netObject.getName());
        this.maybeCommit();
    }

    public void renameElement(String string, String string2) throws DataStoreException {
        this.deferredInit();
        if (!this.table.containsKey(string)) {
            throw new DataStoreException("Expected element: " + string + " not found");
        }
        Object object = this.table.remove(string);
        if (object == NOT_LOADED) {
            object = this.getElementFromDataStore(string);
        }
        ((NetObject)object).setName(string2);
        this.table.put(string2, object);
        this.changeLog.addElement(string2);
        if (this.changeLog.contains(string)) {
            this.changeLog.removeElement(string);
        }
        this.removeLog.addElement(string);
        this.maybeCommit();
    }

    public void removeAllElements() throws DataStoreException {
        this.deferredInit();
        boolean bl = this.isBuffered();
        this.setBuffered(true);
        Enumeration enumeration = this.enum();
        while (enumeration.hasMoreElements()) {
            this.removeElement((String)enumeration.nextElement(), false);
        }
        this.setBuffered(bl);
        this.maybeCommit();
    }

    public NetObject removeElement(String string) throws DataStoreException {
        return this.removeElement(string, true);
    }

    private NetObject removeElement(String string, boolean bl) throws DataStoreException {
        this.deferredInit();
        NetObject netObject = null;
        if (!this.table.containsKey(string)) {
            return null;
        }
        netObject = (NetObject)this.table.remove(string);
        if (netObject == NOT_LOADED && bl) {
            netObject = this.getElementFromDataStore(string);
        }
        if (this.changeLog.contains(string)) {
            this.changeLog.removeElement(string);
        }
        this.removeLog.addElement(string);
        this.maybeCommit();
        if (netObject == null) {
            return null;
        }
        return netObject;
    }

    public boolean isBuffered() {
        return this.bufferChanges;
    }

    public void setBuffered(boolean bl) {
        this.bufferChanges = bl;
    }

    protected void deferredInit() throws DataStoreException {
        if (this.refreshRequested) {
            if (this.tableInitialized) {
                this.load();
            }
            this.refreshRequested = false;
        }
        if (!this.tableInitialized) {
            this.load();
            this.tableInitialized = true;
        }
    }

    protected void maybeCommit() throws DataStoreException {
        if (!this.isBuffered()) {
            this.save();
        }
    }

    private class NormalizedHashtable
    extends Hashtable {
        public Object norm(Object object) {
            if (object instanceof String) {
                return ((String)object).toLowerCase();
            }
            return object;
        }

        public boolean containsKey(Object object) {
            return super.containsKey(this.norm(object));
        }

        public Object get(Object object) {
            return super.get(this.norm(object));
        }

        public Object put(Object object, Object object2) {
            return super.put(this.norm(object), object2);
        }

        public Object remove(Object object) {
            return super.remove(this.norm(object));
        }

        NormalizedHashtable() {
            NetObjectHandler.this = NetObjectHandler.this;
        }
    }
}

