/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.help;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import oracle.help.Book;
import oracle.help.Help;
import oracle.help.TopicNotFoundException;
import oracle.net.common.help.HelpSystem;

public class KomodoHelp
implements HelpSystem {
    private Help help;
    private Book book;
    private boolean helpInitialized = false;
    private Frame callerFrame;
    private String title = "Help";
    private Point TOPIC_LOC = new Point(0, 0);
    private Dimension TOPIC_DIM = new Dimension(500, 500);

    public KomodoHelp(Frame frame, String string, String string2, Class clazz, String string3) throws InstantiationException {
        this.callerFrame = frame;
        this.title = string3;
        try {
            this.help = new Help(Class.forName("oracle.help.htmlBrowser.ICEBrowser"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstantiationException("Failed to initialize Help browser.");
        }
        this.book = clazz != null ? Help.createBook((Class)clazz, (String)string, (String)string2, (String)string3) : Help.createBook((String)string, (String)string2, (String)string3);
        if (this.book == null) {
            throw new InstantiationException("Failed to initialize help system.");
        }
        this.help.addBook(this.book);
        this.helpInitialized = true;
    }

    public KomodoHelp(Frame frame, String string, String string2, Class clazz, String string3, Dimension dimension, Point point) throws InstantiationException {
        this(frame, string, string2, clazz, string3);
        this.TOPIC_LOC = point;
        this.TOPIC_DIM = dimension;
    }

    public void showTopic(String string) {
        if (this.helpInitialized) {
            ((Component)this.callerFrame).setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.help.showTopic(this.book, string, false, this.TOPIC_LOC, this.TOPIC_DIM);
            }
            catch (TopicNotFoundException topicNotFoundException) {
                System.err.println(topicNotFoundException.getMessage());
            }
            ((Component)this.callerFrame).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void showContents() {
        if (this.helpInitialized) {
            this.help.showContents();
        }
    }

    public void showIndex() {
        if (this.helpInitialized) {
            this.help.showIndex();
        }
    }

    public void showSearch() {
        if (this.helpInitialized) {
            this.help.showSearch();
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSize(Dimension dimension) {
        this.TOPIC_DIM = dimension;
    }

    public Dimension getSize() {
        return this.TOPIC_DIM;
    }

    public void setLocation(Point point) {
        this.TOPIC_LOC = point;
    }

    public Point getLocation() {
        return this.TOPIC_LOC;
    }
}

