/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import oracle.jsp.provider.JspClassProvider;
import oracle.jsp.provider.JspResourceProvider;

public class JspClassLoader
extends JspClassProvider {
    static final String APPLICATION_CLASSES = "/WEB-INF/classes";
    static final String APPLICATION_JARS = "/WEB-INF/lib";
    private static int generationCounter;
    private boolean needsInit = true;
    private int generation;
    private Hashtable cache;
    private Vector repository;
    private static final String MSG_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs;

    public static Vector classRepositoryFromString(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public JspClassLoader() {
    }

    public JspClassLoader(Vector vector) {
        this.init(vector);
    }

    public void init(Vector vector) throws IllegalArgumentException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        this.cache = new Hashtable();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.verifyRepository(enumeration.nextElement());
            }
        }
        this.repository = vector;
        this.generation = generationCounter++;
    }

    public synchronized boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public synchronized void addRepository(Vector vector, boolean bl) throws IllegalArgumentException {
        if (this.repository == null) {
            this.repository = new Vector(vector.size(), 5);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                this.repository.addElement(this.verifyPath(enumeration.nextElement()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) continue;
                throw illegalArgumentException;
            }
        }
    }

    public synchronized void addClassPath(String string, boolean bl) throws IllegalArgumentException {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.isEmpty()) {
            throw new IllegalArgumentException(msgs.getString("no_clspath"));
        }
        if (this.repository == null) {
            this.repository = new Vector(vector.size(), 5);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                this.repository.addElement(this.verifyPath(enumeration.nextElement()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) continue;
                throw illegalArgumentException;
            }
        }
    }

    public synchronized void addClassPath(JspResourceProvider jspResourceProvider, String string, boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException(msgs.getString("pcp_not_impl"));
    }

    public synchronized void addApplicationPath(JspResourceProvider jspResourceProvider) {
        try {
            this.addClassPath(jspResourceProvider.getAbsolutePath(APPLICATION_CLASSES), true);
        }
        catch (Throwable throwable) {}
        String[] stringArray = jspResourceProvider.listClassRepositories(APPLICATION_JARS);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.addClassPath(jspResourceProvider.getAbsolutePath("/WEB-INF/lib/" + stringArray[n]), true);
            }
            catch (Throwable throwable) {}
            ++n;
        }
    }

    public synchronized void addProvider(JspResourceProvider jspResourceProvider) {
        throw new IllegalArgumentException(msgs.getString("racp_not_impl"));
    }

    public Vector makeRepository(Vector vector, boolean bl) throws IllegalArgumentException {
        Vector<File> vector2 = new Vector<File>(vector.size(), 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                vector2.addElement(this.verifyPath(enumeration.nextElement()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) continue;
                throw illegalArgumentException;
            }
        }
        return vector2;
    }

    private File verifyPath(Object object) throws IllegalArgumentException {
        String string;
        try {
            string = (String)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_string"), object));
        }
        return this.verifyRepository(new File(string));
    }

    private File verifyRepository(Object object) throws IllegalArgumentException {
        File file;
        try {
            file = (File)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_file"), object));
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_rep"), file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("no_read"), file.getAbsolutePath()));
        }
        if (!file.isDirectory() && !this.isZipOrJarArchive(file)) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("bad_jar"), file.getAbsolutePath()));
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
            }
            catch (ZipException zipException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            Object var5_4 = null;
            if (zipFile == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    public JspClassProvider reinstantiate() {
        return new JspClassLoader(this.repository);
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized Class loadClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        var3_3 = null;
        try {
            return Class.forName(var1_1);
        }
        catch (ClassNotFoundException v0) {
            var4_4 = (ClassCacheEntry)this.cache.get(var1_1);
            if (var4_4 != null) {
                var3_3 = var4_4.loadedClass;
                if (var2_2) {
                    this.resolveClass(var3_3);
                }
                return var3_3;
            }
            if (!this.securityAllowsClass(var1_1)) {
                return this.loadSystemClass(var1_1, var2_2);
            }
            try {
                var3_3 = this.loadSystemClass(var1_1, var2_2);
                if (var3_3 != null) {
                    if (var2_2) {
                        this.resolveClass(var3_3);
                    }
                    return var3_3;
                }
            }
            catch (Exception v1) {
                var3_3 = null;
            }
            if (this.repository == null) {
                throw new ClassNotFoundException();
            }
            var5_5 = this.repository.elements();
            var6_6 = new ClassCacheEntry();
            ** while (var5_5.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            var8_8 = (File)var5_5.nextElement();
            try {
                var7_7 = var8_8.isDirectory() ? this.loadClassFromDirectory(var8_8, var1_1, var6_6) : this.loadClassFromZipfile(var8_8, var1_1, var6_6);
            }
            catch (IOException v2) {
                var7_7 = null;
            }
            if (var7_7 == null) continue;
            var6_6.loadedClass = var3_3 = this.defineClass(var1_1, var7_7, 0, var7_7.length);
            var6_6.lastModified = var6_6.origin.lastModified();
            this.cache.put(var1_1, var6_6);
            if (var2_2) {
                this.resolveClass(var3_3);
            }
            return var3_3;
        }
lbl41:
        // 1 sources

        throw new ClassNotFoundException(var1_1);
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> clazz = this.findSystemClass(string);
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = String.valueOf(string.replace('.', File.separatorChar)) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            byte[] byArray;
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        byte[] byArray;
        ZipFile zipFile;
        block4: {
            byte[] byArray2;
            block3: {
                String string2 = String.valueOf(string.replace('.', '/')) + ".class";
                zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry(string2);
                    if (zipEntry != null) {
                        classCacheEntry.origin = file;
                        byArray2 = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                        Object var8_9 = null;
                        break block3;
                    }
                    byArray = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    zipFile.close();
                    throw throwable;
                }
            }
            zipFile.close();
            return byArray2;
        }
        Object var8_10 = null;
        zipFile.close();
        return byArray;
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && this.repository != null) {
            Enumeration enumeration = this.repository.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                inputStream = file.isDirectory() ? this.loadResourceFromDirectory(file, string) : this.loadResourceFromZipfile(file, string);
                if (inputStream != null) break;
            }
        }
        return inputStream;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipFile.getInputStream(zipEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null || this.repository == null) {
            return uRL;
        }
        Enumeration enumeration = this.repository.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            File file;
            File file2 = (File)enumeration.nextElement();
            if (!file2.isDirectory() || !(file = new File(file2, string2 = string.replace('/', File.separatorChar))).exists()) continue;
            try {
                return new URL("file://" + file.getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static {
        msgs = ResourceBundle.getBundle(MSG_FILE);
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        public boolean isSystemClass() {
            return this.origin == null;
        }

        ClassCacheEntry() {
        }
    }
}

