/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.app;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import oracle.jsp.app.JspApplication;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtime.JspServletContext;
import oracle.jsp.util.JspVersion;

public class JspGlobals {
    public static final String GLOBALS = "Globals";
    public static final String GLOBALS_JSP = "globals.jsa";
    public static final String GLOBALS_JAVA = "Globals.java";
    public static final String GLOBALS_CLASS = "Globals.class";
    public static final String GLOBALS_SERIAL = "globals.ser";
    private Object instance;
    private JspResourceProvider provider;
    private JspResourceProvider repository;
    private String path;
    private JspApplication application;
    private long modified;
    private Object globalInfo;
    private boolean hasSerialized;

    public JspGlobals(Object object, JspApplication jspApplication, String string, JspResourceProvider jspResourceProvider, JspResourceProvider jspResourceProvider2, long l, Object object2) {
        this.path = string;
        this.provider = jspResourceProvider;
        this.repository = jspResourceProvider2;
        this.instance = object;
        this.application = jspApplication;
        this.modified = l;
        this.globalInfo = object2;
        this.hasSerialized = false;
        ServletContext servletContext = this.application.getServletContext();
        if (JspVersion.getServletVersion(this.application.getNativeServletContext()) == 1) {
            ((JspServletContext)servletContext).setAttribute("oracle.jsp.jspGlobals", this.instance);
        } else {
            servletContext.setAttribute("oracle.jsp.jspGlobals", this.instance);
        }
        this.application.setGlobals(this);
        this.application.notifyApplicationEvent(0);
    }

    public void invalidate() {
        ServletContext servletContext = this.application.getServletContext();
        String string = (String)servletContext.getAttribute("oracle.jsp.appOnEndNotified");
        if (string == null) {
            this.application.notifyApplicationEvent(1);
            if (JspVersion.getServletVersion(servletContext) == 1) {
                ((JspServletContext)servletContext).setAttribute("oracle.jsp.appOnEndNotified", "true");
            } else {
                servletContext.setAttribute("oracle.jsp.appOnEndNotified", (Object)"true");
            }
        }
        this.serializeInfo();
        if (JspVersion.getServletVersion(servletContext) == 1) {
            ((JspServletContext)servletContext).removeAttribute("oracle.jsp.jspGlobals");
            return;
        }
        servletContext.removeAttribute("oracle.jsp.jspGlobals");
    }

    public static Object deserializeInfo(JspResourceProvider jspResourceProvider) {
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            inputStream = jspResourceProvider.fromStream(GLOBALS_SERIAL);
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception2) {}
            return null;
        }
    }

    public void serializeInfo() {
        if (this.hasSerialized) {
            return;
        }
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = this.repository.toStream(GLOBALS_SERIAL);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this.globalInfo);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                    return;
                }
                if (outputStream != null) {
                    outputStream.close();
                    return;
                }
            }
            catch (Exception exception2) {}
            return;
        }
        this.hasSerialized = true;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.provider.translateToContextPath(this.path);
    }

    public JspResourceProvider getProvider() {
        return this.provider;
    }

    public Object getInstance() {
        return this.instance;
    }

    public JspApplication getApplication() {
        return this.application;
    }

    public long getModified() {
        return this.modified;
    }

    public Object getGlobalInfo() {
        return this.globalInfo;
    }

    public boolean hasChanged() throws IOException {
        try {
            return this.modified < this.provider.getLastModified(GLOBALS_JSP);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
    }
}

