/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;

public class JspDirectiveJsp
extends JspDirective
implements Serializable {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[11];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("page", true);
    private static final String[] languageValue = new String[]{"java", "sqlj"};

    public JspDirectiveJsp() {
        if (attrs[0] == null) {
            JspDirectiveJsp.dirAttr.validValues = new String[0];
            JspDirectiveJsp.attrs[0] = new JspDirectiveAttrDesc("info", true);
            JspDirectiveJsp.attrs[0].required = false;
            JspDirectiveJsp.attrs[1] = new JspDirectiveAttrDesc("errorPage", true);
            JspDirectiveJsp.attrs[1].required = false;
            JspDirectiveJsp.attrs[2] = new JspDirectiveAttrDesc("session", false);
            JspDirectiveJsp.attrs[2].required = false;
            JspDirectiveJsp.attrs[2].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[3] = new JspDirectiveAttrDesc("isThreadSafe", false);
            JspDirectiveJsp.attrs[3].required = false;
            JspDirectiveJsp.attrs[3].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[4] = new JspDirectiveAttrDesc("isErrorPage", false);
            JspDirectiveJsp.attrs[4].required = false;
            JspDirectiveJsp.attrs[4].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[5] = new JspDirectiveAttrDesc("buffer", false);
            JspDirectiveJsp.attrs[5].required = false;
            JspDirectiveJsp.attrs[6] = new JspDirectiveAttrDesc("language", false);
            JspDirectiveJsp.attrs[6].required = false;
            JspDirectiveJsp.attrs[6].validValues = languageValue;
            JspDirectiveJsp.attrs[7] = new JspDirectiveAttrDesc("extends", true);
            JspDirectiveJsp.attrs[7].required = false;
            JspDirectiveJsp.attrs[8] = new JspDirectiveAttrDesc("import", ',', true, true);
            JspDirectiveJsp.attrs[8].required = false;
            JspDirectiveJsp.attrs[9] = new JspDirectiveAttrDesc("autoFlush", false);
            JspDirectiveJsp.attrs[9].required = false;
            JspDirectiveJsp.attrs[9].validValues = JspDirectiveAttrDesc.booleanValues;
            JspDirectiveJsp.attrs[10] = new JspDirectiveAttrDesc("contentType", true);
            JspDirectiveJsp.attrs[10].required = false;
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public void validateAttributes(JspParseState jspParseState) throws JspParseException {
        super.validateAttributes(jspParseState);
        String string = this.getAttrValue("isErrorPage");
        if (JspUtils.translateBoolean(string, false)) {
            jspParseState.getThisBean().addObject("exception", "java.lang.Exception", jspParseState);
        }
        if ((string = this.getAttrValue("language")) == null) {
            string = "java";
        } else {
            string = string.toLowerCase();
            string = string.trim();
        }
        if (!string.equals("java") && !string.equals("sqlj")) {
            throw new JspParseException(jspParseState, msgs.getString("bad_lang"));
        }
        string = this.getAttrValue("buffer");
        int n = JspUtils.translateBufferSize(string);
        if (n == -1) {
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_buffer_val"), string));
        }
        if (n == 0 && !JspUtils.translateBoolean(string = this.getAttrValue("autoFlush"), true)) {
            throw new JspParseException(jspParseState, msgs.getString("bad_aflush_val"));
        }
        string = this.getAttrValue("contentType");
        if (string != null) {
            string = JspUtils.extractEncoding(string);
            String string2 = jspParseState.parms.encoding;
            if (string2 == null) {
                string2 = "ISO-8859-1";
            }
            if (!string.equalsIgnoreCase(string2)) {
                throw new JspEncodingException(jspParseState, string2, string);
            }
        }
    }
}

