/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.runtime.OracleJspRuntime;

public class JspEmitter {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private static final String pkg = "oracle.jsp.runtime";
    private static final String[] importStrs = new String[]{"oracle.jsp.runtime.*", "javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*", "java.io.*", "java.util.*", "java.lang.reflect.*", "java.beans.*"};
    private String extName;
    private String clsName;
    protected String emittedPackageName;
    public static final String STATICTEXT_CLASSNAME = "__jsp_StaticText";

    private void emitGlobalDeclarations(JspEmitState jspEmitState, Vector vector) {
        if (vector != null && vector.size() > 0) {
            jspEmitState.println("");
            jspEmitState.iprintln("// Begin global declarations");
            jspEmitState.println("");
            try {
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n);
                    jspEmitState.iprintln(string);
                    ++n;
                }
            }
            catch (Throwable throwable) {}
            jspEmitState.iprintln("// End global declarations");
            jspEmitState.println("");
            return;
        }
        jspEmitState.iprintln("public final String _globalsClassName = null;");
    }

    public void emit(JspEmitState jspEmitState, JspParseTagFile jspParseTagFile) throws JspParseException {
        jspEmitState.printLineInfoFile(jspEmitState.parms.sourceFileName);
        jspEmitState.printLineInfoGenerated();
        jspEmitState.printLineInfo(0, 1);
        this.emitHeader(jspEmitState);
        this.emitClassDecl(jspEmitState);
        if (jspEmitState.parseState.parms.globalInfo != null) {
            this.emitGlobalDeclarations(jspEmitState, jspEmitState.parseState.parms.globalInfo.globalDeclarations);
        } else {
            this.emitGlobalDeclarations(jspEmitState, null);
        }
        this.emitDeclarations(jspEmitState);
        this.emitServiceHeader(jspEmitState);
        jspEmitState.printLineInfoTranslated();
        try {
            jspParseTagFile.emit(jspEmitState);
        }
        catch (JspEmitException jspEmitException) {
            throw new JspParseException(-1, msgs.getString("emit_ex"), jspEmitException.getMessage());
        }
        jspEmitState.printLineInfoGenerated();
        this.emitServiceTrailer(jspEmitState);
        this.emitStaticTexts(jspEmitState);
        this.emitHotLoad(jspEmitState);
        this.emitTrailer(jspEmitState);
    }

    protected void emitHeader(JspEmitState jspEmitState) {
        String string;
        String string2 = pkg;
        if (jspEmitState.parms.packageName != null) {
            string2 = jspEmitState.parms.packageName;
        }
        if (string2.length() > 0) {
            jspEmitState.println("package " + string2 + ";");
            this.emittedPackageName = string2;
        } else {
            this.emittedPackageName = null;
        }
        jspEmitState.println("");
        int n = 0;
        while (n < importStrs.length) {
            jspEmitState.println("import " + importStrs[n] + ";");
            ++n;
        }
        if (jspEmitState.parms.imports != null) {
            n = 0;
            while (n < jspEmitState.parms.imports.length) {
                jspEmitState.println("import " + jspEmitState.parms.imports[n] + ";");
                ++n;
            }
        }
        if ((string = jspEmitState.getDirectiveAttrValue("page", "import")) != null) {
            String string3;
            int n2;
            while ((n2 = string.indexOf(44)) != -1) {
                string3 = string.substring(0, n2).trim();
                if (string3.length() > 0) {
                    jspEmitState.println("import " + string3 + ";");
                }
                string = n2 + 1 < string.length() ? string.substring(n2 + 1) : "";
            }
            string3 = string.trim();
            if (string3.length() > 0) {
                jspEmitState.println("import " + string3 + ";");
            }
        }
        jspEmitState.println("");
        jspEmitState.println("");
    }

    protected void emitClassDecl(JspEmitState jspEmitState) {
        this.clsName = jspEmitState.parms.className == null ? "jsp_" + Long.toString(new Date().getTime()) + "_" + Integer.toString(++JspEmitState.emitCount) : jspEmitState.parms.className;
        this.extName = jspEmitState.getDirectiveAttrValue("page", "extends");
        if (this.extName == null) {
            this.extName = jspEmitState.parms.extend == null ? "oracle.jsp.runtime.HttpJsp" : jspEmitState.parms.extend;
        }
        jspEmitState.print("public class " + this.clsName + " extends " + this.extName + " ");
        boolean bl = JspUtils.translateBoolean(jspEmitState.getDirectiveAttrValue("page", "isThreadSafe"), true);
        if (jspEmitState.parms.implement != null) {
            jspEmitState.print("implements " + jspEmitState.parms.implement);
            if (bl) {
                jspEmitState.print(" ");
            } else {
                jspEmitState.print(", SingleThreadModel ");
            }
        } else if (!bl) {
            jspEmitState.print("implements SingleThreadModel ");
        }
        jspEmitState.println("{");
        jspEmitState.println("");
    }

    protected void emitDeclarations(JspEmitState jspEmitState) {
        String string = jspEmitState.getDirectiveAttrValue("page", "info");
        if (string != null) {
            jspEmitState.iprintln("public String getServletInfo() {");
            jspEmitState.indent();
            jspEmitState.iprintln("return( \"" + JspParseTag.sanitizeQuotedString(string) + "\");");
            jspEmitState.undent();
            jspEmitState.iprintln("}");
            jspEmitState.println("");
        }
        int n = jspEmitState.declarations.size();
        boolean bl = false;
        String string2 = jspEmitState.getLineInfoFileName();
        jspEmitState.println("");
        jspEmitState.iprintln("// ** Begin Declarations");
        jspEmitState.println("");
        int n2 = 0;
        while (n2 < n) {
            String string3;
            Object e = jspEmitState.declarations.elementAt(n2);
            if (e instanceof Integer) {
                Integer n3 = (Integer)e;
                string3 = (String)jspEmitState.declarations.elementAt(++n2);
                if (!bl) {
                    jspEmitState.printLineInfoUser();
                    bl = true;
                }
                jspEmitState.printLineInfoFile(string3);
                jspEmitState.printLineInfo(n3 + 1, 1);
            } else {
                string3 = (String)jspEmitState.declarations.elementAt(n2);
                jspEmitState.println(string3);
            }
            ++n2;
        }
        jspEmitState.printLineInfoGenerated();
        jspEmitState.printLineInfoFile(string2);
        jspEmitState.println("");
        jspEmitState.iprintln("// ** End Declarations");
        jspEmitState.println("");
    }

    protected void emitServiceHeader(JspEmitState jspEmitState) {
        jspEmitState.iprintln("public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {");
        jspEmitState.indent();
        jspEmitState.println("");
        String string = jspEmitState.getDirectiveAttrValue("page", "contentType");
        if (string != null) {
            jspEmitState.iprintln("response.setContentType( \"" + string + "\");");
        }
        jspEmitState.iprintln("/* set up the intrinsic variables using the pageContext goober:");
        jspEmitState.iprintln("** session = HttpSession");
        jspEmitState.iprintln("** application = ServletContext");
        jspEmitState.iprintln("** out = JspWriter");
        jspEmitState.iprintln("** page = this");
        jspEmitState.iprintln("** config = ServletConfig");
        jspEmitState.iprintln("** all session/app beans declared in globals.jsa");
        jspEmitState.iprintln("*/");
        boolean bl = JspUtils.translateBoolean(jspEmitState.getDirectiveAttrValue("page", "session"), true);
        String string2 = jspEmitState.getDirectiveAttrValue("page", "buffer");
        int n = JspUtils.translateBufferSize(string2);
        boolean bl2 = JspUtils.translateBoolean(jspEmitState.getDirectiveAttrValue("page", "autoFlush"), true);
        String string3 = jspEmitState.getDirectiveAttrValue("page", "errorPage");
        string3 = string3 == null ? "null" : "\"" + JspParseTag.sanitizeQuotedString(string3) + "\"";
        jspEmitState.iprintln("JspFactory factory = JspFactory.getDefaultFactory();");
        jspEmitState.iprint("PageContext pageContext = factory.getPageContext( this, request, response, " + string3 + ", " + (bl ? "true" : "false") + ", ");
        if (n < 0) {
            jspEmitState.print("JspWriter.DEFAULT_BUFFER");
        } else if (n == 0) {
            jspEmitState.print("JspWriter.NO_BUFFER");
        } else {
            jspEmitState.print(Integer.toString(n));
        }
        jspEmitState.print(", " + (bl2 ? "true" : "false") + ");");
        jspEmitState.println("");
        if (bl) {
            jspEmitState.iprintln("// Note: this is not emitted if the session directive == false");
            jspEmitState.iprintln("HttpSession session = pageContext.getSession();");
        } else {
            jspEmitState.iprintln("// Note: session is false, so no session variable is defined.");
        }
        jspEmitState.iprintln("if (pageContext.getAttribute(OracleJspRuntime.JSP_REQUEST_REDIRECTED, PageContext.REQUEST_SCOPE) != null) {");
        jspEmitState.indent();
        jspEmitState.iprintln("pageContext.setAttribute(OracleJspRuntime.JSP_PAGE_DONTNOTIFY, \"true\", PageContext.PAGE_SCOPE);");
        jspEmitState.iprintln("factory.releasePageContext(pageContext);");
        jspEmitState.iprintln("return;");
        jspEmitState.undent();
        jspEmitState.println("}");
        jspEmitState.iprintln("ServletContext application = pageContext.getServletContext();");
        jspEmitState.iprintln("JspWriter out = pageContext.getOut();");
        jspEmitState.iprintln(String.valueOf(this.clsName) + " page = this;");
        jspEmitState.iprintln("ServletConfig config = pageContext.getServletConfig();");
        if (JspUtils.translateBoolean(jspEmitState.getDirectiveAttrValue("page", "isErrorPage"), false)) {
            jspEmitState.iprintln("Exception exception = pageContext.getException();");
        }
        jspEmitState.println("");
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("// global beans");
        Enumeration enumeration = null;
        if (jspEmitState.getGlobalBeans() != null) {
            enumeration = jspEmitState.getGlobalBeans().getAllBeans();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                JspBeanInfo jspBeanInfo = (JspBeanInfo)enumeration.nextElement();
                if (jspBeanInfo.scope == 3) {
                    jspEmitState.iprintln(String.valueOf(jspBeanInfo.className) + " " + jspBeanInfo.name + " = (" + jspBeanInfo.className + ") pageContext.getAttribute( \"" + jspBeanInfo.name + "\", PageContext.SESSION_SCOPE);");
                    continue;
                }
                if (jspBeanInfo.scope != 4) continue;
                jspEmitState.iprintln(String.valueOf(jspBeanInfo.className) + " " + jspBeanInfo.name + " = (" + jspBeanInfo.className + ") pageContext.getAttribute( \"" + jspBeanInfo.name + "\", PageContext.APPLICATION_SCOPE);");
            }
        }
        jspEmitState.iprintln("// end global beans");
        jspEmitState.println("");
        jspEmitState.println("");
    }

    protected void emitServiceTrailer(JspEmitState jspEmitState) {
        jspEmitState.println("");
        jspEmitState.iprintln("out.flush();");
        jspEmitState.println("");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("catch( Exception e) {");
        jspEmitState.indent();
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("if (out != null) out.clear();");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("catch( Exception clearException) {");
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("pageContext.handlePageException( e);");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("finally {");
        jspEmitState.indent();
        jspEmitState.iprintln("if (out != null) out.close();");
        jspEmitState.iprintln("factory.releasePageContext(pageContext);");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.println("");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
    }

    protected void emitTrailer(JspEmitState jspEmitState) {
        jspEmitState.println("}");
    }

    protected static final void emitSetParamsMethod(JspEmitState jspEmitState) {
        jspEmitState.println("");
        jspEmitState.iprintln("private void __jspSetAllParams( HttpServletRequest request, Object bean) {");
        jspEmitState.indent();
        jspEmitState.iprintln("// truly ugly block of code to set '*' parameter values");
        jspEmitState.iprintln("Class __paramArray[] = new Class[2];");
        jspEmitState.iprintln("__paramArray[0] = Integer.TYPE;");
        jspEmitState.iprintln("__paramArray[1] = String.class;");
        jspEmitState.iprintln("Class __paramSingle[] = new Class[1];");
        jspEmitState.iprintln("__paramSingle[0] = String.class;");
        jspEmitState.iprintln("for (Enumeration __eNames = request.getParameterNames(); __eNames.hasMoreElements(); ) {");
        jspEmitState.indent();
        jspEmitState.iprintln("String __e = (String) __eNames.nextElement();");
        jspEmitState.iprintln("String[] __v = request.getParameterValues( __e);");
        jspEmitState.iprintln("if (__v.length == 0)");
        jspEmitState.iprintln("\tcontinue;");
        jspEmitState.iprintln("else {");
        jspEmitState.indent();
        jspEmitState.iprintln("Method __m = null;");
        jspEmitState.iprintln("Object __argList[];");
        jspEmitState.iprintln("__e = __e.substring( 0, 1).toUpperCase() + __e.substring( 1);");
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("__m = bean.getClass().getDeclaredMethod( \"set\" + __e, __paramArray);");
        jspEmitState.undent();
        jspEmitState.iprintln("} catch (Exception e) {}");
        jspEmitState.iprintln("if (__m != null) {");
        jspEmitState.indent();
        jspEmitState.iprintln("__argList = new Object[2];");
        jspEmitState.iprintln("for (int __i = 0; __i < __v.length; __i++) {");
        jspEmitState.indent();
        jspEmitState.iprintln("__argList[0] = new Integer( __i);");
        jspEmitState.iprintln("__argList[1] = new String( __v[__i]);");
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("__m.invoke( bean, __argList);");
        jspEmitState.undent();
        jspEmitState.iprintln("} catch (Exception e) {}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("else { // __m == null");
        jspEmitState.indent();
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("__m = bean.getClass().getDeclaredMethod( \"set\" + __e, __paramSingle);");
        jspEmitState.undent();
        jspEmitState.iprintln("} catch (Exception e) {}");
        jspEmitState.iprintln("if (__m != null) {");
        jspEmitState.indent();
        jspEmitState.iprintln("__argList = new Object[1];");
        jspEmitState.iprintln("__argList[0] = new String( __v[0]);");
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("__m.invoke( bean, __argList);");
        jspEmitState.undent();
        jspEmitState.iprintln("} catch (Exception e) {}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.println("");
    }

    protected static final void emitSetParamsMethod2(JspEmitState jspEmitState) {
        jspEmitState.println("");
        jspEmitState.iprintln("private void __jspSetAllParams( HttpServletRequest request, Object bean) {");
        jspEmitState.indent();
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("BeanInfo info = Introspector.getBeanInfo( bean.getClass());");
        jspEmitState.iprintln("PropertyDescriptor[] props = info.getPropertyDescriptors();");
        jspEmitState.iprintln("for (Enumeration names = request.getParameterNames(); names.hasMoreElements(); ) {");
        jspEmitState.indent();
        jspEmitState.iprintln("String name = (String) names.nextElement();");
        jspEmitState.iprintln("for (int i = 0; i < props.length; i++) {");
        jspEmitState.indent();
        jspEmitState.iprintln("if (name.equalsIgnoreCase( props[i].getName())) {");
        jspEmitState.indent();
        jspEmitState.iprintln("String[] values = request.getParameterValues( name);");
        jspEmitState.iprintln("if ((values != null) && (values.length > 0)) {");
        jspEmitState.indent();
        jspEmitState.iprintln("if (props[i] instanceof IndexedPropertyDescriptor) {");
        jspEmitState.indent();
        jspEmitState.iprintln("IndexedPropertyDescriptor idxProp = (IndexedPropertyDescriptor) props[i];");
        jspEmitState.iprintln("if (idxProp.getIndexedPropertyType().equals( String.class)) {");
        jspEmitState.indent();
        jspEmitState.iprintln("Method m = idxProp.getIndexedWriteMethod();");
        jspEmitState.iprintln("Object[] args = new Object[2];");
        jspEmitState.iprintln("for ( int valIdx = 0; valIdx < values.length; valIdx++) {");
        jspEmitState.indent();
        jspEmitState.iprintln("args[0] = new Integer( valIdx);");
        jspEmitState.iprintln("args[1] = values[valIdx];");
        jspEmitState.iprintln("m.invoke( bean, args);");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("else {");
        jspEmitState.indent();
        jspEmitState.iprintln("if (props[i].getPropertyType().equals( String.class)) {");
        jspEmitState.indent();
        jspEmitState.iprintln("Method m = props[i].getWriteMethod();");
        jspEmitState.iprintln("Object[] args = new Object[1];");
        jspEmitState.iprintln("args[0] = values[0];");
        jspEmitState.iprintln("m.invoke( bean, args);");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("catch( Exception e) {");
        jspEmitState.indent();
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
    }

    protected void emitStaticTexts(JspEmitState jspEmitState) {
        Vector vector = jspEmitState.getStaticTexts();
        if (vector.size() == 0) {
            return;
        }
        if (jspEmitState.resOut != null) {
            try {
                OracleJspRuntime.writeTexts(jspEmitState.resOut, vector);
                jspEmitState.iprintln("private static class __jsp_StaticText {");
                jspEmitState.indent();
                jspEmitState.iprintln("private static final char text[][]=");
                jspEmitState.iprintln("oracle.jsp.runtime.OracleJspRuntime.readTexts(__jsp_StaticText.class , \"" + jspEmitState.parms.className + ".res\" );");
                jspEmitState.undent();
                jspEmitState.iprintln("}");
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                return;
            }
        }
        jspEmitState.iprintln("private static class __jsp_StaticText {");
        jspEmitState.indent();
        jspEmitState.iprintln("private static final char text[][]=new char[" + vector.size() + "][];");
        jspEmitState.iprintln("static {");
        jspEmitState.indent();
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            jspEmitState.iprintln("text[" + n + "] = ");
            String string = (String)enumeration.nextElement();
            jspEmitState.iprintln("\"" + JspParseTag.sanitizeQuotedString(string) + "\".toCharArray();");
            ++n;
        }
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
    }

    public static String charToCode(char c) {
        switch (c) {
            case '\b': {
                return "'\\b'";
            }
            case '\t': {
                return "'\\t'";
            }
            case '\n': {
                return "'\\n'";
            }
            case '\f': {
                return "'\\f'";
            }
            case '\r': {
                return "'\\r'";
            }
            case '\"': {
                return "'\\\"'";
            }
            case '\'': {
                return "'\\''";
            }
            case '\\': {
                return "'\\\\'";
            }
        }
        return "'" + c + "'";
    }

    protected void emitHotLoad(JspEmitState jspEmitState) {
        if (!jspEmitState.parms.hotload) {
            return;
        }
        Vector vector = jspEmitState.getStaticTexts();
        boolean bl = vector.size() > 0;
        jspEmitState.iprintln("public static void __jsp_hotload_class() {");
        if (bl) {
            jspEmitState.indent();
            jspEmitState.iprintln("oracle.aurora.vm.HotLoader.save(__jsp_StaticText.class);");
            jspEmitState.undent();
        }
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("public static void main(String args[]) {");
        jspEmitState.indent();
        jspEmitState.iprintln("__jsp_hotload_class();");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
    }
}

