/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspUtils;

public class JspParseTag {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final int JSPPARSETAG_TEXT = 1;
    public static final int JSPPARSETAG_DIRECTIVE = 2;
    public static final int JSPPARSETAG_DECLARATION = 3;
    public static final int JSPPARSETAG_EXPRESSION = 4;
    public static final int JSPPARSETAG_SCRIPTLET = 5;
    public static final int JSPPARSETAG_COMMENT = 6;
    public static final int JSPPARSETAG_CUSTOM = 7;
    public JspParseTag parent;
    public Vector body;
    private int tagBaseType;
    protected boolean requiresBody;
    protected String tagString;
    protected int lineNumber;
    public static final char[] SANITIZE_FROM_CHAR = new char[]{'\\', '\"', '\r', '\n', '\t', '\b', '\f'};
    public static final String[] SANITIZE_TO_STR = new String[]{"\\\\", "\\\"", "\\r", "\\n", "\\t", "\\b", "\\f"};

    public JspParseTag(int n) {
        this.tagBaseType = n;
        this.body = new Vector();
    }

    public void setParent(JspParseTag jspParseTag) {
        this.parent = jspParseTag;
    }

    public boolean hasBody() {
        return this.body.size() > 0;
    }

    public String toString() {
        String string = "<Custom Tag: ";
        string = string.concat(this.getTagName());
        string = string.concat(">");
        return string;
    }

    protected void setTagString(String string) {
        this.tagString = string;
    }

    public String getTagName() {
        if (this.tagString != null) {
            return this.tagString;
        }
        return "Unknown Tag";
    }

    protected boolean isEndTag(String string) {
        if (!string.startsWith("</")) {
            return false;
        }
        if (this.tagString != null) {
            return string.substring(2).equals(this.tagString);
        }
        return false;
    }

    protected boolean isEndAVTag(JspParseState jspParseState, String string) {
        if (string.equals(">")) {
            jspParseState.tagHasBody = true;
            return true;
        }
        if (string.equals("/>")) {
            jspParseState.tagHasBody = false;
            return true;
        }
        return false;
    }

    public boolean allowsBody() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static int skipWhiteSpace(JspParseState var0) throws IOException, JspParseException {
        var1_1 = var0.getLineLength();
        var2_2 = 0;
        var3_3 = false;
        ** GOTO lbl19
        {
            if (var0.ReadLine() == null) {
                throw new JspParseException(var0, JspParseTag.msgs.getString("no_tag_end"));
            }
            var1_1 = var0.getLineLength();
            do {
                if (var1_1 == 0) continue block0;
                var2_2 = 0;
                while (var2_2 < var1_1) {
                    if (!Character.isWhitespace(var0.line.charAt(var2_2))) break;
                    ++var2_2;
                }
                if (var2_2 < var1_1) {
                    var3_3 = true;
                    continue;
                }
                var1_1 = 0;
lbl19:
                // 3 sources

            } while (!var3_3);
        }
        return var2_2;
    }

    protected boolean getAttributeName(JspParseState jspParseState) throws IOException, JspParseException {
        int n = JspParseTag.skipWhiteSpace(jspParseState);
        int n2 = jspParseState.line.indexOf(62, n);
        if (n2 != -1 && this.isEndAVTag(jspParseState, jspParseState.line.substring(n, n2 + 1))) {
            jspParseState.attributeName = "";
            jspParseState.line = n2 + 1 < jspParseState.line.length() ? jspParseState.line.substring(n2 + 1) : null;
            return false;
        }
        int n3 = jspParseState.getLineLength();
        n2 = n;
        while (n2 < n3) {
            if (jspParseState.line.charAt(n2) == '=' || Character.isWhitespace(jspParseState.line.charAt(n2)) || jspParseState.line.charAt(n2) == '>') {
                jspParseState.attributeName = jspParseState.line.substring(n, n2);
                jspParseState.line = jspParseState.line.substring(n2);
                return true;
            }
            ++n2;
        }
        jspParseState.attributeName = jspParseState.line.substring(n);
        jspParseState.line = null;
        return true;
    }

    protected static boolean getAttributeValue(JspParseState jspParseState) throws IOException, JspParseException {
        int n = JspParseTag.skipWhiteSpace(jspParseState);
        if (jspParseState.line.charAt(n) != '=') {
            jspParseState.line = jspParseState.line.substring(n);
            jspParseState.attributeValue = null;
            return false;
        }
        jspParseState.line = n + 1 < jspParseState.line.length() ? jspParseState.line.substring(n + 1) : null;
        n = JspParseTag.skipWhiteSpace(jspParseState);
        char c = jspParseState.line.charAt(n);
        if (c != '\"' && c != '\'') {
            throw new JspParseException(jspParseState, String.valueOf(msgs.getString("no_quoted_val")) + c);
        }
        jspParseState.attributeValue = "";
        boolean bl = false;
        boolean bl2 = false;
        int n2 = jspParseState.getLineLength();
        int n3 = ++n;
        while (!bl) {
            n2 = jspParseState.getLineLength();
            n3 = n;
            while (n3 < n2) {
                if (!bl2) {
                    if (jspParseState.line.charAt(n3) == c) {
                        bl = true;
                        break;
                    }
                    bl2 = jspParseState.line.charAt(n3) == '\\';
                } else {
                    bl2 = false;
                }
                ++n3;
            }
            if (n3 > n) {
                jspParseState.attributeValue = String.valueOf(jspParseState.attributeValue) + jspParseState.line.substring(n, n3);
            }
            if (n3 != n2) continue;
            jspParseState.ReadLine();
            if (jspParseState.line == null) {
                throw new JspParseException(jspParseState, msgs.getString("eof_in_Str"));
            }
            n = 0;
        }
        jspParseState.line = n3 + 1 < jspParseState.line.length() ? jspParseState.line.substring(n3 + 1) : null;
        jspParseState.attributeValue = JspUtils.decodeQuotes(jspParseState.attributeValue);
        return true;
    }

    public void processAttributeValue(JspParseState jspParseState, int n, String string, String string2) throws JspParseException {
        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_tag_attr"), string));
    }

    protected void parseFileEnd(JspParseState jspParseState) throws JspParseException {
        throw new JspParseException(jspParseState, msgs.getString("bad_eof"));
    }

    public void removeWhiteSpaceText() {
        int n = this.body.size();
        int n2 = 0;
        while (n2 < n) {
            JspParseTag jspParseTag = (JspParseTag)this.body.elementAt(n2);
            if (JspUtils.isTagWhitespace(jspParseTag)) {
                this.body.removeElementAt(n2);
                --n2;
                --n;
            }
            ++n2;
        }
    }

    public void validateTagAttributes(JspParseState jspParseState) throws JspParseException {
    }

    public void validateTagParse(JspParseState jspParseState) throws JspParseException {
    }

    public boolean isTagValidInBody(JspParseState jspParseState, String string, Class clazz, JspParseTag jspParseTag) {
        return true;
    }

    protected static int findTagEnd(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (Character.isWhitespace(string.charAt(n2))) {
                return n2;
            }
            if (string.charAt(n2) == '>') {
                if (n2 > 0 && string.charAt(n2 - 1) == '/') {
                    --n2;
                }
                return n2;
            }
            ++n2;
        }
        return n;
    }

    protected JspParseTag parseNextTag(JspParseState jspParseState) throws IOException, JspParseException {
        if (jspParseState.line == null || jspParseState.line.length() == 0) {
            jspParseState.ReadLine();
        }
        JspParseTagText jspParseTagText = null;
        JspParseTag jspParseTag = null;
        while (jspParseState.line != null) {
            int n;
            if (jspParseState.line.length() > 0 && jspParseState.line.charAt(0) == '<') {
                n = JspParseTag.findTagEnd(jspParseState.line);
                String string = n >= jspParseState.line.length() ? jspParseState.line : jspParseState.line.substring(0, n);
                if (this.isEndTag(string)) {
                    if (jspParseTagText != null) {
                        return jspParseTagText;
                    }
                    n = jspParseState.line.indexOf(62);
                    if (n == -1) {
                        throw new JspParseException(jspParseState, msgs.getString("bad_term"));
                    }
                    jspParseState.line = n + 1 < jspParseState.line.length() ? jspParseState.line.substring(n + 1) : null;
                    return null;
                }
                int n2 = jspParseState.isKnownTag(string);
                if (n2 != -1) {
                    if (jspParseTagText != null) {
                        return jspParseTagText;
                    }
                    string = string.substring(0, n2);
                    n = string.length();
                    jspParseTag = jspParseState.createTagParser(string, this);
                    jspParseState.line = n >= jspParseState.line.length() ? null : jspParseState.line.substring(n);
                    int n3 = this.body.size();
                    jspParseTag.parse(jspParseState);
                    if (this.body.size() == n3) {
                        return jspParseTag;
                    }
                } else {
                    n = string.indexOf(58);
                    if (n != -1 && n > 1) {
                        String string2 = string.substring(1, n);
                        if (jspParseState.prefixRegistered(string2)) {
                            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_tag"), string.substring(1)));
                        }
                        jspParseState.addPrefix(string.substring(1, n));
                    }
                    if (jspParseTagText == null) {
                        jspParseTagText = new JspParseTagText(this);
                        jspParseTagText.lineNumber = jspParseState.position.lineNum;
                    }
                    jspParseTagText.addLine(jspParseState.line.substring(0, 1));
                    jspParseState.line = jspParseState.line.length() > 1 ? jspParseState.line.substring(1) : null;
                }
            } else {
                n = jspParseState.line.indexOf(60);
                if (jspParseTagText == null) {
                    jspParseTagText = new JspParseTagText(this);
                    jspParseTagText.lineNumber = jspParseState.position.lineNum;
                }
                if (n != -1) {
                    jspParseTagText.addLine(jspParseState.line.substring(0, n));
                    jspParseState.line = jspParseState.line.substring(n);
                } else {
                    jspParseTagText.addLine(jspParseState.line);
                    jspParseState.line = null;
                }
            }
            if (jspParseState.line != null && jspParseState.line.length() != 0) continue;
            jspParseState.ReadLine();
        }
        if (jspParseTagText != null) {
            return jspParseTagText;
        }
        this.parseFileEnd(jspParseState);
        return null;
    }

    public void parseBody(JspParseState jspParseState) throws IOException, JspParseException {
        JspParseTag jspParseTag;
        while ((jspParseTag = this.parseNextTag(jspParseState)) != null) {
            this.addTagToBody(jspParseState, jspParseTag);
        }
    }

    public void addTagToBody(JspParseState jspParseState, JspParseTag jspParseTag) throws JspParseException {
        this.body.addElement(jspParseTag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(JspParseState jspParseState) throws IOException, JspParseException {
        this.lineNumber = jspParseState.position.lineNum;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            if (this.getAttributeName(jspParseState)) {
                JspParseTag.getAttributeValue(jspParseState);
                if (jspParseState.attributeName == null || jspParseState.attributeName.length() <= 0) throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("cannot_get_attr"), this.getTagName()));
                this.processAttributeValue(jspParseState, ++n, jspParseState.attributeName, jspParseState.attributeValue);
                continue;
            }
            bl = true;
        }
        this.validateTagAttributes(jspParseState);
        if (jspParseState.tagHasBody) {
            if (!this.allowsBody()) throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_slash"), this.getTagName()));
            this.parseBody(jspParseState);
        } else if (this.requiresBody) {
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_body"), this.getTagName()));
        }
        this.validateTagParse(jspParseState);
    }

    public JspParseTag findTagInBody(String string) {
        if (this.body == null) {
            return null;
        }
        int n = this.body.size();
        if (string.indexOf(58) != -1) {
            int n2 = 0;
            while (n2 < n) {
                JspParseTag jspParseTag = (JspParseTag)this.body.elementAt(n2);
                if (jspParseTag.tagString.equals(string)) {
                    return jspParseTag;
                }
                ++n2;
            }
        } else {
            string = ":" + string;
            int n3 = 0;
            while (n3 < n) {
                JspParseTag jspParseTag = (JspParseTag)this.body.elementAt(n3);
                if (jspParseTag.tagString.endsWith(string)) {
                    return jspParseTag;
                }
                ++n3;
            }
        }
        return null;
    }

    public void emit(JspEmitState jspEmitState) throws JspEmitException {
        jspEmitState.printLineInfo(this.lineNumber + 1, 1);
        this.emitTagStart(jspEmitState);
        this.emitTagBody(jspEmitState);
        this.emitTagEnd(jspEmitState);
    }

    public void emitTagStart(JspEmitState jspEmitState) throws JspEmitException {
    }

    public void emitTagBody(JspEmitState jspEmitState) throws JspEmitException {
        int n = this.body.size();
        int n2 = 0;
        while (n2 < n) {
            JspParseTag jspParseTag = (JspParseTag)this.body.elementAt(n2);
            if (jspParseTag != null) {
                jspParseTag.emit(jspEmitState);
            }
            ++n2;
        }
    }

    public void emitTagEnd(JspEmitState jspEmitState) throws JspEmitException {
    }

    public static String sanitizeQuotedString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < SANITIZE_FROM_CHAR.length) {
                if (cArray[n2] == SANITIZE_FROM_CHAR[n3]) {
                    bl = true;
                    stringBuffer.append(SANITIZE_TO_STR[n3]);
                    break;
                }
                ++n3;
            }
            if (!bl) {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        return new String(stringBuffer);
    }
}

