/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.provider;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.jsp.PageContext;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;
import oracle.jsp.event.SessionEvent;
import oracle.jsp.event.SessionListener;
import oracle.jsp.runtime.JspHttpRequest;
import oracle.jsp.runtime.JspHttpSession;
import oracle.jsp.runtime.OraclePageContext;
import oracle.jsp.util.JspUtil;

public class JspUniversalHttpSession
implements JspHttpSession,
HttpSession,
HttpSessionBindingListener {
    private static final String MESSAGE_FILE = "oracle.jsp.provider.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.provider.LocalStrings");
    protected final int SESSION_ONSTART = 0;
    protected final int SESSION_ONEND = 1;
    private SessionListener sl;
    private ServletContext sc;
    private String appPath;
    private HttpSession session;
    private boolean isValid;
    private boolean unbound;
    private boolean isNew;
    private String id;
    private String uid;
    private long createTime;
    private long lastAccessedTime;
    private Hashtable attributes;
    private boolean sessionSharing = true;

    public JspUniversalHttpSession(ServletContext servletContext, JspHttpRequest jspHttpRequest, HttpServletResponse httpServletResponse, boolean bl) {
        this(servletContext, jspHttpRequest, httpServletResponse);
        this.sessionSharing = bl;
    }

    public JspUniversalHttpSession(ServletContext servletContext, JspHttpRequest jspHttpRequest, HttpServletResponse httpServletResponse) {
        this.sc = servletContext;
        this.sl = (SessionListener)this.sc.getAttribute("oracle.jsp.jspGlobals");
        this.appPath = (String)this.sc.getAttribute("oracle.jsp.jspFullApplicationPath");
        if (this.appPath == null) {
            this.appPath = "/";
        }
        this.session = jspHttpRequest.getNativeRequest().getSession(true);
        this.id = String.valueOf(this.appPath) + "oracle.jsp.JspSession";
        this.uid = this.toString();
        this.uid = String.valueOf(this.session.getId()) + "." + this.uid.substring(this.uid.lastIndexOf("@") + 1);
        this.isValid = true;
        this.isNew = true;
        this.createTime = this.lastAccessedTime = System.currentTimeMillis();
        this.attributes = new Hashtable();
        this.session.putValue(this.id, (Object)this);
        PageContext pageContext = (PageContext)jspHttpRequest.getAttribute("javax.servlet.jsp.jspPageContext");
        if (pageContext != null && pageContext instanceof OraclePageContext) {
            ((OraclePageContext)pageContext).setSession(this);
        }
        this.notifySessionEvent(0, (HttpServletRequest)jspHttpRequest, httpServletResponse);
    }

    public synchronized long getCreationTime() {
        this.assertValid();
        return this.createTime;
    }

    public synchronized String getId() {
        this.assertValid();
        return this.uid;
    }

    public synchronized long getLastAccessedTime() {
        this.assertValid();
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        this.assertValid();
        return this.session.getMaxInactiveInterval();
    }

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public synchronized Object getValue(String string) {
        this.assertValid();
        Object v = this.attributes.get(string);
        if (v != null) {
            return v;
        }
        try {
            return this.session.getValue(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized Enumeration getAttributeNames() {
        return this.getValueNamesVector().elements();
    }

    public synchronized String[] getValueNames() {
        Vector vector = this.getValueNamesVector();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private synchronized Vector getValueNamesVector() {
        this.assertValid();
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (this.sessionSharing) {
            try {
                String[] stringArray = this.session.getValueNames();
                int n = 0;
                while (n < stringArray.length) {
                    if (this.attributes.get(stringArray[n]) == null) {
                        vector.addElement(stringArray[n]);
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {}
        }
        return vector;
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public synchronized void putValue(String string, Object object) {
        this.assertValid();
        if (this.sessionSharing) {
            try {
                this.session.putValue(string, object);
            }
            catch (Throwable throwable) {}
        } else {
            HttpSessionBindingListener httpSessionBindingListener;
            Object v = this.attributes.get(string);
            if (v != null && v instanceof HttpSessionBindingListener) {
                httpSessionBindingListener = (HttpSessionBindingListener)v;
                httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
            if (object instanceof HttpSessionBindingListener) {
                httpSessionBindingListener = (HttpSessionBindingListener)object;
                httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public synchronized void removeValue(String string) {
        this.assertValid();
        Object v = this.attributes.remove(string);
        if (this.sessionSharing) {
            try {
                this.session.removeValue(string);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (v instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized void invalidate() {
        this.assertValid();
        String[] stringArray = this.session.getValueNames();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith("oracle.jsp.JspSession") && !stringArray[n].equals(this.id)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            this.session.removeValue(this.id);
        } else {
            this.session.invalidate();
        }
        this.isValid = false;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public synchronized void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.cleanupClientData();
    }

    public synchronized boolean isNew() {
        this.assertValid();
        return this.isNew;
    }

    public void setMaxInactiveInterval(int n) {
        this.assertValid();
        this.session.setMaxInactiveInterval(n);
    }

    public synchronized HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public synchronized void setAccessed() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    public synchronized void setNative(HttpSession httpSession) {
        this.session = httpSession;
    }

    public synchronized void destroy() {
        this.cleanupClientData();
        try {
            this.session.removeValue(this.id);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void cleanupClientData() {
        Object k;
        if (this.unbound) {
            return;
        }
        try {
            this.notifySessionEvent(1, null, null);
        }
        catch (Throwable throwable) {}
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            k = enumeration.nextElement();
            Object v = this.attributes.get(k);
            if (v instanceof HttpSessionBindingListener) {
                if (this.sessionSharing) continue;
                object = (HttpSessionBindingListener)v;
                try {
                    object.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, (String)k));
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!(v instanceof JspScopeListener)) continue;
            object = (JspScopeListener)v;
            try {
                object.outOfScope(new JspScopeEvent(this.sc, this, (String)k, 3));
            }
            catch (Throwable throwable) {}
        }
        if (this.sessionSharing) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                try {
                    this.session.removeValue((String)k);
                }
                catch (Throwable throwable) {}
            }
        }
        this.isValid = false;
        this.unbound = true;
        this.attributes = null;
    }

    private void notifySessionEvent(int n, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.sl == null) {
            return;
        }
        if (n == 0) {
            String string = JspUtil.getTarget(JspUtil.getRequestURI(httpServletRequest));
            SessionEvent sessionEvent = new SessionEvent(this, n, this.sc, this, (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, string);
            this.sl.sessionOnStart(sessionEvent);
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(this, n, this.sc, this, null, null, null);
        this.sl.sessionOnEnd(sessionEvent);
    }

    private void assertValid() throws IllegalStateException {
        if (!this.isValid) {
            throw new IllegalStateException(MessageFormat.format(msgs.getString("bad_session"), this.uid));
        }
    }
}

