/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import sun.io.CharacterEncoding;

public class OracleJspWriter
extends JspWriter {
    private static final String MESSAGE_FILE = "oracle.jsp.runtime.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runtime.LocalStrings");
    static final int MAX_BUFFER_SIZE = 0x100000;
    private ServletResponse response;
    private Writer out = null;
    private String lineSep;
    private char[] buffer;
    private int bytesInBuf;
    private boolean bytesAlreadyWritten;
    private boolean closed;
    private boolean bufferOnly = false;

    public OracleJspWriter(int n) {
        this(null, n, true);
        this.bufferOnly = true;
    }

    public OracleJspWriter(ServletResponse servletResponse, int n, boolean bl) {
        super(n, bl);
        this.response = servletResponse;
        this.bufferSize = n == -1 || n < 0 ? 8192 : (n > 0x100000 ? 0x100000 : n);
        this.autoFlush = bl;
        this.lineSep = System.getProperty("line.separator");
        if (this.lineSep == null) {
            this.lineSep = "\n";
        }
        if (this.bufferSize > 0) {
            this.bytesInBuf = 0;
            this.buffer = new char[this.bufferSize];
        } else {
            this.buffer = null;
        }
        this.bytesAlreadyWritten = false;
        this.closed = false;
    }

    public String getBufferAsString() {
        if (this.buffer == null || this.bytesInBuf == 0) {
            return new String();
        }
        return new String(this.buffer, 0, this.bytesInBuf);
    }

    public Reader getReader() {
        if (this.buffer == null || this.bytesInBuf == 0) {
            return null;
        }
        return new CharArrayReader(this.buffer, 0, this.bytesInBuf);
    }

    public String getString() {
        return this.getBufferAsString();
    }

    public void writeOut(Writer writer) throws IOException {
        if (this.buffer == null || this.bytesInBuf == 0) {
            return;
        }
        writer.write(this.buffer, 0, this.bytesInBuf);
    }

    public void newLine() throws IOException {
        this.print(this.lineSep);
    }

    public void print(boolean bl) throws IOException {
        this.print(String.valueOf(bl));
    }

    public void print(char c) throws IOException {
        char[] cArray = new char[]{c};
        this.print(cArray);
    }

    public void print(int n) throws IOException {
        this.print(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void print(char[] cArray) throws IOException {
        ((Writer)((Object)this)).write(cArray);
    }

    public void print(String string) throws IOException {
        if (this.closed) {
            throw new IOException(msgs.getString("print_failed"));
        }
        if (string == null) {
            string = "null";
        }
        ((Writer)((Object)this)).write(string);
    }

    public void print(Object object) throws IOException {
        this.print(String.valueOf(object));
    }

    public void println() throws IOException {
        this.print(this.lineSep);
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.print(this.lineSep);
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.print(this.lineSep);
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.print(this.lineSep);
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.print(this.lineSep);
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.print(this.lineSep);
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.print(this.lineSep);
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.print(this.lineSep);
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.print(this.lineSep);
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.print(this.lineSep);
    }

    public void clear() throws IOException {
        if (this.bytesAlreadyWritten) {
            throw new IOException(msgs.getString("buffer_written"));
        }
        this.bytesInBuf = 0;
    }

    public void clearBuffer() throws IOException {
        this.bytesInBuf = 0;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(msgs.getString("bad_flush"));
        }
        if (this.bufferOnly) {
            return;
        }
        if (this.out == null && this.out == null) {
            this.out = OracleJspWriter.acquireWriter(this.response);
        }
        if (this.bytesInBuf > 0) {
            this.out.write(this.buffer, 0, this.bytesInBuf);
            this.bytesAlreadyWritten = true;
            this.bytesInBuf = 0;
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.bufferOnly) {
                this.closed = true;
                return;
            }
            if (this.out == null && this.out == null) {
                this.out = OracleJspWriter.acquireWriter(this.response);
            }
            this.flush();
            this.closed = true;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.bytesInBuf;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(msgs.getString("write_failed"));
        }
        if (this.buffer != null) {
            int n3 = n2 - n;
            if (this.bytesInBuf + n3 >= this.bufferSize) {
                if (this.isAutoFlush() && !this.bufferOnly) {
                    if (this.out == null && this.out == null) {
                        this.out = OracleJspWriter.acquireWriter(this.response);
                    }
                    if (this.bytesInBuf > 0) {
                        this.out.write(this.buffer, 0, this.bytesInBuf);
                        this.bytesAlreadyWritten = true;
                    }
                    this.bytesInBuf = 0;
                    if (n3 >= this.bufferSize) {
                        this.out.write(cArray, n, n2);
                        this.bytesAlreadyWritten = true;
                        return;
                    }
                } else {
                    if (this.bufferOnly) {
                        char[] cArray2 = new char[this.bufferSize * 2];
                        System.arraycopy(this.buffer, 0, cArray2, 0, this.bytesInBuf);
                        this.buffer = cArray2;
                        this.bufferSize *= 2;
                        this.write(cArray, n, n2);
                        return;
                    }
                    throw new IOException(msgs.getString("buffer_over"));
                }
            }
            System.arraycopy(cArray, n, this.buffer, this.bytesInBuf, n2);
            this.bytesInBuf += n2;
            return;
        }
        if (this.out == null && this.out == null) {
            this.out = OracleJspWriter.acquireWriter(this.response);
        }
        this.out.write(cArray, n, n2);
        this.bytesAlreadyWritten = true;
    }

    private void acquireResponseStream() throws IOException {
        if (this.out == null) {
            this.out = OracleJspWriter.acquireWriter(this.response);
        }
    }

    public static PrintWriter acquireWriter(ServletResponse servletResponse) throws IOException {
        PrintWriter printWriter = null;
        if (servletResponse == null) {
            throw new IOException(msgs.getString("no_response"));
        }
        if (!servletResponse.getClass().getName().equals("org.apache.jserv.JServConnection")) {
            printWriter = servletResponse.getWriter();
        } else {
            String string = servletResponse.getCharacterEncoding();
            try {
                if (string != null) {
                    if ((string = CharacterEncoding.aliasName((String)string.toUpperCase())) == null) {
                        string = servletResponse.getCharacterEncoding();
                    }
                    printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), string));
                } else {
                    printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)servletResponse.getOutputStream()));
                }
            }
            catch (IllegalStateException illegalStateException) {
                printWriter = servletResponse.getWriter();
            }
        }
        return printWriter;
    }
}

