/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import oracle.aurora.mts.http.admin.PublishServlet;
import oracle.aurora.namespace.shell.ToolImpl;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.OracleClassLoader;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.OracleJsp2Java;
import oracle.jsp.tools.JspDatabaseResourceProvider;
import oracle.jsp.util.JspUtil;
import sun.io.CharacterEncoding;

public class JspcJServer
extends ToolImpl {
    public static final String SQLJ_TRANSLATOR = "sqlj_translator";
    public static final String SQLJ_EXTENSION = "sqlj";
    public static final String RES_EXTENSION = "res";
    public static final String SQLJSP_EXTENSION = "sqljsp";
    public static final String JAVA_EXTENSION = "java";
    private static final String GLOBALS_EXT = "jsa";
    private static final char FILE_SEP = '/';
    public static final int SUCCESS = 0;
    public static final int JSP_ERROR = -1;
    public static final int SQLJ_ERROR = -2;
    public static final int JAVAC_ERROR = -3;
    public static final int ARG_ERROR = -4;
    public static final int FILE_ERROR = -5;
    public static final int DB_ERROR = -6;
    public static final int PUBLISH_ERROR = -7;
    private Properties m_options;
    private boolean verbose = false;
    private boolean debug = false;
    private String givenEncoding = "ISO-8859-1";
    private String extend;
    private String implement;
    private String imports;
    private String givenPackageName;
    private String packageName = "";
    private String className;
    private ClassLoader classLoader;
    private String pagePath;
    private boolean genLineInfo = false;
    private boolean hotload = false;
    private boolean noCompile = false;
    private String user;
    private String givenServletName;
    private String resolverSpec;
    private String srcFile;
    private String outFile;
    private String resFile;
    private PrintWriter out;
    private InputStreamReader instr;
    private OutputStreamWriter outstr;
    private ByteArrayOutputStream ostr;
    private ByteArrayOutputStream rstr;
    private String givenVPath;
    private String context = "/webdomains/contexts/default";
    private boolean givenStatelessFlag = false;
    private Jsp2JavaParms parms = new Jsp2JavaParms();
    private OracleJsp2Java pageTranslator;
    private String[] jspFileList;
    private int numFiles;
    private int globalFile = -1;
    private int errorStatus = 0;
    private boolean helpDone = false;
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");
    private static final String MSG1_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs1 = ResourceBundle.getBundle("oracle.jsp.app.LocalStrings");

    public JspcJServer() {
        this.out = new PrintWriter(System.out, true);
    }

    public JspcJServer(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public static void main(String[] stringArray) {
        JspcJServer jspcJServer = new JspcJServer(new PrintWriter(System.out));
        try {
            jspcJServer.translate(stringArray);
            jspcJServer.out.flush();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(jspcJServer.out);
            jspcJServer.out.flush();
            return;
        }
    }

    public void goPublish(Writer writer) {
        this.out = new PrintWriter(writer);
        this.translate(null);
    }

    public void invoke() throws NamingException {
        this.translate(null);
        this.out.flush();
    }

    private boolean isJspClassExist() {
        try {
            this.getJspClass();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Class getJspClass() throws ClassNotFoundException {
        String string = null;
        string = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
        return DbmsJava.classForNameAndSchema((String)string, (String)this.user);
    }

    private void callHotLoadMainMethod() {
        if (!this.hotload) {
            return;
        }
        try {
            Class clazz = this.getJspClass();
            Object var2_3 = null;
            if (clazz == null) {
                return;
            }
            var2_3 = clazz.newInstance();
            if (var2_3 == null) {
                return;
            }
            Method method = clazz.getMethod("__jsp_hotload_class", null);
            if (method == null) {
                return;
            }
            method.invoke(var2_3, null);
            if (this.verbose) {
                this.out.println(String.valueOf(clazz.getName()) + msgs.getString("hotloaded"));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int translate(String[] stringArray) {
        if (stringArray != null) {
            this.parseArgs(stringArray);
            if (this.errorStatus != 0) {
                return this.errorStatus;
            }
        }
        if (this.user == null) {
            this.user = Schema.currentSchema().toString();
        }
        if (this.jspFileList == null || this.jspFileList.length == 0) {
            this.printLongHelp();
            this.errorStatus = -5;
            return this.errorStatus;
        }
        this.setupCommonParms();
        if (this.globalFile != -1) {
            this.prepareAndTranslate(this.globalFile);
            if (this.errorStatus != 0) {
                return this.errorStatus;
            }
            ++this.numFiles;
        }
        int n = 0;
        while (n < this.jspFileList.length) {
            if (n != this.globalFile) {
                this.prepareAndTranslate(n);
                if (this.errorStatus != 0) {
                    this.out.println("Error/Warnings (code " + this.errorStatus + "):" + this.jspFileList[n]);
                    this.errorStatus = 0;
                } else {
                    ++this.numFiles;
                }
            }
            ++n;
        }
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        if (this.verbose) {
            this.out.println(MessageFormat.format(msgs.getString("jsp_translate"), new Integer(this.numFiles)));
        }
        return this.errorStatus;
    }

    private int prepareAndTranslate(int n) {
        this.srcFile = this.jspFileList[n];
        this.setupFileParms();
        this.outFile = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
        this.outFile = String.valueOf(this.outFile.replace('.', '/')) + ".class";
        this.outFile = this.srcFile.endsWith(SQLJSP_EXTENSION) ? JspUtil.replaceTargetExtension(this.outFile, SQLJ_EXTENSION) : JspUtil.replaceTargetExtension(this.outFile, JAVA_EXTENSION);
        this.resFile = JspUtil.replaceTargetExtension(this.outFile, RES_EXTENSION);
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        this.jspTranslate(n, this.givenEncoding);
        if (this.isJspClassExist()) {
            this.errorStatus = 0;
        }
        if (this.errorStatus == 0) {
            this.callHotLoadMainMethod();
            if (this.verbose) {
                this.out.println(msgs.getString("publishing"));
            }
            if (n != this.globalFile) {
                this.publishServlet();
                if (this.verbose && this.errorStatus == 0) {
                    this.out.println(msgs.getString("publish_succeeded"));
                }
            }
        }
        if (this.verbose) {
            this.out.println();
        }
        return this.errorStatus;
    }

    private void publishServlet() {
        String string = null;
        string = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
        String string2 = this.givenVPath == null ? this.srcFile : this.givenVPath;
        String string3 = this.givenServletName == null ? string : this.givenServletName;
        string = String.valueOf(this.user) + ":" + string;
        try {
            if (this.verbose) {
                this.out.println(msgs.getString("publish_param"));
                this.out.println("context = " + this.context);
                this.out.println("virtualpath = " + string2);
                this.out.println("servletName = " + string3);
                this.out.println("className = " + string);
                this.out.println("stateless = " + this.givenStatelessFlag);
            }
            PublishServlet publishServlet = new PublishServlet(this.context, string3, string, string2, this.givenStatelessFlag);
            publishServlet.initializeFrom((ToolImpl)this);
            publishServlet.invoke();
            return;
        }
        catch (Exception exception) {
            this.errorStatus = -7;
            this.out.println(msgs.getString("publish_error"));
            this.out.println(exception.getMessage());
            return;
        }
    }

    public void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            n = this.processOptions(stringArray, n);
            if (this.errorStatus != 0) {
                return;
            }
            ++n;
        }
    }

    private int processOptions(String[] stringArray, int n) {
        int n2 = n;
        try {
            if (stringArray[n2].equalsIgnoreCase("-debug")) {
                this.genLineInfo = true;
            } else if (stringArray[n2].equalsIgnoreCase("-encoding")) {
                this.givenEncoding = stringArray[++n2];
                String string = CharacterEncoding.aliasName((String)this.givenEncoding);
                if (string == null) {
                    this.out.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", this.givenEncoding));
                    this.errorStatus = -4;
                }
            } else if (stringArray[n2].equalsIgnoreCase("-extend")) {
                this.extend = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-usage") || stringArray[n2].equalsIgnoreCase("-help")) {
                this.printLongHelp();
            } else if (stringArray[n2].equalsIgnoreCase("-h")) {
                this.printShortHelp();
            } else if (stringArray[n2].equalsIgnoreCase("-d")) {
                this.out.println(msgs.getString("print_desc"));
            } else if (stringArray[n2].equalsIgnoreCase("-implement")) {
                this.implement = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-packageName")) {
                this.givenPackageName = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-schema")) {
                this.user = stringArray[++n2];
                if (this.user != null) {
                    this.user = this.user.toUpperCase();
                }
            } else if (stringArray[n2].equalsIgnoreCase("-hotload")) {
                this.hotload = true;
            } else if (stringArray[n2].equalsIgnoreCase("-resolver")) {
                this.resolverSpec = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-servletName")) {
                this.givenServletName = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (stringArray[n2].equalsIgnoreCase("-version") || stringArray[n2].equalsIgnoreCase("-v") || stringArray[n2].equalsIgnoreCase("-showVersion")) {
                this.out.println(String.valueOf(msgs.getString("print_version")) + "1.1.0.0.0");
            } else if (stringArray[n2].equalsIgnoreCase("-context")) {
                this.context = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-vpath") || stringArray[n2].equalsIgnoreCase("-virtualpath")) {
                this.givenVPath = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-stateless")) {
                this.givenStatelessFlag = true;
            } else if (this.isSource(stringArray[n2])) {
                n2 = this.readFileList(stringArray, n2);
            } else {
                this.out.println(MessageFormat.format(msgs.getString("bad_option"), stringArray[n2]));
                this.errorStatus = -4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println(msgs.getString("bad_opt_list"));
            this.errorStatus = -4;
        }
        catch (Exception exception) {
            this.out.println(String.valueOf(msgs.getString("option_error")) + exception);
            this.errorStatus = -4;
        }
        return n2;
    }

    private void printDescription() {
        this.out.println(msgs.getString("print_desc"));
    }

    private void printShortHelp() {
        this.out.println(String.valueOf(msgs.getString("usage")) + "publishjsp <options> <file list> ");
        this.out.println(msgs.getString("help"));
    }

    private void printLongHelp() {
        if (this.helpDone) {
            return;
        }
        this.helpDone = true;
        this.out.println(String.valueOf(msgs.getString("usage")) + " publishjsp <options> <JSP resource> ");
        this.out.println(msgs.getString("options"));
        this.out.println("  -context <context>           " + msgs.getString("context"));
        this.out.println("  -extend <class name>         " + msgs.getString("extend"));
        this.out.println("  -implement <class name>      " + msgs.getString("implement"));
        this.out.println("  -hotload                     " + msgs.getString("hotload"));
        this.out.println("  -packageName <package name>  " + msgs.getString("package"));
        this.out.println("  -resolver <resolver>         Resolver spec for class loading");
        this.out.println("  -schema <schema>             " + msgs.getString("schema"));
        this.out.println("  -servletName <name>          " + msgs.getString("servletname"));
        this.out.println("  -showVersion                 " + msgs.getString("version"));
        this.out.println("  -stateless                   " + msgs.getString("stateless"));
        this.out.println("  -usage                       " + msgs.getString("print_usage"));
        this.out.println("  -verbose                     " + msgs.getString("verbose"));
        this.out.println("  -virtualpath <path>          " + msgs.getString("virtualpath"));
    }

    private void printVersion() {
        this.out.println(String.valueOf(msgs.getString("print_version")) + "1.1.0.0.0");
    }

    private boolean isSource(String string) {
        return string.endsWith(".sqlj") || string.endsWith(".java") || string.endsWith(".jsp") || string.endsWith(".JSP") || string.endsWith(".sqljsp") || string.endsWith(".SQLJSP") || string.endsWith(".jsa") || string.endsWith(".JSA");
    }

    private int readFileList(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        this.jspFileList = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.jspFileList[n3] = stringArray[n++];
            if (this.errorStatus != 0) {
                return this.errorStatus;
            }
            if (this.jspFileList[n3].endsWith(".jsa")) {
                if (this.globalFile != -1) {
                    this.out.println(msgs.getString("many_globals"));
                    this.errorStatus = -4;
                    return this.errorStatus;
                }
                this.globalFile = n3;
            }
            ++n3;
        }
        return stringArray.length;
    }

    private void setupFileParms() {
        this.parms.sourceFileName = this.srcFile;
        this.packageName = this.givenPackageName == null ? JspUtil.getPackageNameFromRelPath(this.srcFile, '/') : this.givenPackageName;
        this.className = JspUtil.getClassNameFromRelPath(this.srcFile, '/');
        this.parms.packageName = this.packageName;
        this.parms.className = this.className;
        this.parms.extend = this.extend;
        this.parms.implement = this.implement;
        this.parms.imports = null;
        String string = this.srcFile;
        if (!(string = JspUtil.stripTarget(string, '/')).equals("/")) {
            this.parms.pagePath = string;
        }
    }

    private void setupCommonParms() {
        this.parms.globalInfo = null;
        this.parms.debugOut = null;
        this.parms.genLineInfo = this.genLineInfo;
        this.parms.hotload = this.hotload;
        this.pageTranslator = new OracleJsp2Java();
        if (this.resolverSpec == null) {
            this.resolverSpec = "((* " + this.user + ") (* PUBLIC))";
        } else {
            String string = this.resolverSpec.trim();
            string = string.substring(1, string.length() - 1);
            this.resolverSpec = "((* " + this.user + ") " + string + ")";
        }
        try {
            this.parms.classLoader = OracleClassLoader.get((Resolver)new Resolver(this.resolverSpec), (Schema)Schema.lookup((String)this.user), (boolean)false, (boolean)false, null);
            if (this.parms.classLoader == null) {
                this.out.println(String.valueOf(msgs.getString("no_classloader")) + this.user);
                this.errorStatus = -6;
                return;
            }
            this.parms.resourceProvider = new JspDatabaseResourceProvider(this.parms.classLoader);
            if (this.parms.resourceProvider == null) {
                this.out.println(msgs.getString("no_res_provider"));
                this.errorStatus = -6;
                return;
            }
        }
        catch (InvalidResolverPatternException invalidResolverPatternException) {
            this.out.println(String.valueOf(msgs.getString("invalid_resolver")) + invalidResolverPatternException.getMessage());
            this.errorStatus = -6;
            return;
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            this.out.println(String.valueOf(msgs.getString("invalid_schema")) + schemaNotFoundException.getMessage());
            this.errorStatus = -6;
            return;
        }
    }

    private void jspTranslate(int n, String string) {
        try {
            if (this.verbose) {
                this.out.println(MessageFormat.format(msgs.getString("file_msg"), this.srcFile));
            }
            String string2 = null;
            if (string != null && (string2 = CharacterEncoding.aliasName((String)string)) == null) {
                this.out.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", string));
                this.errorStatus = -4;
                return;
            }
            this.parms.encoding = string;
            this.setupInOut(string2);
            if (this.errorStatus != 0) {
                return;
            }
            int n2 = this.srcFile.endsWith(GLOBALS_EXT) ? 1 : 0;
            if (this.pageTranslator.transform(this.parms, this.instr, this.outstr, this.rstr, n2) == 1 && !this.srcFile.endsWith(SQLJSP_EXTENSION)) {
                this.outFile = JspUtil.replaceTargetExtension(this.outFile, SQLJ_EXTENSION);
            }
            this.jspFileList[n] = this.outFile;
            this.loadTranslated(this.outFile, string2, this.ostr.toByteArray());
            if (this.hotload && this.rstr != null) {
                this.loadTranslated(this.resFile, null, this.rstr.toByteArray());
                return;
            }
        }
        catch (JspEncodingException jspEncodingException) {
            this.jspTranslate(n, jspEncodingException.getSpecifiedEncoding());
            return;
        }
        catch (JspParseException jspParseException) {
            this.out.println(MessageFormat.format(msgs.getString("parse_error"), this.srcFile));
            this.out.println(jspParseException);
            this.errorStatus = -1;
            this.jspFileList[n] = this.srcFile;
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out.println(MessageFormat.format(msgs.getString("no_file"), fileNotFoundException.getMessage()));
            this.errorStatus = -5;
            this.jspFileList[n] = this.srcFile;
            return;
        }
        catch (IOException iOException) {
            this.out.println(MessageFormat.format(msgs.getString("file_io_err"), this.srcFile));
            this.out.println(iOException.getMessage());
            this.errorStatus = -5;
            this.jspFileList[n] = this.srcFile;
        }
    }

    private void loadTranslated(String string, String string2, byte[] byArray) {
        LoadJava loadJava = new LoadJava();
        loadJava.setOutput(this.out);
        loadJava.setResolve(true);
        loadJava.setResolver(this.resolverSpec);
        loadJava.setSchema(this.user);
        loadJava.setVerbose(this.verbose);
        loadJava.setForceLoading(true);
        if (string2 != null) {
            loadJava.setEncoding(string2);
        }
        DatabaseOptions databaseOptions = new DatabaseOptions();
        try {
            databaseOptions.parseArgs(new String[]{"-kprb"});
        }
        catch (ToolsException toolsException) {
            this.out.println(String.valueOf(msgs.getString("db_conn_error")) + toolsException.getMessage());
        }
        loadJava.setDatabase(databaseOptions);
        if (this.verbose) {
            this.out.println(String.valueOf(msgs.getString("calling_loadjava_file")) + string);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        loadJava.add((InputStream)byteArrayInputStream, string);
        try {
            if (this.verbose) {
                this.out.println();
                this.out.println(msgs.getString("calling_loadjava"));
            }
            loadJava.processFinish();
            return;
        }
        catch (ToolsException toolsException) {
            this.errorStatus = -3;
            this.out.println(String.valueOf(msgs.getString("loadjava_exception")) + toolsException.getMessage());
            return;
        }
    }

    private void setupInOut(String string) {
        try {
            InputStream inputStream = this.parms.classLoader.getResourceAsStream(this.srcFile);
            if (inputStream == null) {
                this.out.println(String.valueOf(msgs.getString("cannot_find_jsp_a")) + this.srcFile + " " + msgs.getString("cannot_find_jsp_b") + this.user);
                this.errorStatus = -6;
                return;
            }
            this.ostr = new ByteArrayOutputStream();
            this.rstr = this.hotload ? new ByteArrayOutputStream() : null;
            if (string != null) {
                this.instr = new InputStreamReader(inputStream, string);
                this.outstr = new OutputStreamWriter((OutputStream)this.ostr, string);
                return;
            }
            this.instr = new InputStreamReader(inputStream);
            this.outstr = new OutputStreamWriter(this.ostr);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.out.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", string));
            this.errorStatus = -5;
            return;
        }
        catch (IOException iOException) {
            this.out.println(MessageFormat.format(msgs.getString("file_io_err"), this.srcFile));
            this.out.println(iOException.getMessage());
            this.errorStatus = -5;
            return;
        }
    }

    public void setSchema(String string) {
        this.user = string;
        if (this.user != null) {
            this.user = this.user.toUpperCase();
        }
    }

    public String getSchema() {
        return this.user;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public String getContext() {
        return this.context;
    }

    public void setVPath(String string) {
        this.givenVPath = string;
    }

    public String getVPath() {
        return this.givenVPath;
    }

    public void setStatelessFlag(boolean bl) {
        this.givenStatelessFlag = bl;
    }

    public boolean getStatelessFlag() {
        return this.givenStatelessFlag;
    }

    public void setEncoding(String string) {
        this.givenEncoding = string;
    }

    public String getEncoding() {
        return this.givenEncoding;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setServletName(String string) {
        this.givenServletName = string;
    }

    public String getServletName() {
        return this.givenServletName;
    }

    public void setVerbose(String string) {
        if (string.equalsIgnoreCase("true")) {
            this.verbose = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setDebug(String string) {
        if (string.equalsIgnoreCase("true")) {
            this.debug = true;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setResolver(String string) {
        this.resolverSpec = string;
    }

    public String getResolver() {
        return this.resolverSpec;
    }

    public String getJspFile() {
        return this.jspFileList[0];
    }

    public void setJspFile(String string) {
        this.jspFileList = new String[]{string};
    }

    public void validateArgs() {
    }
}

