/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import oracle.aurora.mts.http.admin.UnpublishServlet;
import oracle.aurora.namespace.shell.ToolImpl;
import oracle.jsp.util.JspUtil;

public class UnpublishJsp
extends ToolImpl {
    private PrintWriter out = new PrintWriter(System.out, true);
    private boolean verbose = false;
    private boolean debug = false;
    private boolean genLineInfo = false;
    private String packageName;
    private String vPath;
    private String context = "/webdomains/contexts/default";
    private String user;
    private String servletName;
    private String srcFile;
    private String className;
    private int errorStatus = 0;
    private static final char FILE_SEP = '/';
    private boolean helpDone = false;
    public static final int SUCCESS = 0;
    public static final int JSP_ERROR = -1;
    public static final int SQLJ_ERROR = -2;
    public static final int JAVAC_ERROR = -3;
    public static final int ARG_ERROR = -4;
    public static final int FILE_ERROR = -5;
    public static final int DB_ERROR = -6;
    public static final int PUBLISH_ERROR = -7;
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");

    public void invoke() throws NamingException {
        if (this.srcFile == null && this.servletName == null) {
            this.printLongHelp();
            return;
        }
        try {
            try {
                if (this.className == null) {
                    this.className = JspUtil.getClassNameFromRelPath(this.srcFile, '/');
                }
                if (this.packageName == null) {
                    this.packageName = JspUtil.getPackageNameFromRelPath(this.srcFile, '/');
                }
                String string = null;
                string = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
                if (this.vPath == null) {
                    this.vPath = this.srcFile;
                }
                if (this.servletName == null) {
                    this.servletName = string;
                }
                if (this.verbose) {
                    this.out.println(msgs.getString("unpublish_param"));
                    this.out.println("context = " + this.context);
                    this.out.println("servletName = " + this.servletName);
                }
                UnpublishServlet unpublishServlet = new UnpublishServlet(this.context, this.servletName);
                unpublishServlet.initializeFrom((ToolImpl)this);
                unpublishServlet.invoke();
            }
            catch (Exception exception) {
                this.errorStatus = -7;
                this.out.println(msgs.getString("unpublish_error"));
                this.out.println(exception.getMessage());
            }
            Object var2_4 = null;
            this.out.flush();
            return;
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.out.flush();
            throw throwable;
        }
    }

    public void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            n = this.processOptions(stringArray, n);
            if (this.errorStatus != 0) {
                return;
            }
            ++n;
        }
    }

    private int processOptions(String[] stringArray, int n) {
        int n2 = n;
        try {
            if (stringArray[n2].equalsIgnoreCase("-usage") || stringArray[n2].equalsIgnoreCase("-h") || stringArray[n2].equalsIgnoreCase("-help")) {
                this.printLongHelp();
            } else if (stringArray[n2].equalsIgnoreCase("-context")) {
                this.context = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-servletName")) {
                this.servletName = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (stringArray[n2].equalsIgnoreCase("-d")) {
                this.out.println(msgs.getString("print_unpublish_desc"));
            } else if (stringArray[n2].equalsIgnoreCase("-version") || stringArray[n2].equalsIgnoreCase("-v") || stringArray[n2].equalsIgnoreCase("-showVersion")) {
                this.out.println(String.valueOf(msgs.getString("print_version")) + "1.1.0.0.0");
            } else if (this.isSource(stringArray[n2])) {
                this.srcFile = stringArray[n2];
            } else {
                this.out.println(MessageFormat.format(msgs.getString("bad_option"), stringArray[n2]));
                this.errorStatus = -4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println(msgs.getString("bad_opt_list"));
            this.errorStatus = -4;
        }
        catch (Exception exception) {
            this.out.println(String.valueOf(msgs.getString("option_error")) + exception);
            this.errorStatus = -4;
        }
        return n2;
    }

    private void printVersion() {
        this.out.println(String.valueOf(msgs.getString("print_version")) + "1.1.0.0.0");
    }

    private void printLongHelp() {
        if (this.helpDone) {
            return;
        }
        this.helpDone = true;
        this.out.println(String.valueOf(msgs.getString("usage")) + " unpublishjsp <options> <JSP resource> ");
        this.out.println(msgs.getString("options"));
        this.out.println("  -showVersion                 " + msgs.getString("version"));
        this.out.println("  -usage                       " + msgs.getString("print_usage"));
        this.out.println("  -verbose                     " + msgs.getString("verbose"));
        this.out.println("  -context <context>           " + msgs.getString("context"));
        this.out.println("  -servletName <name>          " + msgs.getString("servletname"));
    }

    private boolean isSource(String string) {
        return string.endsWith(".sqlj") || string.endsWith(".java") || string.endsWith(".jsp") || string.endsWith(".JSP") || string.endsWith(".sqljsp") || string.endsWith(".SQLJSP") || string.endsWith(".jsa") || string.endsWith(".JSA");
    }
}

