/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import oracle.xml.classgen.CGNode;
import oracle.xml.classgen.InvalidContentException;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public abstract class CGDocument
extends CGNode {
    XMLDocument xmlDocument = new XMLDocument();
    Vector all_ids = new Vector();
    Vector all_idrefs = new Vector();

    protected CGDocument(String string, DTD dTD) {
        super(string);
        this.setDocument(this);
        this.xmlDocument.setDoctype(dTD.getName(), dTD.getSystemId(), dTD.getPublicId());
        this.xmlDocument.appendChild((Node)this.theElement);
    }

    protected void print(OutputStream outputStream) throws InvalidContentException {
        this.setDocument(this);
        if (this.isValidating) {
            if (!this.verifyIDREFS()) {
                throw new InvalidContentException("Invalid IDREF specified");
            }
            this.validateContent();
        }
        try {
            this.xmlDocument.print(outputStream);
        }
        catch (IOException iOException) {
            throw new InvalidContentException(iOException.getMessage());
        }
    }

    protected void print(OutputStream outputStream, String string) throws InvalidContentException {
        this.setDocument(this);
        if (this.isValidating) {
            if (!this.verifyIDREFS()) {
                throw new InvalidContentException("Invalid IDREF specified");
            }
            this.validateContent();
        }
        try {
            this.xmlDocument.print(outputStream, string);
        }
        catch (IOException iOException) {
            throw new InvalidContentException(iOException.getMessage());
        }
    }

    void storeID(String string) {
        this.all_ids.addElement(string);
    }

    void storeIDREF(String string) {
        this.all_idrefs.addElement(string);
    }

    boolean verifyIDREF(String string) {
        return this.all_ids.contains(string);
    }

    boolean verifyIDREFS() {
        super.verifyIDREFS();
        int n = this.all_idrefs.size();
        int n2 = 0;
        while (n2 < n) {
            if (!this.all_ids.contains((String)this.all_idrefs.elementAt(n2))) {
                this.all_ids = new Vector();
                this.all_idrefs = new Vector();
                return false;
            }
            ++n2;
        }
        this.all_ids = new Vector();
        this.all_idrefs = new Vector();
        return true;
    }
}

