/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import org.w3c.dom.NamedNodeMap;

public class ClassGenerator {
    private boolean m_bSerialize = false;
    private boolean m_bValidate = true;
    private boolean m_bComments = true;
    private String m_packageName = null;
    private String m_dirName = null;
    private PrintWriter m_pw;
    private String m_elementName;
    private String m_className;
    private DTD m_dtd;
    private String m_doctype;
    private static final String MAJORVERSION = "1";
    private static final String MINORVERSION = "0";
    private static final String PATCHVERSION = "0";
    private static final String TAB = "    ";
    private static final String NL = "\"\\n\"";

    private String className(String string) {
        String string2 = this.varName(string);
        return this.initCaps(string2);
    }

    private void closeFile() {
        this.m_pw.println("}");
        this.m_pw.close();
        this.m_elementName = "";
    }

    private void createClass(String string) throws Exception {
        int n;
        int n2;
        AttrDecl attrDecl;
        int n3;
        int n4;
        ElementDecl elementDecl = this.m_dtd.findElementDecl(string);
        NamedNodeMap namedNodeMap = elementDecl.getAttrDecls();
        this.m_elementName = string;
        this.m_className = this.className(string);
        this.openFile();
        this.printPackage();
        this.printImports();
        this.printClassDef();
        Vector<AttrDecl> vector = null;
        if (namedNodeMap != null) {
            n4 = namedNodeMap.getLength();
            n3 = 0;
            while (n3 < n4) {
                attrDecl = (AttrDecl)namedNodeMap.item(n3);
                n2 = attrDecl.getAttrPresence();
                n = attrDecl.getAttrType();
                if (n2 == 1) {
                    if (vector == null) {
                        vector = new Vector<AttrDecl>();
                    }
                    vector.addElement(attrDecl);
                }
                ++n3;
            }
        }
        this.printConstructors(vector);
        if (elementDecl.getContentType() == 3) {
            this.printPCDATAConstructors(vector);
        }
        if (this.m_className.equals(this.m_doctype)) {
            this.printDocumentMethods();
        }
        switch (elementDecl.getContentType()) {
            case 2: {
                String string2;
                NamedNodeMap namedNodeMap2 = this.m_dtd.getElementDecls();
                n = namedNodeMap2.getLength();
                n3 = 0;
                while (n3 < n) {
                    ElementDecl elementDecl2 = (ElementDecl)namedNodeMap2.item(n3);
                    string2 = elementDecl2.getNodeName();
                    this.printAddNodeMethod(this.className(string2));
                    ++n3;
                }
                break;
            }
            case 3: {
                String string2;
                Vector vector2 = elementDecl.getContentElements();
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (string2.equals("PCDATA")) {
                        this.printAddDataMethod();
                        this.printCDATASectionMethod();
                        continue;
                    }
                    this.printAddNodeMethod(this.className(string2));
                }
                break;
            }
            case 4: {
                String string2;
                Vector vector2 = elementDecl.getContentElements();
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    this.printAddNodeMethod(this.className(string2));
                }
                break;
            }
        }
        if (namedNodeMap != null) {
            n4 = namedNodeMap.getLength();
            n = 0;
            while (n < n4) {
                attrDecl = (AttrDecl)namedNodeMap.item(n);
                n2 = attrDecl.getAttrPresence();
                if (n2 != 3) {
                    this.printSetMethod(attrDecl);
                }
                ++n;
            }
        }
        this.printMiscMethods();
        this.closeFile();
    }

    private String enumeratedName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        int n = 0;
        while (n < stringBuffer.length()) {
            if (!Character.isLetterOrDigit(stringBuffer.charAt(n))) {
                stringBuffer.setCharAt(n, '_');
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string2.toUpperCase());
        int n2 = 0;
        while (n2 < stringBuffer2.length()) {
            if (!Character.isLetterOrDigit(stringBuffer2.charAt(n2))) {
                stringBuffer2.setCharAt(n2, '_');
            }
            ++n2;
        }
        return new String(String.valueOf(stringBuffer.toString()) + "_" + stringBuffer2.toString());
    }

    private String functionName(String string) {
        return new String("set" + this.initCaps(this.varName(string)));
    }

    public void generate(DTD dTD, String string) {
        this.m_dtd = dTD;
        this.m_doctype = this.className(string);
        try {
            NamedNodeMap namedNodeMap = dTD.getElementDecls();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                ElementDecl elementDecl = (ElementDecl)namedNodeMap.item(n2);
                this.createClass(elementDecl.getNodeName());
                ++n2;
            }
            if (this.m_bSerialize) {
                this.serializeDTD();
            } else {
                this.printDTD();
            }
        }
        catch (Exception exception) {
            System.out.println("A error occurred generating the classes: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static String getVersion() {
        return "1.0.0";
    }

    private String initCaps(String string) {
        char c = string.charAt(0);
        c = Character.toUpperCase(c);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, c);
        return stringBuffer.toString();
    }

    private void openFile() throws Exception {
        String string = String.valueOf(this.m_className) + ".java";
        try {
            File file = this.m_dirName != null ? new File(this.m_dirName, string) : new File(string);
            FileWriter fileWriter = new FileWriter(file);
            this.m_pw = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            throw new Exception("Cannot create " + string);
        }
        this.printPreface(string);
    }

    private void printAddDataMethod() {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Add  a text node to <code>" + this.m_elementName + "</code>");
            this.tabPrint(1, " * @param theData value of the text node");
            this.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void addData(String theData) throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.addData(theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printAddNodeMethod(String string) {
        String string2 = string.substring(0, 1);
        if (string2.equals(string)) {
            string2 = "the" + string2;
        }
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Add <code>" + string + "</code> to <code>" + this.initCaps(this.m_elementName) + "</code>");
            this.tabPrint(1, " * @param " + string2 + " Node of type <code>" + string + "</code>");
            this.tabPrint(1, " * @exception InvalidContentException  if node cannot be added as per ");
            this.tabPrint(1, " *            the Content model of the element.");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void addNode(" + string + " " + string2 + ") throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.addNode(" + string2 + ");");
        if (this.m_className.equals(this.m_doctype)) {
            this.tabPrint(2, String.valueOf(string2) + ".setDocument(this);");
        }
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printCDATASectionMethod() {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Add  a CDATA node to <code>" + this.m_elementName + "</code>");
            this.tabPrint(1, " * @param theData value of the CDATA node");
            this.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void addCDATASection(String theData) throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.addCDATASection(theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printClassDef() {
        if (this.m_className.equals(this.m_doctype)) {
            if (this.m_bComments) {
                this.tabPrint(0, "/**");
                this.tabPrint(0, " * The Document Class (for the root element " + this.initCaps(this.m_doctype) + ")");
                this.tabPrint(0, " */");
            }
            this.m_pw.println("public class " + this.m_className + " extends CGDocument");
            this.m_pw.println("{");
            this.m_pw.println();
            this.printStaticInitializers();
        } else {
            if (this.m_bComments) {
                this.tabPrint(0, "/**");
                this.tabPrint(0, " * The Node Class (for the root element " + this.initCaps(this.m_className) + ")");
                this.tabPrint(0, " */");
            }
            this.m_pw.println("public class " + this.m_className + " extends CGNode");
            this.m_pw.println("{");
        }
        this.m_pw.println();
    }

    private void printConstructors(Vector vector) {
        String string;
        AttrDecl attrDecl;
        int n;
        int n2 = 0;
        if (vector == null) {
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Default Constructor");
                this.tabPrint(1, " */");
            }
            this.tabPrint(1, "public " + this.m_className + "()");
        } else {
            n2 = vector.size();
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Constructor with the required Attributes");
                n = 0;
                while (n < n2) {
                    attrDecl = (AttrDecl)vector.elementAt(n);
                    string = attrDecl.getNodeName();
                    this.tabPrint(1, " * @param " + this.variableName(string) + " for the Attribute " + string);
                    this.tabPrint(1, " * @exception InvalidContentException  if invalid value is specified for an attribute");
                    ++n;
                }
                this.tabPrint(1, " */");
            }
            this.m_pw.print("    public " + this.m_className + "(");
            n = 0;
            while (n < n2) {
                if (n > 0) {
                    this.m_pw.print(", ");
                }
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                int n3 = attrDecl.getAttrType();
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        this.m_pw.print("String " + this.variableName(string));
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        this.m_pw.print("String[] " + this.variableName(string));
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.m_pw.print("int " + this.variableName(string));
                        break;
                    }
                }
                ++n;
            }
            this.m_pw.println(") throws InvalidContentException");
        }
        this.tabPrint(1, "{");
        if (this.m_className.equals(this.m_doctype)) {
            this.tabPrint(2, "super(" + this.quoteString(this.m_elementName) + ", globalDTD);");
        } else {
            this.tabPrint(2, "super(" + this.quoteString(this.m_elementName) + ");");
        }
        if (vector != null) {
            this.tabPrint(2, "try");
            this.tabPrint(2, "{");
            n = 0;
            while (n < n2) {
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                this.tabPrint(3, String.valueOf(this.functionName(string)) + "(" + this.variableName(string) + ");");
                ++n;
            }
            this.tabPrint(2, "}");
            this.tabPrint(2, "catch (IllegalArgumentException e) { ");
            this.tabPrint(3, "throw new InvalidContentException(\"Invalid Attribute value specified\"); }");
        }
        if (this.m_bValidate) {
            this.tabPrint(2, "isValidating = true;");
        } else {
            this.tabPrint(2, "isValidating = false;");
        }
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printDTD() {
        try {
            String string = String.valueOf(this.m_doctype) + "_dtd.txt";
            File file = this.m_dirName != null ? new File(this.m_dirName, string) : new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.m_dtd.printExternalDTD((OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("XML Class Generator: Error writing DTD: " + iOException.toString());
        }
    }

    private void printDocumentMethods() {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Prints the document to the specified OutputStream");
            this.tabPrint(1, " * @param out Java outputstream.");
            this.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void print(OutputStream out) throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.print(out);");
        this.tabPrint(1, "}");
        this.m_pw.println();
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Prints the document to the specified OutputStream");
            this.tabPrint(1, " * in the given encoding");
            this.tabPrint(1, " * @param out Java outputstream.");
            this.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void print(OutputStream out, String enc) throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.print(out, enc);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printImports() {
        this.m_pw.println("import java.io.*;");
        this.m_pw.println("import java.net.*;");
        this.m_pw.println();
        this.m_pw.println("import oracle.xml.classgen.CGNode;");
        this.m_pw.println("import oracle.xml.classgen.CGDocument;");
        this.m_pw.println("import oracle.xml.classgen.InvalidContentException;");
        this.m_pw.println("import oracle.xml.parser.v2.*;");
        this.m_pw.println();
    }

    private void printMiscMethods() {
        if (this.m_bComments) {
            this.tabPrint(1, "/** ");
            this.tabPrint(1, " * Returns the " + this.initCaps(this.m_doctype) + " DTD.");
            this.tabPrint(1, " * @return the DTD");
            this.tabPrint(1, " * @see oracle.xml.parser.v2.DTD");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public DTD getDTDNode()");
        this.tabPrint(1, "{");
        if (this.m_className.equals(this.m_doctype)) {
            this.tabPrint(2, "return globalDTD;");
        } else {
            this.tabPrint(2, "return " + this.m_doctype + ".globalDTD;");
        }
        this.tabPrint(1, "}");
        this.m_pw.println();
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Validate contents of element <code>" + this.m_className + "</code>");
            this.tabPrint(1, " * @return true if valid contents, else false");
            this.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void validateContent() throws InvalidContentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "super.validateContent();");
        this.tabPrint(1, "}");
        this.m_pw.println();
        if (!this.m_className.equals(this.m_doctype)) {
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Get Document Class <code>" + this.initCaps(this.m_doctype) + "</code>");
                this.tabPrint(1, " * @return <code>" + this.initCaps(this.m_doctype) + "</code> class");
                this.tabPrint(1, " */");
            }
            this.tabPrint(1, "public " + this.initCaps(this.m_doctype) + " getDocument()");
            this.tabPrint(1, "{");
            this.tabPrint(2, "return (" + this.initCaps(this.m_doctype) + ")super.getCGDocument();");
            this.tabPrint(1, "}");
        }
        this.m_pw.println();
    }

    private void printPCDATAConstructors(Vector vector) {
        String string;
        AttrDecl attrDecl;
        int n;
        int n2 = 0;
        if (vector == null) {
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Constructor taking <code>#PCDATA</code>");
                this.tabPrint(1, " * @param theData  text for the Element");
                this.tabPrint(1, " * @exception InvalidContentException  <code>theData</code> is invalid");
                this.tabPrint(1, " */");
            }
            this.tabPrint(1, "public " + this.m_className + "(String theData) throws InvalidContentException");
        } else {
            n2 = vector.size();
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Constructor with the required Attributes and <code>#PCDATA</code>");
                n = 0;
                while (n < n2) {
                    attrDecl = (AttrDecl)vector.elementAt(n);
                    string = attrDecl.getNodeName();
                    this.tabPrint(1, " * @param " + this.variableName(string) + " for the Attribute " + string);
                    this.tabPrint(1, " * @exception InvalidContentException  if invalid value is specified for an attribute");
                    this.tabPrint(1, " *           or <code>theData</code> is invalid");
                    ++n;
                }
                this.tabPrint(1, " */");
            }
            this.m_pw.print("    public " + this.m_className + "(String theData");
            n = 0;
            while (n < n2) {
                this.m_pw.print(", ");
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                int n3 = attrDecl.getAttrType();
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        this.m_pw.print("String " + this.variableName(string));
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        this.m_pw.print("String[] " + this.variableName(string));
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.m_pw.print("int " + this.variableName(string));
                        break;
                    }
                }
                ++n;
            }
            this.m_pw.println(") throws InvalidContentException");
        }
        this.tabPrint(1, "{");
        if (vector != null) {
            this.m_pw.print("        this(");
            n = 0;
            while (n < n2) {
                if (n > 0) {
                    this.m_pw.print(", ");
                }
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                this.m_pw.print(this.variableName(string));
                ++n;
            }
            this.m_pw.print(");");
        } else {
            this.tabPrint(2, "this();");
        }
        this.tabPrint(2, "super.addData(theData);");
        if (vector != null) {
            this.tabPrint(2, "try");
            this.tabPrint(2, "{");
            n = 0;
            while (n < n2) {
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                this.tabPrint(3, String.valueOf(this.functionName(string)) + "(" + this.variableName(string) + ");");
                ++n;
            }
            this.tabPrint(2, "}");
            this.tabPrint(2, "catch (IllegalArgumentException e) { ");
            this.tabPrint(3, "throw new InvalidContentException(\"Invalid Attribute value specified\"); }");
        }
        if (this.m_bValidate) {
            this.tabPrint(2, "isValidating = true;");
        } else {
            this.tabPrint(2, "isValidating = false;");
        }
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printPackage() {
        if (this.m_packageName != null) {
            this.m_pw.println("package " + this.m_packageName + ";");
            this.m_pw.println();
        }
    }

    private void printPreface(String string) {
        Date date = new Date();
        this.m_pw.println("/* DO NOT EDIT THIS FILE - it is machine-generated */");
        this.m_pw.println("/* File: " + string + " - generated by XML Class Generator version " + ClassGenerator.getVersion() + " at " + date.toString() + " */");
        this.m_pw.println();
    }

    private void printSetCData(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " */");
        }
        this.m_pw.print("    public void " + this.functionName(string) + "(String theData) ");
        this.m_pw.println();
        this.m_pw.println("    {");
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetEntities(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException  ");
            this.tabPrint(1, " *           if the one of the entities in the attribute (ENTITIES) is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String[] theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "String concatenatedData = new String();");
        this.m_pw.println();
        this.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        this.tabPrint(2, "{");
        if (this.m_bValidate) {
            this.tabPrint(3, "if (!validEntity(theData[i]))");
            this.tabPrint(4, "throw new IllegalArgumentException(" + this.quoteString("An entity has not been declared in the DTD.") + ");");
        }
        this.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        this.tabPrint(3, "}");
        this.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", concatenatedData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetEntity(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException  ");
            this.tabPrint(1, " *           if the value of the attribute (ENTITY) is not a valid ENTITY");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        if (this.m_bValidate) {
            this.tabPrint(2, "if (!validEntity(theData))");
            this.tabPrint(3, "throw new IllegalArgumentException(" + this.quoteString("An entity has not been declared in the DTD.") + ");");
        }
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetEnumeration(String string, AttrDecl attrDecl) {
        String string2;
        int n = 1;
        Enumeration enumeration = attrDecl.getEnumerationValues().elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (this.m_bComments) {
                this.tabPrint(1, "/**");
                this.tabPrint(1, " * Constant for enumerated value <code>" + string2 + "</code> for Attribute <code>" + string + "</code>");
                this.tabPrint(1, " */");
            }
            this.tabPrint(1, "public static final int " + this.enumeratedName(string, string2) + " = " + n + ";");
            ++n;
        }
        this.m_pw.println();
        String string3 = this.variableName(string);
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param " + string3 + " value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException  ");
            this.tabPrint(1, " *           if the value is out of range");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(int " + string3 + ") throws IllegalArgumentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "int MAX_VALUE = " + (n - 1) + ";");
        this.tabPrint(2, "if ((" + string3 + ">MAX_VALUE) || (" + string3 + "<1))");
        this.tabPrint(3, "throw new IllegalArgumentException();");
        this.m_pw.println();
        this.tabPrint(2, "switch (" + string3 + ")");
        this.tabPrint(2, "{");
        n = 1;
        enumeration = attrDecl.getEnumerationValues().elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            this.tabPrint(3, "case(" + this.enumeratedName(string, string2) + "):");
            this.tabPrint(4, "setAttribute(" + this.quoteString(string) + ", " + this.quoteString(string2) + ");");
            this.tabPrint(4, "break;");
        }
        this.tabPrint(2, "}");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetID(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException ");
            this.tabPrint(1, " *            if the value of the attribute (ID) is invalid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        if (this.m_bValidate) {
            this.tabPrint(2, "if (!validID(theData))");
            this.tabPrint(3, "throw new IllegalArgumentException();");
            this.tabPrint(2, "storeID(" + this.quoteString(string) + ", theData);");
        }
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetIDREF(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException ");
            this.tabPrint(1, " *           if the value of the attribute (IDREF) is not a valid ID");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        if (this.m_bValidate) {
            this.tabPrint(2, "if (!validID(theData))");
            this.tabPrint(3, "throw new IllegalArgumentException(" + this.quoteString("Invalid ID has been specified") + ");");
            this.tabPrint(2, "storeIDREF(" + this.quoteString(string) + ", theData);");
        }
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetIDREFS(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException ");
            this.tabPrint(1, " *           if the one of the ids in the attribute (IDREFS) is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String[] theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "String concatenatedData = new String();");
        this.m_pw.println();
        this.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        this.tabPrint(2, "{");
        if (this.m_bValidate) {
            this.tabPrint(3, "if (!validID(theData[i]))");
            this.tabPrint(4, "throw new IllegalArgumentException(" + this.quoteString("Invalid ID has been specified") + ");");
            this.tabPrint(3, "storeIDREF(" + this.quoteString(string) + ", theData[i]);");
        }
        this.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        this.tabPrint(3, "}");
        this.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", concatenatedData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetMethod(AttrDecl attrDecl) {
        String string = attrDecl.getNodeName();
        int n = attrDecl.getAttrType();
        String string2 = "set" + string;
        switch (n) {
            case 0: {
                this.printSetCData(string, attrDecl);
                break;
            }
            case 1: {
                this.printSetID(string, attrDecl);
                break;
            }
            case 2: {
                this.printSetIDREF(string, attrDecl);
                break;
            }
            case 3: {
                this.printSetIDREFS(string, attrDecl);
                break;
            }
            case 4: {
                this.printSetEntity(string, attrDecl);
                break;
            }
            case 5: {
                this.printSetEntities(string, attrDecl);
                break;
            }
            case 6: {
                this.printSetNMTOKEN(string, attrDecl);
                break;
            }
            case 7: {
                this.printSetNMTOKENS(string, attrDecl);
                break;
            }
            case 8: {
                this.printSetEnumeration(string, attrDecl);
                break;
            }
            case 9: {
                this.printSetEnumeration(string, attrDecl);
                break;
            }
        }
    }

    private void printSetNMTOKEN(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException  ");
            this.tabPrint(1, " *           if the value of the attribute (NMTOKEN) is not a valid NMTOKEN");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        if (this.m_bValidate) {
            this.tabPrint(2, "if (!validNMTOKEN(theData))");
            this.tabPrint(3, "throw new IllegalArgumentException(" + this.quoteString("Invalid NMTOKEN has been specified") + ");");
        }
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", theData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printSetNMTOKENS(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            this.tabPrint(1, "/**");
            this.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            this.tabPrint(1, " * @param theData value of the attribute");
            this.tabPrint(1, " * @exception IllegalArgumentException  ");
            this.tabPrint(1, " *           if the one of the entities in the attribute (NMTOKENS) is not valid");
            this.tabPrint(1, " */");
        }
        this.tabPrint(1, "public void " + this.functionName(string) + "(String[] theData) throws IllegalArgumentException");
        this.tabPrint(1, "{");
        this.tabPrint(2, "String concatenatedData = new String();");
        this.m_pw.println();
        this.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        this.tabPrint(2, "{");
        if (this.m_bValidate) {
            this.tabPrint(3, "if (!validNMTOKEN(theData[i]))");
            this.tabPrint(4, "throw new IllegalArgumentException(" + this.quoteString("Invalid NMTOKEN has been specified") + ");");
        }
        this.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        this.tabPrint(3, "}");
        this.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        this.tabPrint(2, "setAttribute(" + this.quoteString(string) + ", concatenatedData);");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private void printStaticInitializers() {
        this.tabPrint(1, "public static DTD globalDTD = null;");
        this.m_pw.println();
        this.tabPrint(1, "static");
        this.tabPrint(1, "{");
        if (this.m_bSerialize) {
            this.tabPrint(2, "String dtdFile = \"" + this.m_doctype + "_dtd.ser\";");
        } else {
            this.tabPrint(2, "String dtdFile = \"" + this.m_doctype + "_dtd.txt\";");
        }
        this.m_pw.println();
        this.tabPrint(2, "DOMParser parser = new DOMParser();");
        this.m_pw.println();
        this.tabPrint(2, "try");
        this.tabPrint(2, "{");
        if (this.m_bSerialize) {
            this.tabPrint(3, "XMLDocument doc;");
            this.tabPrint(3, "InputStream is = new FileInputStream(dtdFile);");
            this.tabPrint(3, "ObjectInputStream ois = new ObjectInputStream(is);");
            this.tabPrint(3, "globalDTD = (DTD)ois.readObject();");
            this.tabPrint(3, "doc = (XMLDocument)globalDTD.getParentNode();");
            this.tabPrint(3, "globalDTD = (DTD)doc.removeChild(globalDTD);");
            this.tabPrint(3, "ois.close();");
        } else {
            this.tabPrint(3, "File file = new File(dtdFile);");
            this.tabPrint(3, "String path = file.getAbsolutePath();");
            this.tabPrint(3, "String fSep = System.getProperty(\"file.separator\");");
            this.tabPrint(3, "if (fSep != null && fSep.length() == 1)");
            this.tabPrint(4, "path = path.replace(fSep.charAt(0), '/');");
            this.tabPrint(3, "if (path.length() > 0 && path.charAt(0) != '/')");
            this.tabPrint(4, "path = '/' + path;");
            this.tabPrint(3, "parser.parseDTD(new URL(\"file\", null, path), " + this.quoteString(this.m_dtd.getNodeName()) + ");");
            this.tabPrint(3, "globalDTD = (DTD)parser.getDoctype();");
        }
        this.tabPrint(2, "}");
        this.tabPrint(2, "catch (Exception e)");
        this.tabPrint(2, "{");
        this.tabPrint(3, "System.out.println(\"Unexpected error opening DTD file\");");
        this.tabPrint(2, "}");
        this.tabPrint(1, "}");
        this.m_pw.println();
    }

    private String quoteString(String string) {
        return new String("\"" + string + "\"");
    }

    private void serializeDTD() {
        try {
            String string = String.valueOf(this.m_doctype) + "_dtd.ser";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.m_dtd);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("XML Class Generator: Error serializing DTD: " + iOException.toString());
        }
    }

    public void setGenerateComments(boolean bl) {
        this.m_bComments = bl;
    }

    public void setJavaPackage(String string) {
        this.m_packageName = string;
    }

    public void setOutputDirectory(String string) {
        this.m_dirName = string;
    }

    public void setSerializationMode(boolean bl) {
        this.m_bSerialize = bl;
    }

    public void setValidationMode(boolean bl) {
        this.m_bValidate = bl;
    }

    private void tabPrint(int n, String string) {
        int n2 = 0;
        while (n2 < n) {
            this.m_pw.print(TAB);
            ++n2;
        }
        this.m_pw.println(string);
    }

    private String varName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (!Character.isLetterOrDigit(stringBuffer.charAt(n))) {
                stringBuffer.setCharAt(n, '_');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private String variableName(String string) {
        return new String("var" + this.initCaps(this.varName(string)));
    }
}

