Rem
Rem $Header: a0801060.sql 18-may-2000.15:30:05 sbalaram Exp $
Rem
Rem a0801060.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999, 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      a0801060.sql - additional ANONYMOUS BLOCK dictionary upgrade.
Rem      		Upgrade Oracle RDBMS from 8.1.6 to the new release
Rem
Rem    DESCRIPTION
Rem      Additional upgrade script to be run during the migration of an
Rem      8.1.6 database to the new release.
Rem
Rem	 This script is called from u0801060.sql and a0801050.sql
Rem
Rem	 Put any anonymous block related changes here.
Rem	 Any dictionary create, alter, updates and deletes  
Rem 	 that must be performed before catalog.sql and catproc.sql go 
Rem	 in c0801060.sql
Rem
Rem      The upgrade is performed in the following stages:
Rem        STAGE 1: additional steps to upgrade from 8.1.6 to 8.1.7
Rem        STAGE 2: upgrade from 8.1.6 to the new release
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      You must connect internal to run this script
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tchou       06/27/00 - remove JAVA SRO
Rem    sbalaram    05/18/00 - Set fire once trigger bit for DML triggers
Rem    mjungerm    05/17/00 - javavm up/downgrade
Rem    rshaikh     10/29/99 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================

REM INSERT YOUR UPGRADE STATEMENTS HERE

Rem Set the fire once trigger bit in trigger$ for DML triggers
Rem (excluding instead-of triggers)

DECLARE
  CURSOR trig IS
    SELECT u.name towner, o.name tname
      FROM sys.obj$ o, sys.user$ u, sys.trigger$ t
     WHERE o.owner# = u.user#
       AND o.type# = dbms_ddl_internal.sys_obj_type_trigger
       AND o.obj# = t.obj#
       AND t.update$ + t.delete$ + t.insert$ > 0
       AND bitand(t.property, 1) = 0;
BEGIN
  FOR rec IN trig LOOP
    BEGIN
      dbms_ddl.set_trigger_firing_property(rec.towner, rec.tname, TRUE);
    EXCEPTION WHEN others THEN
      DBMS_SYSTEM.KSDWRT(2, 'Trigger ' || rec.towner || '.' || rec.tname ||
                            'failed with Error' || TO_CHAR(SQLCODE) || ': ' ||
                             SQLERRM);
    END;
  END LOOP;
  COMMIT;
END;
/

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================

REM define support packages used in udjvmrm
@@initjvmaux

REM remove pre 8.1.7 Java system classes.  Only do this in the terminal
REM a08010n0, which in 8.1.7 is a0801060
@@udjvmrm


Rem =========================================================================
Rem BEGIN STAGE 2: upgrade from 8.1.6 to the new release
Rem =========================================================================
Rem

Rem END HERE FOR RELEASE 8.1.7
Rem For the next release we have to add a file here called
Rem @@a0801070

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.1.6 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END a0801060.sql
Rem *************************************************************************
