Rem
Rem $Header: c0800030.sql 14-oct-98.18:10:16 rshaikh Exp $
Rem
Rem c0800030.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998. All Rights Reserved.
Rem
Rem    NAME
Rem      u0800030.sql - upgrade Oracle RDBMS from 8.0.3 to the new release
Rem
Rem    DESCRIPTION
Rem
Rem	 Put any dictionary related changes here (ie-create, alter, 
Rem    	 update,...).  DO NOT put PL/SQL modules in this script.  
Rem	 If you must upgrade using PL/SQL, put the module in a0800030.sql
Rem	 as catalog.sql and catproc.sql will be run before a0800030.sql
Rem	 is invoked.
Rem
Rem	 This script is called from u0800030.sql and c0800020.sql
Rem
Rem      This script performs the upgrade in the following stages:
Rem        STAGE 1: upgrade from 8.0.3 to 8.0.4
Rem        STAGE 2: upgrade from 8.0.4 to the new release;
Rem                 call c0800040.sql to do this.
Rem
Rem    NOTES
Rem
Rem      * This script needs to be run in the new release's environment
Rem        (after installing the release to which you want to upgrade).
Rem
Rem      * You must be connected as INTERNAL to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     10/14/98 - add comments advanced replication
Rem    ncramesh    08/04/98 - change for sqlplus
Rem    rshaikh     06/17/98 - rework upgrade scripts:
Rem			      * move all non-anonymous block stmts
Rem				from u0800030.sql here.
Rem    usundara    06/03/98 - rework upgrade/downgrade/migration scripts:
Rem                           * merge from 8.0.5
Rem                             - change name cat8004.sql -> u0800030.sql
Rem                             - fix comments
Rem    ato         11/13/97 - initialize _queue_statistics for AQ
Rem    tlee        11/11/97 - run catalog and remove redundants
Rem    gpongrac    10/20/97 - re-install the upgraded dbms_backup_restore packa
Rem    nle         10/15/97 - grant execute on standard
Rem    mkrishna    10/09/97 - add catrpc
Rem    nbhatt      09/26/97 - AQ migration
Rem    jstamos     07/10/97 - bug 433036: extend repcat check constraint
Rem    liwong      06/23/97 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.0.3 to 8.0.4
Rem =========================================================================

Rem grant execute on standard package to the public

GRANT EXECUTE ON standard TO PUBLIC
/

Rem =========================================================================
Rem replication-related upgrade starts here
Rem =========================================================================

DROP INDEX system.repcat$_repprop_dblink_how
/

REM
REM ORA-000942 expected if Advanced Replication is not installed
REM THESE ARE OK IF ADVANCED REPLICATION IS NOT INSTALLED
REM
CREATE INDEX system.repcat$_repprop_dblink_how
  ON system.repcat$_repprop (dblink, how, recipient_key)
/

REM
REM ORA-000942 expected if Advanced Replication is not installed
REM THESE ARE OK IF ADVANCED REPLICATION IS NOT INSTALLED
REM
ALTER TABLE system.repcat$_generated
 DROP CONSTRAINT repcat$_generated_obj
/

REM
REM ORA-000942 expected if Advanced Replication is not installed
REM THESE ARE OK IF ADVANCED REPLICATION IS NOT INSTALLED
REM
ALTER TABLE system.repcat$_generated
 ADD CONSTRAINT repcat$_generated_obj
   CHECK (reason in (0, 1, 2, 3, 4, 5, 6, 7, 9, 10))
/
commit

Rem =========================================================================
Rem replication-related upgrade ends here
Rem =========================================================================

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.0.3 to 8.0.4
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: upgrade from 8.0.4 to the new release
Rem =========================================================================
Rem
Rem Now run c0800040.sql to upgrade from 8.0.4 to the new release.
Rem Note: catalog.sql and catproc.sql will get run when this script is run.
Rem

@@c0800040

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.0.4 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END c0800030.sql
Rem *************************************************************************

