Rem 
Rem NAME
Rem    CATSNMP.SQL
Rem  FUNCTION
Rem    Creates an SNMPAgent role to access the v$ tables
Rem  NOTES
Rem  MODIFIED
Rem     dholail    04/12/99 - Adding Events role OEM_MONITOR
Rem     cluo       07/15/96 -
Rem     dnakos     removed creation of backup script tables
Rem     dnakos     removed creation of obsolete history tables
Rem     dnakos     removed references to obsolete DBA_LOCKS
Rem
Rem  OWNER
Rem    ebosco
Rem




Rem **************************************************************************
Rem                 create the role & user account
Rem **************************************************************************

drop role SNMPAGENT;
create role SNMPAGENT;
grant select on V_$LICENSE to SNMPAGENT;
grant select on V_$VERSION to SNMPAGENT;
grant select on V_$DATABASE to SNMPAGENT;
grant select on V_$INSTANCE to SNMPAGENT;
grant select on V_$TRANSACTION to SNMPAGENT;
grant select on V_$SYSSTAT to SNMPAGENT;
grant select on V_$FILESTAT to SNMPAGENT;
grant select on V_$PARAMETER to SNMPAGENT;
grant select on V_$LIBRARYCACHE to SNMPAGENT;
grant select on V_$ROWCACHE to SNMPAGENT;
grant select on V_$SGA to SNMPAGENT;
grant select on V_$SGASTAT to SNMPAGENT;
grant select on V_$DATAFILE to SNMPAGENT;
grant select on V_$LOCK to SNMPAGENT;
grant select on V_$PROCESS to SNMPAGENT;
grant select on V_$SESSION to SNMPAGENT;
grant select on DBA_TABLESPACES to SNMPAGENT;
grant select on DBA_DATA_FILES to SNMPAGENT;
grant select on DBA_FREE_SPACE to SNMPAGENT;
grant select on DBA_SEGMENTS to SNMPAGENT;
grant analyze any to SNMPAGENT;

drop user DBSNMP cascade;
grant CONNECT, RESOURCE, SNMPAGENT, create public synonym to DBSNMP 
identified by DBSNMP;

create synonym DBSNMP.DBA_TABLESPACES for SYS.DBA_TABLESPACES;
create synonym DBSNMP.DBA_DATA_FILES for SYS.DBA_DATA_FILES;
create synonym DBSNMP.DBA_FREE_SPACE for SYS.DBA_FREE_SPACE;
create synonym DBSNMP.DBA_SEGMENTS for SYS.DBA_SEGMENTS;

Rem *************************************************************
Rem                Create OEM_Monitor role for events
Rem *************************************************************

drop role OEM_MONITOR;
create role OEM_MONITOR;
grant connect to OEM_MONITOR;
grant select_catalog_role to OEM_MONITOR;
grant analyze any to OEM_MONITOR;
grant create table to OEM_MONITOR;

