Rem
Rem $Header: dbmsobtk.sql 05-may-2000.13:44:21 rwessman Exp $
Rem
Rem dbmsobtk.sql
Rem
Rem  Copyright (c) Oracle Corporation 1997, 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      dbmsobtk.sql - rDBMS OBfuscation ToolKit
Rem
Rem    DESCRIPTION
Rem      Contains the PL/SQL interface to the obfuscation toolkit
Rem
Rem    NOTES
Rem      None.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rwessman    03/30/00 - Added Triple DES support
Rem    rwessman    01/13/00 - Changed to use a subtype for MD5 checksums to make user life easier
Rem    rwessman    12/16/99 - Added function versions of the various routines
Rem    rwessman    12/15/99 - Added a VARCHAR2 version of the MD5 routines
Rem    rwessman    12/03/99 - Added MD5 procedure
Rem    sgkrishn    03/01/99 - added DES related routines
Rem    sgkrishn    02/25/99 - Creation
Rem
REM  ***************************************
REM  THIS PACKAGE MUST BE CREATED UNDER SYS
REM  ***************************************

-- Create the trusted PL/SQL callout library.
CREATE OR REPLACE LIBRARY DBMS_OBFUSCATION_LIB TRUSTED AS STATIC;
/

CREATE OR REPLACE PACKAGE dbms_obfuscation_toolkit AS
    ------------------------------- TYPES ------------------------------------
    -- Types used to make it easier for the user to reserve the correct
    -- amount of memory for a checksum.

    SUBTYPE varchar2_checksum IS VARCHAR2(16);
    SUBTYPE raw_checksum IS RAW(16);

    ----------------------------- CONSTANTS -----------------------------------
    -- Triple DES modes
    TwoKeyMode   INTEGER := 0;
    ThreeKeyMode INTEGER := 1;

    ---------------------- FUNCTIONS AND PROCEDURES ---------------------------

    ---------------------------- DATA ENCRYPTION ------------------------------
    -- The following routines encrypt and decrypt data.
    -- There are two versions of each procedure and function: one for raw data
    -- and the other for strings.
    ---------------------------------------------------------------------------

    -- DES
    PROCEDURE DESEncrypt(input            IN     RAW,
                         key              IN     RAW,
                         encrypted_data      OUT RAW);

    FUNCTION DESEncrypt(input            IN  RAW,
                        key              IN  RAW)
        RETURN RAW;
                         
    PROCEDURE DESEncrypt(input_string    IN     VARCHAR2,
                        key_string       IN     VARCHAR2,
                        encrypted_string    OUT VARCHAR2);

    FUNCTION DESEncrypt(input_string     IN  VARCHAR2,
                        key_string       IN  VARCHAR2)
        RETURN VARCHAR2;

    PROCEDURE DESDecrypt(input            IN      RAW,
                         key              IN      RAW,
                         decrypted_data       OUT RAW);

    FUNCTION DESDecrypt(input            IN  RAW,
                        key              IN  RAW)
        RETURN RAW;

    PROCEDURE DESDecrypt(input_string     IN    VARCHAR2,
                         key_string       IN    VARCHAR2,
                         decrypted_string    OUT VARCHAR2);

    FUNCTION DESDecrypt(input_string     IN     VARCHAR2,
                        key_string       IN  VARCHAR2)
        RETURN VARCHAR2;

    -- Triple DES
    PROCEDURE DES3Encrypt(input          IN     RAW,
                          key            IN     RAW,
                          encrypted_data    OUT RAW,
                          which          IN     PLS_INTEGER
                              DEFAULT TwoKeyMode);

    FUNCTION DES3Encrypt(input IN RAW,
                         key   IN RAW,
                         which IN PLS_INTEGER DEFAULT TwoKeyMode)
        RETURN RAW;
                         
    PROCEDURE DES3Encrypt(input_string     IN     VARCHAR2,
                          key_string       IN     VARCHAR2,
                          encrypted_string    OUT VARCHAR2,
                          which            IN     PLS_INTEGER
                              DEFAULT TwoKeyMode);

    FUNCTION DES3Encrypt(input_string  IN VARCHAR2,
                         key_string    IN VARCHAR2,
                         which         IN PLS_INTEGER DEFAULT TwoKeyMode)
        RETURN VARCHAR2;

    PROCEDURE DES3Decrypt(input          IN     RAW,
                          key            IN     RAW,
                          decrypted_data    OUT RAW,
                          which          IN     PLS_INTEGER
                              DEFAULT TwoKeyMode);

    FUNCTION DES3Decrypt(input IN RAW,
                         key   IN RAW,
                         which IN PLS_INTEGER DEFAULT TwoKeyMode)
        RETURN RAW;

    PROCEDURE DES3Decrypt(input_string     IN     VARCHAR2,
                          key_string       IN     VARCHAR2,
                          decrypted_string    OUT VARCHAR2,
                          which            IN     PLS_INTEGER
                              DEFAULT TwoKeyMode);

    FUNCTION DES3Decrypt(input_string IN VARCHAR2,
                         key_string   IN VARCHAR2,
                         which        IN PLS_INTEGER DEFAULT TwoKeyMode)
        RETURN VARCHAR2;

    -------------------------------- MD5 --------------------------------------
    -- The following routines generate MD5 hashes of data.
    -- There are two versions: one for raw data and the other for strings.
    ---------------------------------------------------------------------------

    PROCEDURE MD5(input    IN  RAW,
                  checksum OUT raw_checksum);

    FUNCTION MD5(input    IN  RAW)
        RETURN raw_checksum;

    PROCEDURE MD5(input_string    IN     VARCHAR2,
                  checksum_string    OUT varchar2_checksum);

    FUNCTION MD5(input_string    IN     VARCHAR2)
        RETURN varchar2_checksum;

END dbms_obfuscation_toolkit;
/

DROP PUBLIC SYNONYM dbms_obfuscation_toolkit;
CREATE PUBLIC SYNONYM dbms_obfuscation_toolkit FOR sys.dbms_obfuscation_toolkit;
GRANT EXECUTE ON dbms_obfuscation_toolkit TO public;
/



