Rem
Rem $Header: dbmsread.sql 30-jun-98.15:40:40 ryaseen Exp $
Rem
Rem dbmsread.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998. All Rights Reserved.
Rem
Rem    NAME
Rem      dbmsread.sql - dbms Rules Engine ADmin
Rem
Rem    DESCRIPTION
Rem      creates the package specs for rules admin and rule
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nbhatt      06/23/98 - the representation in which hit rules are returne
Rem    ryaseen     06/22/98 - add rule export/import functions
Rem    esoyleme    05/26/98 - public synonym for dbms_rule
Rem    esoyleme    04/28/98 - fix security                                     
Rem    esoyleme    04/15/98 - move library creation
Rem    esoyleme    04/13/98 - add rules runtime package
Rem    nbhatt      04/03/98 - Rules Engine ADmin package
Rem    nbhatt      04/03/98 - Created
Rem


-- Create the library where 3GL callouts will reside
CREATE OR REPLACE LIBRARY dbms_rules_lib trusted as static
/


CREATE OR REPLACE PACKAGE dbms_rule_adm AS

  PROCEDURE create_rule_set(
		rule_set_name		IN varchar2,
		data_table		IN varchar2,
		rules_table_name	IN varchar2 := NULL);

  PROCEDURE drop_rule_set(
		rule_set_name		IN varchar2);

  PROCEDURE create_rule(
		rule_name		IN varchar2,
		rule_set_name		IN varchar2,
		condition		IN varchar2);

  PROCEDURE alter_rule(
		rule_name		IN varchar2,
		rule_set_name		IN varchar2,
		condition		IN varchar2);

  PROCEDURE drop_rule(
		rule_name		IN varchar2,
		rule_set_name		IN varchar2);

  
END dbms_rule_adm;
/
DROP PUBLIC SYNONYM dbms_rule_adm
/
CREATE PUBLIC SYNONYM dbms_rule_adm FOR sys.dbms_rule_adm
/
--
-- Grant execute right to EXECUTE_CATALOG_ROLE
--
GRANT EXECUTE ON sys.dbms_rule_adm TO execute_catalog_role
/

CREATE OR REPLACE PACKAGE dbms_rule_eximp AS

  PROCEDURE create_rule_set_expact(
	        rs_schema           IN varchar2,
	        rs_name  	    IN varchar2,
	        basetab_schema	    IN varchar2,
	        basetab_name	    IN varchar2,
	        rulestab_schema	    IN varchar2,
	        rulestab_name       IN varchar2);

  FUNCTION export_rule_set(
                arg_list                IN VARCHAR2)
                RETURN VARCHAR2;

  PROCEDURE import_rule_set(  
                rs_schema          IN    varchar2,    
                rs_name            IN    varchar2,    
                basetab_schema     IN    varchar2,    
                basetab_name       IN    varchar2,    
                rulestab_schema    IN    varchar2,    
                rulestab_name      IN    varchar2);

  PROCEDURE create_rule_expact(
	        rs_schema           IN varchar2,
	        rs_name  	    IN varchar2,
                basetab_schema      IN varchar2,
                basetab_name        IN varchar2,
                rulestab_schema     IN varchar2,
                rulestab_name       IN varchar2,
                rule_name           IN varchar2,
                cond                IN varchar2);
 
  FUNCTION export_rule(
                arg_list                IN VARCHAR2)
                RETURN VARCHAR2;

  PROCEDURE import_rule(  
                rs_schema          IN    varchar2,    
                rs_name            IN    varchar2,    
                rule_name          IN    varchar2,    
                cond               IN    varchar2);
 
END dbms_rule_eximp;
/
--
-- Grants for dbms_rule_eximp
--
GRANT EXECUTE ON sys.dbms_rule_eximp TO SYSTEM WITH GRANT OPTION
/
GRANT EXECUTE ON sys.dbms_rule_eximp TO imp_full_database
/
GRANT EXECUTE ON sys.dbms_rule_eximp TO exp_full_database
/
GRANT EXECUTE ON sys.dbms_rule_eximp TO execute_catalog_role
/


CREATE OR REPLACE PACKAGE dbms_rule AS
  
  TYPE rule_hits_t IS TABLE OF VARCHAR2(30) INDEX BY BINARY_INTEGER;

  PROCEDURE evaluate(
	message                 in      rowid,
	ruleset 		in	varchar2,
        rule_hits               out     rule_hits_t);

END dbms_rule;
/
GRANT EXECUTE ON sys.dbms_rule TO public
/
DROP PUBLIC SYNONYM dbms_rule
/
CREATE PUBLIC SYNONYM dbms_rule FOR sys.dbms_rule
/
