Rem
Rem $Header: e0801060.sql 09-aug-2000.17:51:23 araghava Exp $
Rem
Rem e0801060.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      e0801060.sql - downgrade Oracle RDBMS from current release to 8.1.6
Rem
Rem    DESCRIPTION
Rem      See the README file and the Oracle Migration book for details.
Rem
Rem      This script is to be used for downgrading your database from the
Rem      current release you have installed to the 8.1.6 release.  This
Rem      script provides a direct downgrade path from your current installed
Rem      release to the 8.1.6 release.
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade from the current release to 8.1.7;
Rem                 this stage is a no-op for 8.1.7 since the current release
Rem                 is 8.1.7; for the next release:
Rem                 call e0801070.sql to do this.
Rem        STAGE 2: downgrade from 8.1.7 to 8.1.6
Rem
Rem    NOTES
Rem      * This script must be run using SQL*PLUS
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem
Rem      * You must be connect as INTERNAL to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    araghava    08/09/00 - Add charsetform to partcol$, subpartcol$.
Rem    araghava    07/10/00 - Make segcol#, type# in partcol$, subpartcol$ 
Rem                           nullable.
Rem    smukkama    06/14/00 - drop buffer cache advisory views during downgrade
Rem    bnainani    06/09/00 - drop jms classes during downgrade
Rem    sbalaram    05/18/00 - Clear fire once trigger bit
Rem    mjungerm    05/17/00 - javavm up/downgrade
Rem    jdavison    05/08/00 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release to 8.1.7
Rem =========================================================================

Rem Nothing should be added here

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release to 8.1.7
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade from 8.1.7 to 8.1.6
Rem =========================================================================

Rem Begin of Drop all new views and synonyms created in 8.1.7
drop view v_$sql_shared_cursor;
drop public synonym v$sql_shared_cursor;

drop view gv_$sql_shared_cursor;
drop public synonym gv$sql_shared_cursor;

drop view v_$db_cache_advice;
drop public synonym v$db_cache_advice;

drop view gv_$db_cache_advice;
drop public synonym gv$db_cache_advice;
Rem End of Drop all new views and synonyms created in 8.1.7

Rem remove seg$ flags used for drop optimization
Rem make sure not to create any objects after this point
update seg$ set hwmincr = 0, spare1 = NULL where bitand(spare1, 512) != 0;
commit;

Rem Clear fire once trigger bit in trigger$ which is set by default in 8.1.7
Rem for all DML triggers
update trigger$ set property = bitand(property, 127);
commit;

alter table partcol$ modify (segcol# number null, type# number null);
alter table subpartcol$ modify (segcol# number null, type# number null);

update partcol$ set spare1 = NULL, segcol# = NULL, type# = NULL, 
charsetform = NULL;
commit;

update subpartcol$ set spare1 = NULL, segcol# = NULL, type# = NULL, 
charsetform = NULL;
commit;

REM Drop aqjms classes
@@rmaqjms

REM Downgrade JAVAVM from 8.1.7 to 8.1.6
@@jvme816

Rem =========================================================================
Rem END STAGE 2: downgrade from 8.1.7 to 8.1.6
Rem =========================================================================

Rem *************************************************************************
Rem END e0801060.sql
Rem *************************************************************************
