Rem
Rem $Header: initrepapi.sql 08-jun-2000.14:39:00 arrajara Exp $
Rem
Rem initrepapi.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999, 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      initrepapi.sql - load RepAPI server classes and publish 'repapi' obj
Rem
Rem    DESCRIPTION
Rem      Loading this file is required for Java RepAPI Server side.
Rem      $ORACLE_HOME/rdbms/jlib/repapi_s.jar is loaded to the database.
Rem      RServer.class and  its helper class are published in /etc  
Rem      namespace.
Rem
Rem    NOTES
Rem      Executed as part of 8i database creation/installation.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arrajara   06/08/00  - Change on addperm and mkobject signatures
Rem    arrajara   05/03/00 -  Use sns_context instead of dbms_orb_context
Rem    arrajara   10/22/99 -  Created
Rem


--### Load the RepAPI server classes into the database

call sys.dbms_java.loadjava ('-force -resolve rdbms/jlib/repapi_s.jar');
call sys.dbms_java.loadjava ('-verbose -synonym -grant public rdbms/jlib/repapi_s.jar');


--### Publish the 'repapi' CORBA object in /etc namespace

DECLARE
  rootinode   NUMBER;
  etcinode    NUMBER;
  objectinode NUMBER;
  object_type NUMBER;
  read        NUMBER;
  write       NUMBER;
  exec        NUMBER;
  objectname  VARCHAR2 (256); -- name of the object
  objectclass VARCHAR2 (256); -- class of the object
  classhelper VARCHAR2 (256); -- helper class

BEGIN
  objectname   := 'repapi';
  objectclass  := 'oracle.repapi.server.RServer';
  classhelper  := 'oracle.repapi.serverstub.RSHelper';

  rootinode    := 1;
  object_type  := 2;
  read         := 0;
  write        := 1;
  exec         := 2;

  SELECT child INTO etcinode FROM sys.sns$bindings$ 
    WHERE parent = 1 AND id = 'etc';

  objectinode :=
    sns_context.mkobject ('SYS', 'SYS', objectclass, classhelper);
  sns_context.addperm (objectinode, read, 'PUBLIC');
  sns_context.addperm (objectinode, write,'SYS');
  sns_context.addperm (objectinode, exec, 'PUBLIC');

  -- exe is in etc
  sns_context.link (etcinode, objectinode, objectname, object_type);
  COMMIT;

 EXCEPTION WHEN OTHERS THEN
  dbms_system.ksdwrt(2, 'Exception in initrepapi.sql: publish: ' ||
                            TO_CHAR(SQLCODE) || ': ' || SQLERRM);
  RAISE;
END;
/
