Rem
Rem r0800050.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998, 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      r0800050.sql - Post-catrep Advanced Replication upgrade
Rem                     from 8.0.5 to the new release
Rem
Rem    DESCRIPTION
Rem      Post-catrep Advanced Replication upgrade from 8.0.5 to
Rem      the new release.
Rem
Rem      This script upgrades Advanced replication-specific packages/views
Rem      from 8.0.5 to the new release in the following stages:
Rem        STAGE 1: post-catrep upgrade from 8.0.5 to 8.1.3
Rem        STAGE 2: post-catrep upgrade from 8.1.3 to the new release
Rem                 [currently a noop since the new release here is 8.1.3
Rem                  for the next release, call r0801030]
Rem
Rem    NOTES:
Rem
Rem      * Please read the Oracle Migration book and the README notes for
Rem        details.  This script is not meant to be run independently.
Rem
Rem      * It expects CATALOG, CATPROC and CATREP to be loaded.
Rem
Rem      * It must be run under SYS or INTERNAL.
Rem
Rem      * It performs post-catrep upgrade cleanup
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     02/12/99 - change r0801030.sql comment
Rem    usundara    06/03/98 - rework upgrade/downgrade/migration scripts:
Rem                           * copied contents from the old cat8100r.sql
Rem                           * added commented out call to r0801030.sql
Rem    usundara    05/28/98 - Created
Rem

Rem ===========================================================================
Rem BEGIN STAGE 1: post-catrep upgrade from 8.0.5 to 8.1.3
Rem ===========================================================================

Rem Populate the replication catalog with TOP flavor information, drop
Rem any existing $RP/$RL/$RR/$RV, and recreate $RP/$RL.
Rem
Rem This was pulled out of cat8100r.sql.  Here's the old modification history.
Rem    jstamos     04/01/98 - flavor support                                   
Rem    liwong      11/21/97 - Created
Rem

-------------------------------------------------------------------------
-- populate TOP flavor
-------------------------------------------------------------------------
DECLARE
  CURSOR groups IS
    SELECT sname
      FROM system.repcat$_repcat;
  CURSOR tabs IS
    SELECT sname, oname, type
      FROM system.repcat$_repobject
      WHERE type IN (-1, 2);
col_count NUMBER;
dummy NUMBER;
mas_sname VARCHAR2(30);
mas_oname VARCHAR2(30);
BEGIN
  FOR rg IN groups LOOP
    BEGIN
      dummy := dbms_repcat_utl.ensure_local_flavor(rg.sname);
    EXCEPTION WHEN OTHERS THEN
      DBMS_SYSTEM.KSDWRT(2, '  Replication migration: ' ||
        'can not create top flavor for "' || rg.sname || '".');
    END;
  END LOOP;
  FOR rt IN tabs LOOP
    BEGIN
      dbms_repcat_fla_utl.create_repcolumn(rt.sname, rt.oname, rt.type);
      SELECT COUNT(*) INTO col_count
        FROM system.repcat$_repcolumn rc
        WHERE rc.sname = rt.sname
          AND rc.oname = rt.oname
          AND rc.type = rt.type;
      IF rt.type = -1 THEN
        SELECT master_owner, master
          INTO mas_sname, mas_oname
          FROM sys.dba_snapshots
          WHERE owner = rt.sname AND name = rt.oname;
      ELSE
        mas_sname := rt.sname;
        mas_oname := rt.oname;
      END IF;
      UPDATE system.repcat$_flavor_objects fo
        SET columns_present = 
            utl_raw.copies( HEXTORAW('FF'), CEIL(col_count/8))
        WHERE columns_present IS NULL
          AND fo.sname = mas_sname
          AND fo.oname = mas_oname
          AND fo.type = 2;
    EXCEPTION WHEN OTHERS THEN
      DBMS_SYSTEM.KSDWRT(2, '  Replication migration: ' ||
        'can not create repcolumn for "' || rt.sname || '"."' ||
                                            rt.oname || '"');
    END;
  END LOOP;
END;
/
COMMIT
/

-------------------------------------------------------------------------
-- drop $RR/$RV
-------------------------------------------------------------------------
BEGIN
  dbms_repcat_mig_internal.drop_rrrv;
END;
/

-------------------------------------------------------------------------
--- create and replace $RP/$RL
-------------------------------------------------------------------------
BEGIN
  dbms_repcat_mig_internal.drop_recreate_rlrp;
END;
/

Rem ===========================================================================
Rem END STAGE 1: post-catrep upgrade from 8.0.5 to 8.1.3
Rem ===========================================================================

Rem ===========================================================================
Rem BEGIN STAGE 2: post-catrep upgrade from 8.1.3 to the new release
Rem ===========================================================================

Rem This is commented out for now.  But will be need to be uncommented
Rem for the next release
Rem
Rem @@r08xxxxx.sql

Rem ===========================================================================
Rem END STAGE 2: post-catrep upgrade from 8.1.3 to the new release
Rem ===========================================================================

Rem *************************************************************************
Rem END r0800050.sql
Rem *************************************************************************
