Rem
Rem utlirp.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998. All Rights Reserved.
Rem
Rem   NAME
Rem     utlirp.sql - UTiLity script to Invalidate & Recompile Pl/sql modules
Rem
Rem   DESCRIPTION
Rem
Rem     This script can be used to invalidate and then recompile all pl/sql
Rem     modules (procedures, functions, packages, types, triggers, views)
Rem     in a database.
Rem
Rem     This script in turn invokes utlip.sql (to invalidate all pl/sql modules
Rem     and recompile package STANDARD and DBMS_STANDARD) and utlrp.sql (to
Rem     recompile all invalid pl/sql modules).
Rem
Rem     This script must be run when it is necessary to regenerate the
Rem     compiled code because an action was taken that caused the old code's
Rem     format to be inconsistent with what it's supposed to be, e.g., when
Rem     migrating a 32 bit database to a 64 bit database or vice-versa.
Rem
Rem     STEPS:
Rem
Rem     1.  call utlip.sql to do the following:
Rem
Rem         a)  Invalidate all stored PL/SQL units (procedures, functions,
Rem             packages, types, triggers, views).
Rem         b)  Reload PL/SQL package STANDARD and package DBMS_STANDARD.
Rem     
Rem         Step 1 (especially step 1b) must be performed before step 2
Rem         is performed.
Rem
Rem     2.  call utlrp.sql to validate all PL/SQL modules.
Rem
Rem         Although invalid PL/SQL modules get automatically recompiled on
Rem         use, it is useful to run this script ahead of time (e.g. as one of
Rem         the last steps in your migration), since this will either
Rem         eliminate or minimize subsequent latencies caused due to on-demand
Rem         automatic recompilation at runtime.
Rem
Rem   NOTES
Rem
Rem     * Until we support ALTER LIBRARY <library> COMPILE, this script
Rem       CANNOT be used if there's a change in the internal diana structures
Rem       since it does not delete the compiled information for PL/SQL
Rem       LIBRARY modules.
Rem
Rem      * Must be connected as INTERNAL to run this.
Rem
Rem      * The scripts expects the following files to be available in the
Rem        current directory:
Rem          standard.sql
Rem          dbmsstdx.sql
Rem 
Rem      * There should be no other DDL on the database while running
Rem        the script. Not following this recommendation may lead to
Rem        deadlocks.
Rem
Rem   MODIFIED   (MM/DD/YY)
Rem    ncramesh    08/04/98 - change for sqlplus
Rem    usundara    06/03/98 - merge from 8.0.5:
Rem                           * change name utlrpls.sql --> utlirp.sql;
Rem                           * split out utlip.sql and utlrp.sql and call them
Rem    kmuthukk    04/07/98 - merge from 8.0.5
Rem    kmuthukk    03/09/98 - script to recompile pl/sql modules
Rem    kmuthukk    03/09/98 - Created
Rem
Rem    === (old history; merged from cat8004s.sql) ===
Rem     MODIFIED   (MM/DD/YY)
Rem     gviswana    02/25/98 - 632376: Do not remove idl_ rows for libraries
Rem     kmuthukk    02/05/98 - bug621356 (truncate idl tables)
Rem     kmuthukk    01/09/98 - merge from kmuthukk_plsql_32_64_upgrade
Rem     mramache    12/30/97 - code to revalidate PL/SQL objs.
Rem     kmuthukk    12/30/97 - migration script from 8.0.4 to 8.0.4S
Rem     kmuthukk    12/30/97 - Created
Rem    === (end of old history) ===
Rem

Rem ===========================================================================
Rem BEGIN utlirp.sql
Rem ===========================================================================

Rem invalidate all pl/sql modules and recompile standard and dbms_standard
Rem
@@utlip

Rem recompile all invalid pl/sql modules
Rem
@@utlrp

Rem ===========================================================================
Rem END utlirp.sql
Rem ===========================================================================
