/* $Header: aqjmsdemo03.java 16-mar-00.13:05:15 rbhyrava Exp $ */

/* Copyright (c) Oracle Corporation 2000. All Rights Reserved. */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rbhyrava    03/16/00 - AQ jms demos
    rbhyrava    03/15/00 - AQ JMS demo - Message Listener Demo 
    rbhyrava    03/15/00 - Creation
 */

/**
 *  @version $Header: aqjmsdemo03.java 16-mar-00.13:05:15 rbhyrava Exp $
 *  @author  rbhyrava
 *  @since   release specific (what release of product did this appear in)
 */

/* Message Listener */
/***
 * This is a sample java file which uses Oracle JMS - Java Messaging Service 
 * API where Subscribers can Recieve messages asynchronously using 
 * MessageListener
 * Subscribers receiveing the messages asynchronously using Message Listener
 * aqjmsdemo02 - enqueues the messages to the queue 
 * aqjmsdemo03 - setup Message Listener and dequeue the messages 
 * This demo does the following:
 * -- Get the Queue already created in aqjmsdemo03.java 
 * -- Create Receiver for the Queue 
 * -- Setup the message listener for Queue Receiver 
 * -- Start the connection 
 * -- Recieve the messages 
 * -- Stop the connection 
 *
 * The following instructions describe how to compile and execute 
 * this sample on the client machine. 
 *
 * System requirements:
 * ====================
 *  1) Oracle 8.1.6 database or higher 
 *  2) The client machine should have JDK 1.1.x or JDK1.2 or higher installed
 *  3) The following jar/zip files should be in the CLASSPATH on the client 
 *     machine. 
 *     For JDK1.2.x 
 *        classes12.zip 
 *        aqapi.jar
 *        jmscommon.jar
 *     For JDK1.1.x 
 *        classes111.zip 
 *        aqapi11.jar
 *        jmscommon.jar
 *  Set up CLASSPATH, PATH, LD_LIBRARY_PATH based on JDK version and platform.
 * Compilation and Running:
 *  ========================
 *  4) If you already have the jars in step 3) in classpath 
 *      javac aqjmsdemo03.java  MesgListener.java 
 *
 *  5) java aqjmsdemo03  <SID> <HOST> <PORT> <DRIVER> 
 *     Example usage: 
 *       java aqjmsdemo03 orcl82 dlsun666 1521 thin 
 *
 ***/
/* import useful packages */

/* import useful packages */
import oracle.AQ.*;
import oracle.jms.*;
import javax.jms.*;
import java.lang.*;

public class aqjmsdemo03
{

  public static void main (String args [])
       throws java.sql.SQLException, ClassNotFoundException, JMSException
  {
     QueueSession  qsess = null;
      try
      {
        if (args.length < 4 )
         System.out.println("Usage:java filename [SID] [HOST] [PORT] [DRIVER]");
        else {
          qsess = createSession(args);
          demoMessageListener(qsess);
          qsess.close() ;
          System.out.println("End of Demo") ;
	  System.exit(0);
        }
      }
      catch (Exception ex)
      {
         System.out.println("Exception-1: " + ex);
         ex.printStackTrace();
      }
  }

   public static QueueSession createSession(String args[]) throws Exception
   {
      QueueSession  qsess = null;
      QueueConnectionFactory qcfact;
      QueueConnection qconn;
      try 
      {
        //args passed are sid,host,port,driver 
         
         qcfact = AQjmsFactory.getQueueConnectionFactory(
                      args[1], args[0], Integer.parseInt(args[2]), args[3]);

         qconn = qcfact.createQueueConnection( "jmsuser","jmsuser");

         /* Create a Queue Session */
         qsess = 
             qconn.createQueueSession(true, Session.CLIENT_ACKNOWLEDGE);

         qconn.start() ;
         System.out.println("Successfully created QueueSession");  
      }
      catch (Exception ex)
      {
         System.out.println("Error in createSession : " + ex); 
         throw ex;
      }  
      return qsess;
   }

  public static void demoMessageListener(QueueSession qsess) throws Exception
  {
    Queue queue;
    QueueReceiver qrecv ; 
    MessageListener mLis ;

    try
    {
      System.out.println("Get the Queue") ;
      /* Get the Queue */
      /* Queue JMSMAPQ is created in aqjmsdemo02 */
      queue = ((AQjmsSession)qsess).getQueue("JMSUSER", "JMSMAPQ") ;

      System.out.println("Create Receiver...") ;

      /* Create a queue receiever */
      qrecv = qsess.createReceiver(queue, "JMSCorrelationID='BLUE'") ;
      
      /* Setup the message listener */
      System.out.println("Set Message Listener...") ;
      mLis = new MesgListener(qsess);
      qrecv.setMessageListener (mLis) ;

      System.out.println("Sleep...") ;
      try {
         Thread.sleep(5000) ;
      } catch (InterruptedException e) {} ;

      System.out.println("Successfully dequeued with MessageListener") ;

     } catch (JMSException e) {
      System.out.println("Error in demoMessageListener: " +e ) ;
      throw e;
     }
  } 
}
