set feedback off
create or replace procedure hiqmanage (
    is_retry     in boolean,
    start_chg_no in number,
    equal_chg_no in number,
    end_chg_no in number,
    suppliernode in asr_chg_log.server%type) as 

begin
    dbms_reputil.replication_off;
    if (is_retry) then 
        if equal_chg_no != -1 then 
            update asr_chg_log
            set retry_cnt = 10 
            where chg_no = equal_chg_no and server = suppliernode;
        elsif (start_chg_no != -1) AND (end_chg_no != -1) then
            update asr_chg_log
            set retry_cnt = 10
            where chg_no <= end_chg_no and chg_no >= start_chg_no and server = suppliernode;
        elsif (start_chg_no != -1) AND (end_chg_no = -1) then 
            update asr_chg_log 
            set retry_cnt = 10
            where chg_no >= start_chg_no and server = suppliernode;
        elsif (end_chg_no != -1) AND (start_chg_no = -1) then
            update asr_chg_log 
            set retry_cnt = 10
            where chg_no <= end_chg_no and server = suppliernode;
        elsif (start_chg_no = -1) AND (end_chg_no = -1) then
            update asr_chg_log
            set retry_cnt = 10
            where server = suppliernode;
        end if;
    else
        if equal_chg_no != -1 then
            update asr_chg_log
            set retry_cnt = -2
            where chg_no = equal_chg_no and server = suppliernode;
        elsif (start_chg_no != -1) AND (end_chg_no != -1) then
            update asr_chg_log 
            set retry_cnt = -2
            where chg_no <= end_chg_no and chg_no >= start_chg_no and server = suppliernode;
        elsif (start_chg_no != -1) AND (end_chg_no = -1) then 
            update asr_chg_log 
            set retry_cnt = -2
            where chg_no >= start_chg_no and server = suppliernode;
        elsif (end_chg_no != -1) AND (start_chg_no = -1) then
            update asr_chg_log 
            set retry_cnt = -2
            where chg_no <= end_chg_no and server = suppliernode;
        elsif (start_chg_no = -1) AND (end_chg_no = -1) then
            update asr_chg_log
            set retry_cnt = -2
            where server = suppliernode;
        end if;
    end if;
    dbms_reputil.replication_on;
end;
/

exec hiqmanage (&1, &2, &3, &4, '&5');
drop procedure hiqmanage;
commit;
exit
