set timing on
prompt 'Creating index on Attribute Store'
create index EI_attrStore on DS_AttrStore (entryid)
 tablespace OLTS_IND_ATTRSTORE 
 storage (INITIAL 8M NEXT 4M PCTINCREASE 0)
 parallel 2 UNRECOVERABLE;

prompt 'Creating indexes on CT_DN'
create unique index EP_dn on CT_dn (entryid, parentdn)
 tablespace OLTS_IND_CT_DN
 storage (INITIAL 4M NEXT 2M PCTINCREASE 0)
 parallel 2 UNRECOVERABLE;

create unique index RP_dn on CT_dn (rdn, parentdn)
 tablespace OLTS_IND_CT_DN
 storage (INITIAL 4M NEXT 2M PCTINCREASE 0)
 parallel 2 UNRECOVERABLE;

create index PN_dn on CT_dn (parentdn)
 tablespace OLTS_IND_CT_DN
 storage (INITIAL 4M NEXT 2M PCTINCREASE 0)
 parallel 2 UNRECOVERABLE;

Rem
Rem Rebuild ONLDAP schema indexes following bulk data load
Rem

CREATE OR REPLACE
PROCEDURE createCatalogIndexes(attrName IN varchar2)
AS
    catalogName     VARCHAR2(32);	
    attrNameLower   VARCHAR2(32);
    sqlCommand      VARCHAR2(2048);
    sqlCursor       INTEGER;
    rows_processed  INTEGER;
BEGIN
    sqlCursor := dbms_sql.open_cursor;	

    attrNameLower := lower(attrName);
    catalogName := 'CT_' || attrNameLower;

    sqlCommand := 'CREATE UNIQUE INDEX EV_' || attrNameLower || ' ON ' ||
                  catalogName || '(entryid, attrvalue) ' ||
                  'tablespace olts_ind_ct_store ' ||
                  'storage (initial 1M next 1M pctincrease 0) ' ||
                  'parallel 2 unrecoverable';
    /* dstest.Report( 'Executing SQL: ' || sqlCommand ); */
    dbms_sql.parse(sqlCursor, sqlCommand, dbms_sql.v7);
    rows_processed := dbms_sql.execute(sqlCursor);

    IF  attrNameLower = 'orclguid' THEN
      sqlCommand := 'CREATE UNIQUE INDEX VA_' || attrNameLower || ' ON ' || 
                    catalogName || '(attrvalue)  ' ||
                    'tablespace olts_ind_ct_store ' ||
                    'storage (initial 1M next 1M pctincrease 0) ' ||
                    'parallel 2 unrecoverable';
    ELSE
      sqlCommand := 'CREATE INDEX VA_' || attrNameLower || ' ON ' || 
                    catalogName || '(attrvalue)  ' ||
                    'tablespace olts_ind_ct_store ' ||
                    'storage (initial 1M next 1M pctincrease 0) ' ||
                    'parallel 2 unrecoverable';
    END IF;
    /* dstest.Report( 'Executing SQL: ' || sqlCommand ); */
    dbms_sql.parse(sqlCursor, sqlCommand, dbms_sql.v7);
    rows_processed := dbms_sql.execute(sqlCursor);

    dbms_sql.close_cursor(sqlCursor);	
END;
/
