--    SET UP OF THE MASTER DEFINITION SITE --  
--    PLEASE READ THIS SCRIPT COMPLETELY.  
--  
--    This script is used as the initial setup for the MASTER DEFINITION SITE  
--    Be aware because it is parameterized, it must be run in sqlplus  
--    It will prompt for the following parameter:  
--    SPWD sys's password  
--    LOCAL NAME Master Definition database name fully qualified  
--        ex:  db_name.db_domain  
--  
--    THIS SCRIPT ASSUMES THAT THE SCHEMA OWNER ALREADY EXISTS.  
--  
--    WARNING:  THIS SCRIPT CREATES REPADMIN REPSYS USERS AND ASSUMES THAT  
--              THE olts_default AND olts_temp TABLESPACES EXISTS.  
  
spool LOGS/ldapsetms.log  
--set echo off  
--prompt This is the Master Definition Site script.  
--1--accept SPWD         prompt 'Enter SYSTEM password: ' hide  
--2--accept LOCAL_NAME  prompt 'Enter global name of Master Definition Site: Example: DB_NAME.DOMAIN.COM  '
--set echo on    
connect system/&&1@&&2  
ALTER DATABASE RENAME GLOBAL_NAME TO &2 ;  
drop user REPADMIN cascade;  
  
create user REPADMIN identified by REPADMIN
default tablespace OLTS_DEFAULT temporary tablespace OLTS_TEMP;  
  
execute dbms_repcat_admin.grant_admin_any_schema('REPADMIN');  

grant comment any table to repadmin;
grant lock any table to repadmin;
grant create public database link to REPADMIN;
grant drop public database link to REPADMIN;

  
execute dbms_defer_sys.register_propagator('REPADMIN');  
execute  dbms_repcat_admin.register_user_repgroup('REPADMIN', 'RECEIVER', list_of_gnames=>NULL);

grant connect, resource to ods identified by ods;  
grant execute any procedure to ods;  
grant alter session to ODS;
grant create cluster to ODS;
grant create database link to ODS;
grant create sequence to ODS;
grant create session to ODS;
grant create synonym to ODS;
grant create table to ODS;
grant create view to ODS;
grant create procedure to ODS;
grant create trigger to ODS;
grant unlimited tablespace to ODS;
grant create type to  ODS;
grant create any snapshot to ODS;
grant alter any snapshot to ODS;
connect REPADMIN/REPADMIN@&2;  

@ldaprmpurge.sql

Rem
Rem Scheduling purge at master def site 
Rem 

begin
   dbms_defer_sys.schedule_purge(
    next_date => sysdate,
    interval => '/*10:Mins*/ sysdate + 10/(60*24)',
    delay_seconds => 0,
    rollback_segment => '');
end;
/


Rem SCRIPT NAME:	DrMstr.sql
Rem
Rem  This script drops the master replicating group and should run at 
Rem  MASTER DEFINITION SITE ONLY. 

BEGIN
   DBMS_REPCAT.DROP_MASTER_REPGROUP(	gname		=> 'LDAP_REP' );
END;
/

Rem SCRIPT NAME:	CrMstr.sql
Rem
Rem  This script creates the master replicating group and should run at 
Rem  MASTER DEFINITION SITE ONLY. 

BEGIN
   DBMS_REPCAT.CREATE_MASTER_REPGROUP(	gname		=> 'LDAP_REP' );
END;
/

--@ldapchgj

set time on                                                                   
prompt Gen REPOBJECT - ASR_CHG_LOG                                            
BEGIN DBMS_REPCAT.CREATE_MASTER_REPOBJECT(                                    
 sname	=> 'ODS',                                                            
 oname	=> 'ASR_CHG_LOG',                                                      
 type	=> 'table',                                                             
 use_existing_object => TRUE,                                                 
 copy_rows => FALSE,                                                          
 gname	=> 'LDAP_REP');                                                        
END;                                                                          
/                                                                             
prompt SetCol REPOBJECT - ASR_CHG_LOG                                         
BEGIN DBMS_REPCAT.SET_COLUMNS(sname => 'ODS',                               
 oname => 'ASR_CHG_LOG',                                                      
 column_list =>'CHG_NO'                                                       
||',SERVER'                                                                   
||',CHG_SEQ'                                                                   
); END;                                                                       
/                                                                             
prompt Gen RepSup - ASR_CHG_LOG                                               
BEGIN DBMS_REPCAT.GENERATE_REPLICATION_SUPPORT(                               
 sname => 'ODS',                                                            
 oname => 'ASR_CHG_LOG',                                                      
 type => 'table');
 END;                                                                         
/                                                                             
prompt Gen REPOBJECT - ODS_CHG_STAT                                           
BEGIN DBMS_REPCAT.CREATE_MASTER_REPOBJECT(                                    
 sname	=> 'ODS',                                                            
 oname	=> 'ODS_CHG_STAT',                                                     
 type	=> 'table',                                                             
 use_existing_object => TRUE,                                                 
 copy_rows => FALSE,                                                          
 gname	=> 'LDAP_REP');                                                        
END;                                                                          
/                                                                             
prompt SetCol REPOBJECT - ODS_CHG_STAT                                        
BEGIN DBMS_REPCAT.SET_COLUMNS(sname => 'ODS',                               
 oname => 'ODS_CHG_STAT',                                                     
 column_list =>'SUPPLIER'                                                     
||',CONSUMER'                                                                 
); END;                                                                       
/                                                                             
prompt Gen RepSup - REP_CHG_STAT                                              
BEGIN DBMS_REPCAT.GENERATE_REPLICATION_SUPPORT(                               
 sname => 'ODS',                                                            
 oname => 'ODS_CHG_STAT',                                                     
 type => 'table');
 END;                                                                         
/                                                                             
spool off   
exit;

