--    SET UP OF THE REMOTE MASTER SITE  
--  
--    PLEASE READ THIS SCRIPT COMPLETELY.  
--  
--   This script is used as the initial setup for the REMOTE MASTER SITE  
--   Be aware because it is parameterized, it must be ran in sqlplus  
--   It will prompt for the following parameter:  
--    SPWD sys's password  
--    LOCAL NAME Master Definition database name fully qualified  
--        ex:  db_name.db_domain  
--    REMOTE NAME Remote Site database name fully qualified  
--        ex:  db_name.db_domain  
--  
-- THIS SCRIPT ASSUMES THAT THE SCHEMA OWNER (ods) ALREADY EXISTS.  
--  
--    WARNING:  THIS SCRIPT CREATES USERS REPADMIN REPSYS AND ASSUMES THAT  
--              THE olts_default AND olts_temp TABLESPACES EXIST.  
  
--  The log files for this script come in two parts: LOGS/ldapsetr1.log and
--						     LOGS/ldapsetr2.log
--
--  Please review both of them to ensure correctness after the run
  
--set echo off  
prompt This is the Remote-Site script.  
--1--accept SPWD         prompt 'Enter SYSTEM password at Remote Master Site: ' hide  
--2--accept LOCAL_NAME   prompt 'Enter global name of Remote Master Site: Example: DB_NAME.ORACLE.COM ' 
--3--accept SPWDM         prompt 'Enter SYSTEM password at Master Def site: ' hide  
--4--ccept REMOTE_NAME  prompt 'Enter global name of Master Definition Site: Example: DB_NAME.DOMAIN.COM ' 
set echo on  
  
connect system/&&1@&&2  
---spool LOGS/ldapset1.log
prompt 'Set remote master operation being performed for  &2 '
  
ALTER DATABASE RENAME GLOBAL_NAME TO &2;  
  
drop user REPADMIN cascade;  
  
drop public database link &&3 ;  
drop database link &3 ;  
create public database link &3 using '&3';  
create user repadmin identified by repadmin 
default tablespace OLTS_DEFAULT temporary tablespace OLTS_TEMP;  
  
execute dbms_repcat_admin.grant_admin_any_schema('REPADMIN');  
  
grant comment any table to REPADMIN;
grant create public database link to REPADMIN;
grant drop public database link to REPADMIN;
grant lock any table to REPADMIN;
execute dbms_defer_sys.register_propagator('REPADMIN');
execute  dbms_repcat_admin.register_user_repgroup('REPADMIN', 'RECEIVER', list_of_gnames=>NULL);

connect REPADMIN/REPADMIN@&2  
create database link &3  
connect to REPADMIN identified by REPADMIN;  
  
@ldaprmpurge.sql

Rem
Rem Scheduling purge at LOCAL site 
Rem

begin
   dbms_defer_sys.schedule_purge(
    next_date => sysdate,
    interval => '/*10:Mins*/ sysdate + 10/(60*24)',
    delay_seconds => 0,
    rollback_segment => '');
end;
/
connect system/&1@&2  

Rem
Rem grant privileges to ods
Rem

grant connect, resource to ods identified by ods;  
grant alter session to ODS;


grant create cluster to ODS;


grant create database link to ODS;


grant create sequence to ODS;


grant create session to ODS;


grant create synonym to ODS;


grant create table to ODS;


grant create view to ODS;


grant create procedure to ODS;


grant create trigger to ODS;


grant unlimited tablespace to ODS;


grant create type to  ODS;


grant create any snapshot to ODS;


grant alter any snapshot to ODS;

connect ods/ods@&2  
  
drop   database link &3 ;  
create database link &3 connect to ods identified by  
ods;  

connect system/&&4@&3
drop public database link &2;
drop database link &2;
create public database link &2 using '&2';

connect REPADMIN/REPADMIN@&3
drop database link &2;
create database link &2
 connect to REPADMIN identified by REPADMIN;

connect ods/ods@&3
drop   database link &2;
create database link &2 connect to ods identified by ods;

@ldapdbls.sql
--spool LOGS/ldapset2.log

connect REPADMIN/REPADMIN@&2


Rem SCRIPT NAME:        DropMGrp.sql
Rem
Rem  This script Drops the master replicating group 


BEGIN
	DBMS_REPCAT.DROP_MASTER_REPGROUP(  gname           => 'LDAP_REP');
END;
/

connect REPADMIN/REPADMIN@&3

Rem SCRIPT NAME:	AddMstr.sql
Rem
Rem  This script adds an additional the master site to the 
Rem  replicating group and should run at 
Rem  MASTER DEFINITION SITE ONLY. 
Rem  Parameters: 1. Fully qualified sqlnet name of the remote site.
Rem              2. TRUE for initial ODS setup, FALSE for new ODS
Rem              3. FALSE for initial ODS setup, TRUE for new ODS

BEGIN
   DBMS_REPCAT.ADD_MASTER_DATABASE(
	gname		=> 'LDAP_REP',
	master		=> '&2',
	use_existing_objects => TRUE,
	copy_rows	=> FALSE,
	propagation_mode => 'asynchronous'
);
END;
/
connect repadmin/repadmin@&2
--@ldapchgj

Rem DeferAdm.sql
Rem
Rem Forces admin jobs that have been submitted to be run
Rem

BEGIN
   DBMS_REPCAT.DO_DEFERRED_REPCAT_ADMIN('ldap_rep',FALSE);
END;
/
--spool off  
prompt 'Remote master operation being performed for  &2 '
exit;
