LDAP_DIR=${ORACLE_HOME}/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
TMPDIR=${LDAP_DIR}/load
bo=``
no=``

RESTORE=0
REPORT=0
VERSION=10
PSWD="A"
usage() {
  cat << BACKUP_USAGE
usage : configbkp.sh [-connect <connect descriptor] [-version <[01234]>] [-report] -base <DN>
	-connect   specifies the Net8 connect descriptor to use to connect to
		   the database
	-version   specifies the VERSION to be restored. 
		   4 being the most recent backup or the last backup taken.
		   0 being the oldest backup.
	-report    Creates a report of the specified version of entry
	-base      specifies the Distinguish Name which is to be backed up 
		   or restored

	IF NO <DN> is specified then backup/restore of ROOT DN will be taken
	TO resotore an entry it's mandatory to specify the Version. 
BACKUP_USAGE
exit 2
}
usage_nocon() {
 cat << BACKUP_USAGE_NOCON
Unable to detect database using connect descriptor ${LDAP_CONNECT}. Check
Net8 client connect descriptor configuration settings.
BACKUP_USAGE_NOCON
}

createtblfile() {
if [ ${RESTORE} -eq 0 ] ; then
      echo " set feedback off
             EXEC entryBackupRecov.entrybackup('${DN}');
             exit; " > ${TMPDIR}/tempbkp.sql
else
      echo " set feedback off
             set serveroutput on size 999999
             spool ${LDAP_LOG}/config.dat
             EXEC entryBackupRecov.entryRecovery('${DN}', '${VERSION}','${REPORT}');
             spool off
             exit; " > ${TMPDIR}/tempbkp.sql

fi

}

if [ $# -eq 0 ] ; then
  usage 
fi
while [ $# -gt 0 ] ; do
	case $1 in
		-connect) LDAP_CONNECT=$2 ;
			if [ -z "${LDAP_CONNECT}" ] ; then
			 	usage ;
			fi
			shift ;;
		-version) case $2 in
			0) VERSION=4;;
			1) VERSION=3;;
			2) VERSION=2;;
			3) VERSION=1;;
			4) VERSION=0;;
		     esac
			 RESTORE=1; 
			 shift ;;
		-report) REPORT=1
			 RESTORE=1 ;;
		-base) DN=$2 
                      shift ;;
		-w) PSWD=$2;
		    shift;;
		-*) usage ;;
	esac
	shift
done	

if [ ${RESTORE} = 1 ] && ( [ ${VERSION} -lt 0 ] || [ ${VERSION} -gt 4 ] ) ; then
	  echo " Version specified is not Valid "
	  echo " Version should be either 0, 1,2 ,3 or 4 "
	  usage
fi

if [ -z $ORACLE_HOME ] 
then
  echo "ORACLE_HOME not set "
  exit 1
fi


tnsping ${LDAP_CONNECT} > ${TMPDIR}/null 2>&1
if [ $? != 0 ] ; then
  usage_nocon
  usage
fi

# verify that no LDAP servers are running...
PROCESS=`${LDAP_BIN}/ldapcheck oidldapd`
case $PROCESS in
        *'oidldapd is Alive'*)
                        echo "The Following Processes are still running:"
                        echo "${PROCESS}"
                        echo
                        echo "Shutdown these Processes and start again"
                        exit 1
                        ;;
        *)              ;;
esac

# verify that no Replication servers are running...
PROCESS=`${LDAP_BIN}/ldapcheck oidrepld`
case $PROCESS in
        *'oidrepld is Alive'*)
                        echo "The Following Processes are still running:"
                        echo "${PROCESS}"
                        echo
                        echo "Shutdown these Processes and start again"
                        exit 1
                        ;;
        *)              ;;
esac

# verify that no Guardian servers are running...
PROCESS=`${LDAP_BIN}/ldapcheck oidmon`
case $PROCESS in
        *'oidmon is Alive'*)
                        echo "The Following Processes are still running:"
                        echo "${PROCESS}"
                        echo
                        echo "Shutdown these Processes and start again"
                        exit 1
                        ;;
        *)              ;;
esac

####THis is the Security Implementation######
if [ ${PSWD} = "A" ] ; then
   echo " "
   echo "${bo}This tool can only be executed if you know database user password for OiD${no}"  
   echo " "
   printf "Enter OiD password ::" 
   stty -echo; read PSWD ; stty echo ; echo
   #clear
fi
echo " set feedback off
   connect ods/${PSWD}@${LDAP_CONNECT} ;
   exit; " > ${TMPDIR}/seccheck.sql
### check if the password provided is correct
${ORACLE_HOME}/bin/sqlplus  odscommon/odscommon@${LDAP_CONNECT} @${TMPDIR}/seccheck.sql  > ${LDAP_LOG}/catchecK.lst
err=`grep -c ERROR ${LDAP_LOG}/catchecK.lst`
rm -f ${LDAP_LOG}/seccheck.lst ${TMPDIR}/seccheck.sql > ${TMPDIR}/null
if [ ${err} != 0 ] ; then
  echo " Password for OiD user is WRONG.."
  echo " Cannot execute this tool ..."
  exit
fi

#### seccheck complete

createtblfile
#Embedded sql Script to call the BACKUP/RESTORE procedures.
${ORACLE_HOME}/bin/sqlplus -s ods/ods@${LDAP_CONNECT} @${TMPDIR}/tempbkp.sql > ${LDAP_LOG}/configbkp.log  
if [ $? != 0 ] ; then
  echo
  echo Problems encoutered while peroforming Configbkp.. 
  echo check  ${LDAP_LOG}/configbkp.log
  echo
fi
if [ -s ${LDAP_LOG}/configbkp.log ] ; then
  echo
  if [ ${REPORT} = 1 ] ; then
      rm -f ${LDAP_LOG}/configbkp.log > ${TMPDIR}/null
  else
  echo Problems encoutered while peroforming Configbkp..
  echo check  ${LDAP_LOG}/configbkp.log
  fi
  echo
fi

rm -f ${TMPDIR}/tempbkp.sql > ${TMPDIR}/null

