
if [ -z "$ORACLE_HOME" ]
then
        echo "ORACLE_HOME not set"
        exit 1
fi

ODS_DIR=${ORACLE_HOME}/ldap
ODS_ADMIN=${ODS_DIR}/admin
ODS_BIN=${ODS_DIR}/bin
ODS_LOG=${ODS_DIR}/log
ODS_LOAD=${ODS_DIR}/load
TMPDIR=${TMPDIR}/load

#
# Required Attribute Catalogs / Attribute Store
#
echo Loading Attribute Store..
${ORACLE_HOME}/bin/sqlldr userid=ods/ods@${LDAP_CONNECT} control=${ODS_LOAD}/attr_store.ctl log=${ODS_LOG}/attr_store.log bad=${ODS_LOG}/attr_store.bad errors=10000000 direct=true 2>&1 >${TMPDIR}/null

echo Loading Distinguished Name Catalog..
${ORACLE_HOME}/bin/sqlldr userid=ods/ods@${LDAP_CONNECT} control=${ODS_LOAD}/dn.ctl log=${ODS_LOG}/dn.log bad=${ODS_LOG}/dn.bad errors=10000000 direct=true 2>&1 >${TMPDIR}/null

echo Loading Common Name Catalog..
${ORACLE_HOME}/bin/sqlldr userid=ods/ods@${LDAP_CONNECT} control=${ODS_LOAD}/cn.ctl log=${ODS_LOG}/cn.log bad=${ODS_LOG}/cn.bad errors=10000000 direct=true 2>&1 >${TMPDIR}/null

echo Loading Object Class Catalog..
${ORACLE_HOME}/bin/sqlldr userid=ods/ods@${LDAP_CONNECT} control=${ODS_LOAD}/objectclass.ctl log=${ODS_LOG}/objectclass.log bad=${ODS_LOG}/objectclass.bad errors=10000000 direct=true 2>&1 >${TMPDIR}/null

#
# Optional Search Catalogs
#
echo Loading Attribute Search Catalogs..

# Generate list of sqlldr control files to load for attribute search catalogs
ctllist=`cd ${ODS_LOAD} ; ls *.ctl`

for ctlfile in $ctllist ; do
  # extract attribute name from control file name
  attr=`echo $ctlfile|sed -e's/.ctl//'` ;   
  if [ ${attr} = "attr_store" -o ${attr} = "cn" -o ${attr} = "dn" -o ${attr} = "objectclass" ] ; then
    continue;
  fi
  echo \\c ${attr}..
  # generate/execute command
  ${ORACLE_HOME}/bin/sqlldr userid=ods/ods@${LDAP_CONNECT} control=${ODS_LOAD}/${attr}.ctl log=${ODS_LOG}/${attr}.log bad=${ODS_LOG}/${attr}.bad errors=10000000 direct=true >${TMPDIR}/null 2>&1
done

echo ''
