#!/bin/sh
##
## hiqretry.sh
## Move conflict changes from Human Intervention queue to retry queue 
##

## Initialize all the variabale

LDAP_DIR=${ORACLE_HOME}/ldap
#LDAP_DIR=/vobs/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
LDAP_LOAD=${LDAP_DIR}/load
#LDAP_LOAD=${LDAP_DIR}/admin/tools
TMPDIR=${LDAP_DIR}/load
SUPPLIER_NODE=null
START_CHGNO=-1
EQUAL_CHGNO=-1
END_CHGNO=-1
ERRORS=0
ENCODING=".UTF8"
PSWD="A"
bo=``
no=``

usage() {
  cat << HIQRETRY
usage : hiqretry.sh -connect <net_service_name> -supplier <supplier_node> [ -start <change number>
| -end <change number>| -equal <change number> ]

      -connect        specifies the Net8 connect descriptor used to connect to
                      the database.
      -supplier       specifies the supplier node where the changes come from
      -start          specifies the start change number for the retry operation
      -equal          specifies the exact change number for the retry operation
      -end            specifies the end change number for the retry operation

HIQRETRY

exit
}

if [ $# -eq 0 ] ; then
  usage
fi

while [ $# -gt 0 ] ; do
      case $1 in
           -connect)  LDAP_CONNECT=$2 ;
                      if [ -z "${LDAP_CONNECT}" ] ; then
                                usage ;
                      fi
                      shift ;;
           -supplier) SUPPLIER_NODE=$2;
                      shift ;;
           -start)    START_CHGNO=$2;
                      shift;;
           -end)      END_CHGNO=$2;
                      shift ;;
           -equal)    EQUAL_CHGNO=$2;
                      shift;;
           -*)        usage  ;;
           esac
           shift
done


if [ -z $ORACLE_HOME ]
then
  echo ORACLE_HOME not set
  exit 1
fi

if [ \( $START_CHGNO -ne -1 -a $EQUAL_CHGNO -ne -1 \) ]
then 
  echo Warning: Do not specify -equal and -start at the same time
  echo 
  usage;
fi  

if [ \( $END_CHGNO -ne -1 -a $EQUAL_CHGNO -ne -1 \) ]
then
  echo Warning: Do not specify -equal and -end at the same time
  echo
  usage;
fi  


if [ -z "${SUPPLIER_NODE}" ] ; then
     usage ;
fi


MACH=${LDAP_CONNECT}
tnsping ${LDAP_CONNECT} > ${TMPDIR}/null 2>&1
if [ $? != 0 ] ; then
  echo
  echo Connect descriptor specified is not valid.. Or not available
  echo
  usage
fi

####THis is the Security Implementation######
if [ ${PSWD} = "A" ] ; then
   echo " "
   echo "${bo}This tool can only be executed if you know database user password
for OiD${no}"
   echo " "
   printf "Enter OiD password ::"
   stty -echo; read PSWD ; stty echo ; echo
   clear
fi


echo " set feedback off
   connect ods/${PSWD}@${LDAP_CONNECT} ;
   exit; " > ${TMPDIR}/seccheck.sql
### check if the password provided is correct
${ORACLE_HOME}/bin/sqlplus  odscommon/odscommon@${LDAP_CONNECT} @${TMPDIR}/seccheck.sql > ${LDAP_LOG}/catchecK.lst
err=`grep -c ERROR ${LDAP_LOG}/catchecK.lst`
rm -f ${LDAP_LOG}/seccheck.lst ${TMPDIR}/seccheck.sql > ${TMPDIR}/null
if [ ${err} != 0 ] ; then
  echo " Password for OiD user is WRONG.."
  echo " Cannot execute this tool ..."
  exit
fi

LDAP_CONNECT=ods/${PSWD}@${LDAP_CONNECT}

if [ ${ERRORS} = 1 ] ; then
  exit
fi
${ORACLE_HOME}/bin/sqlplus -s ${LDAP_CONNECT} @${LDAP_ADMIN}/hiq.sql TRUE ${START_CHGNO} ${EQUAL_CHGNO} ${END_CHGNO} ${SUPPLIER_NODE} > ${LDAP_LOG}/hiqretry.log 2>&1
if [ -s ${LDAP_LOG}/hiqretry.log ] ; then
   echo
   echo
   echo Errors encountered while moving the change confilcts from Human Intervention Queue 
   echo to retry queue 
   echo check ${LDAP_LOG}/hiqretry.log
   echo
   echo Fix the problem and execute the hiqretry.sh again
   echo
   cat ${LDAP_LOG}/hiqretry.log
   echo
else
   echo
   echo  Move change conflicts to retry queue Successfully.
   echo
fi




