#
# $Header: oidcurrentchange.sh 03-apr-00.15:13:13 amsharma Exp $
#
# oidcurrentchange.sh
#
#  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
#
#    NAME
#      oidcurrentchange.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    amsharma    04/03/00 - Script to get Current ChangeNumber in the directory
#    amsharma    04/03/00 - Creation
#

LDAP_DIR=${ORACLE_HOME}/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
LDAP_LOAD=${LDAP_DIR}/load
TMPDIR=${LDAP_DIR}/load
PSWD="A"
bo=``
no=``

usage() {
  cat << CLEANREPL
usage : oidcurrentchange.sh -connect <connect descriptor> 
       
      -connect        specifies the Net8 connect descriptor used to connect to
                      the database.
CLEANREPL

exit
} 

##--------------createclnfile function------------
createclnfile() {
      echo " set feedback off
             set pages
             set heading off
             spool ${LDAP_LOG}/currchgno.lst
             select ods_chg_log_id.nextval from dual;
             spool off
             exit " > ${TMPDIR}/currchgno.sql

}


##--------------CLEANREPLTABLE function------------
getcurrchgno() {
${ORACLE_HOME}/bin/sqlplus -s ${LDAP_CONNECT} @${TMPDIR}/currchgno.sql > nul 2>&1
  if [ -s ${LDAP_LOG}/currchgno.lst ] ; then
      chgno=`cat ${LDAP_LOG}/currchgno.lst`
      echo --------
      echo " Current Change Number == ${chgno} "
      echo -------
      echo
      rm -f ${TMPDIR}/currchgno.lst > nul
  else
      echo --------
      echo " Problems while getting current change Number. "
      echo " check ${LDAP_LOG}/currchgno.lst "
      echo --------
  fi

rm -f ${TMPDIR}/currchgno.sql > nul
}

cleanup() {
rm  -f ${LDAP_LOG}/currchgno.lst   > nul
}
if [ $# -eq 0 ] ; then
  usage
fi
while [ $# -gt 0 ] ; do
      case $1 in
           -connect) LDAP_CONNECT=$2 ;
                     if [ -z "${LDAP_CONNECT}" ] ; then
				usage ;
		     fi
		     shift ;;
           -w)    PSWD=$2;
                 shift;;
	   -*)    usage  ;;
      esac
      shift
done


if [ -z $ORACLE_HOME ] 
then
  echo ORACLE_HOME not set
  exit 1
fi

MACH=${LDAP_CONNECT}
tnsping ${LDAP_CONNECT} > nul 2>&1
if [ $? != 0 ] ; then
  echo
  echo Connect descriptor specified is not valid.. Or not available
  echo
  usage
fi

####THis is the Security Implementation######
if [ ${PSWD} = "A" ] ; then
   echo " "
   echo "${bo}This tool can only be executed if you know database user password for OiD${no}"  
   echo " "
   printf "Enter OiD password ::" 
   stty -echo; read PSWD ; stty echo ; echo
   clear
fi
echo " set feedback off
   connect ods/${PSWD}@${LDAP_CONNECT} ;
   exit; " > ${TMPDIR}/seccheck.sql
### check if the password provided is correct
${ORACLE_HOME}/bin/sqlplus  odscommon/odscommon@${LDAP_CONNECT} @${TMPDIR}/seccheck.sql  > ${LDAP_LOG}/catchecK.lst
err=`grep -c ERROR ${LDAP_LOG}/catchecK.lst`
rm -f ${LDAP_LOG}/seccheck.lst ${TMPDIR}/seccheck.sql > nul
if [ ${err} != 0 ] ; then
  echo " Password for OiD user is WRONG.."
  echo " Cannot execute this tool ..."
  exit
fi

LDAP_CONNECT=ods/${PSWD}@${LDAP_CONNECT}

cleanup
createclnfile
getcurrchgno

   
