#ifdef    RCSID
static char *RCSid =
	"$Header: gslpl.h,v 1.2 97/03/10 14:55:03 skjain: Exp $";
#endif /* RCSID */

#ifdef NOTDEF
/*
				OAPL.H

	Copyright (c) Oracle Corporation 1989.  All Rights Reserved.

NAME
	oapl - Header file for OAPL module

SYNOPSIS
 This file contains all the prototypes for the oapl logging directory.

 The current mechanism is rather simple but is designed to be expanded upon
at a later time by those with more free time.   It allows for the logging of 
messages to a specified file in a variety of ways.  The source of the actual
log messages may be from message files, direct input or the Oracle kernal's 
error strings.   Certain messages will also allow for the inputing of actual
numerical and character values (i.e., via the STDIO sprintf() mechanism) into
the message strings directly.

 The oapla structure is passed to each of the logging calls and contains
sufficient information to define the source of the messages to log, the file
name and/or descriptor to write the messages to, and the current level of 
logging requested (in order to determine dynamically whether or not to log 
the message requested.)

 User's of the ./oapl module will need to do their own setup of the oapla
structure including entering their own message file and product Id, logfile 
name or descriptor and set the appropriate bits for turning on/off the
different modes.   The logging calls assume that the oapla structure is in
a consistent state.

MODIFIED
    jluke      03/03/97 -  Creation 
    ssharma    02/22/93 -  Adding prototype for oaplog() 
    sgans      08/31/92 -  added prototype for oapltLS 
    dfrazier   03/23/92 -  olint 
 10-Mar-92 (bhaghigh)	added timestamp flags
 30-Jan-92 (sgans)	added oaplafac
  9-Jan-92 (sgans)	spec out as oapl module and fix up oapla structure
  9-Jan-92 (rkovacs)	added ompltS() prototype
 31-Dec-91 (sgans)	added ompllcy... prototypes
 27-Dec-91 (sgans)	created

*/
#endif								   /* NOTDEF */

#ifndef  OAPL
#define  OAPL

#ifndef  S_ORACLE
#include <s.h>
#endif									/* S */

/*--------------+
! Structures	!
+--------------*/

struct oapla
{
    eword	oaplamode;				     /* status flags */
    eword	oaplapid;				   /* LMS product Id */
    eword	oaplalev;     /* dynamic severity level - NOT CURRENTLY USED */
    eword	oaplafac;				/* LMS facility code */
    oamh	*oaplamh;			     /* message-handler file */
    FILE	*oaplafp;			       /* pointer to logfile */
    text	oaplafile[256];			       /* debugging filename */
};

typedef struct oapla oapla;

/* bits for oaplamode field in oapla */
#define   OAPLF_DBGON		1			/* debugging enabled */
#define   OAPLF_OPEN		2		   /* logfile currently open */
#define   OAPLF_FILE		4		 /* log to file if it's good */
#define   OAPLF_CLOSE		8	  /* always close file after logging */
#define   OAPLF_RECYCLE	       16			/* recycle log files */

/*--------------+
!   Constants	!
+--------------*/

/* The following values are used for specifying the override/logging level */
#define  OAPLC_ON	1			  /* always log this message */
#define  OAPLC_TIME	2			 /* log 'HH24:MI:SS message' */
#define  OAPLC_DATE	4			      /* log 'MM/DD message' */
#define  OAPLC_TD	6		   /* log 'MM/DD HH24:MI:SS message' */

/* The debugging levels */
#define  OAPLVLE	1				 /* level 1:  errors */
#define  OAPLVLN	2			/* level 2: normal operation */
#define  OAPLVLD1	3		/* level 3: lowest debugging (brief) */
#define  OAPLVLD2	4		/* level 4: medium debugging (terse) */
#define  OAPLVLD3	5	     /* level 5: maximum debugging (verbose) */

/*---------------+
!  Macros	 !
+---------------*/

/*---------------+
!  Prototypes	 !
+---------------*/

/*
**   General info:
**
**	- severity level:   the severity level to be associated with each
**	 message can be set using the severity levels within the message
**	 file.  for logging calls that take their text directly, a severity 
**	 level will be passed in as a parameter.
**
**	- 'override' is used to force this message to be logged, regardless
**	 of the current severity level.  
**
**	- parameter substitution:  message lines will allow for standard
**	 '%ld' and '%s' substitution.  such calls are:  oapltL1, oapltL2
**	 and oapltS.   if more are needed, they can be added easily.
**
**	- carriage returns:  only calls to oaploer() will supply a trailing
**	 '\n' character.  
*/

/* oapltxt:
** Log a given line of text to the logfile
*/
void oapltxt (/*_ oapla *log_info, const text *tptr, eword slevel,
		eword override _*/);

/*  oaplt:
**  Log a line of text from the message file 
*/
void oaplt   (/*_ oapla *log_info, eword msgid, eword override _*/);

/*  oapltS:
**  Log a line of text from the message file and substitute 'txt' for '%s'
*/
void oapltS  (/*_ oapla *log_info, eword msgid, const text *txt, 
		eword override _*/);

/*  oapltL1:
**  Log a line of text from the message file and substitute a number for '%ld'
*/
void oapltL1 (/*_ oapla *log_info, eword msgid, sb4 L1, eword override _*/);

/*  oapltL2:
**  Log a line of text from the message file and substitute numbers for '%ld's
*/
void oapltL2 (/*_ oapla *log_info, eword msgid, sb4 L1, sb4 L2, 
		eword override _*/);

/*  oapltLS:
**  Log a line of text from the message file and substitute numbers for '%ld'
**   and '%s'
*/
void oapltLS (/*_ oapla *log_info, eword msgid, sb4 L1, const text *txt, 
		eword override _*/);

/* 
 *
 * Log a line of text and insert 0 or more values of any printable type
 * See comments on the usage of oaplog() in oapl.c
 *
 */
void oaplog VAFP((oapla *loginfo, ...));

/*  oaploer:
**  Log an Oracle error in a module by constructing the string
**   "<module>:  Oracle error <oerr> <action>"
**
**  sample use:   module = "ompmcll",  action = "parsing To-string recipients",
**			oerr = 3114
**   would yield  "ompmcll:  Oracle error 3114 parsing To-string recipients\n"
*/
void oaploer (/*_ oapla *log_info, const text *module, const text *action,
		sb4 oerr, eword override _*/);

/* PRIVATE FUNCTIONS FOR INTERNAL USE ONLY */
void oaplcls (/*_ oapla *loginfo _*/);
sword oaplopn (/*_ oapla *loginfo _*/);
void oaplsts(/*_ oapla *loginfo, eword  override _*/);

#endif								     /* OAPL */
