/*
 * $Header: gssdom.h 18-feb-00.11:02:16 akeni Exp $
 */

/* Copyright (c) 1991, 2000 by Oracle Corporation */
/* NAME
      gssdom.h - Groupware Server Standalone Directory OCI Macros
   DESCRIPTION
      Definitions and macros to simplify OCI (DB access) calls
   PUBLIC FUNCTION(S)
      <list of external functions declared/defined - with one-line descriptions>
   PRIVATE FUNCTION(S)
      <list of static functions defined in .c file - with one-line descriptions>
   RETURNS
      <function return values, for .c file with single function>
   NOTES
      <other useful comments, qualifications, etc.>
   MODIFIED (MM/DD/YY)
      akeni 02/18/00 - oci8 upgrade
      jluke 06/23/97 - Fixup for general use.
      hmadan 06/02/97 - Creation
 */

#ifndef GSSDOM_H
#define GSSDOM_H

/**************************************
 * Safe inclusion of OCI header deps */
/*#ifndef OCIDEF
#include <ocidef.h>
#include <ocidem.h>
#include <ocidfn.h>
 #endif*/ /* OCIDEF */

/* OCI cursor parsing modes */
#define GSSDOMPARSE_NONDEF (sword)0
#define GSSDOMPARSE_DEFER  (sword)1

/* OCI piecewise fetching status codes */
#define  GSSDOMPW_MOREINSERT      3129
#define  GSSDOMPW_MOREFETCH       3130

/*********************************************************
 * Wrappered OCI calls 
 *    All of these macros take a pointer to an OCI Statement
 *    as the first parameter (labeled "stmt")
 */

/* fn : Any OCI function invocation (with complete arglist)
 * exitLabel: Line label to jump to in case of an error return
 * This macros assumes that the standard local variable, err,
 * is defined within the function containing the MACRO call */
#define gssdomSAFE(pC, fn, exitLabel) \
 (dvoid)fn; if ((err = (*pC).rc) != 0) goto exitrc

/* Bind wrappers */
#define gssdomBIND_ANY(stmt,bndhp,errhp,Name, BindVar, Size, BType) \
 OCIBindByName(stmt, bndhp, errhp, (CONST text *) Name, -1, (dvoid *) BindVar, \
               (sb4) Size, (ub2) BType, (dvoid *) 0, (ub2 *)0, (ub2 *) 0, \
               (ub4) 0, (ub4 *) 0, (ub4) OCI_DEFAULT)

/* Define wrappers */
#define gssdomDEFINE_VAR(stmt,def,err,Pos,Name,Size,DType,rlen,rowRC)  \
 OCIDefineByPos(stmt, def, err, (ub4) Pos, (dvoid *) Name, (sb4) Size, \
                (ub2) DType, (dvoid *) 0, (ub2 *) rlen, (ub2 *) rowRC, \
                (ub4) OCI_DEFAULT)

#define gssdomDEFINE_PW(pC, pcC, Size, Type, Len, RC)\
 odefinps(pC, 0, 1, (ub1 *)pcC, Size, Type, (sword)0, (sb2 *)0, (text *)NULL, \
           (sb4)0, (sword)0, Len, RC, (sb4)0, (sb4)0, (sb4)0, (sb4)0 )
         
/* Bind variant wrappers */
#define gssdomBIND_NTH(pC, Nth, BindVar, Size, BType) \
 (dvoid)obndrn( pC, (sword)Nth, (ub1 *)BindVar, (sword)Size, BType,\
                -1, (sb2 *) 0, (text *) NULL, (sword)-1, (sword)-1)
#define gssdomBIND_ARR(pC,Name,Arr,RowLEN, BType,INDs,LENs,RCs,MaxRow,cRes)\
 (dvoid)obndra( pC, (text *)Name, (sword)-1, (ub1 *)Arr, (sword) RowLEN,   \
                (sword)BType, (sword)-1, (sb2 *)INDs, (ub2 *)LENs, (ub2 *)RCs, \
                (ub4)MaxRow, (ub4 *)cRes, (text *)0, (sword) -1, (sword ) -1)
#define gssdomBIND_PW(pC, Name, pcC, Size, Type, RC)\
 (dvoid)obindps( pC, 0, (text *)Name, -1, (ub1 *)pcC, Size, Type, (sword)0, (sb2 *)0,\
                 (ub2 *)0, RC, 0, 0, 0, 0, (ub4)0, (ub4 *)0, (text *)0, 0, 0 )
                 
/* Safe wrappers */
#define gssdomSAFE_OPEN(pC, pL, exitrc)\
 oopen(pC, pL, 0,-1,-1, 0, -1); if (err = (*pC).rc) goto exitrc 
	     
#define gssdomSAFE_PARSE(stmthp, errhp, SQL, exitrc, rc)\
 rc = OCIStmtPrepare(stmthp, errhp, (CONST text *) SQL, \
                     (ub4) NLSSTRLEN(SQL), (ub4) OCI_NTV_SYNTAX, \
                     (ub4) OCI_DEFAULT); \
 if ( OCI_SUCCESS != rc ) goto exitrc

#define gssdomSAFE_EXEC(pC, exitrc)\
 oexec(pC); if (err=(*pC).rc) goto exitrc

#define gssdomSAFE_EXFETCH(pC, NRows, exitrc)\
 oexfet(pC,NRows,0,0); if (err=(*pC).rc) goto exitrc

#define gssdomSAFE_BIND(stmt,bndhp,errhp,Name,BindVar,Size,BType,exitrc,rc)    \
 rc = gssdomBIND_ANY(stmt,bndhp,errhp,Name,BindVar,Size,BType); \
   if (OCI_SUCCESS != rc) goto exitrc

#define gssdomSAFE_BINDN(pC, Nth, BindVar, Size, BType, exitrc) \
 gssdomBIND_NTH( pC, Nth, BindVar, Size, BType ); if (err=(*pC).rc) goto exitrc

#define gssdomSAFE_BINDPW(pC, Name, pcC, Size, Type, RC, exitrc)\
 gssdomBIND_PW( pC, Name, pcC, Size, Type, RC ); if (err=(*pC).rc) goto exitrc

#define gssdomSAFE_BINDA(pC,Name,Arr,RowLEN, BType,INDs,LENs,RCs,MaxRow,cRes,exitrc)\
 gssdomSAFE_BINDA( pC, Name, Arr, RowLEN, BType, INDs, LENs, RCs, MaxRow, cRes);\
 if (err=(*pC).rc) goto exitrc

#define gssdomSAFE_DEF(stmt,def,err,Pos,Name,Size,DType,rlen,rowRC,exitrc,rc)  \
 rc = gssdomDEFINE_VAR(stmt,def,err,Pos,Name,Size,DType,rlen,rowRC);  \
 if (OCI_SUCCESS != rc) goto exitrc

#define gssdomSAFE_DEFPW(pC, pcC, Size, Type, Len, RC, exitrc)\
 gssdomDEFINE_PW(pC, pcC, Size, Type, Len, RC); if (err=(*pC).rc) goto exitrc
 
#define gssdomSAFE_GETPW(pC, piece, pcC, iter, plsql, exitrc)\
 ogetpi( pC, piece, (dvoid **)pcC, iter, plsql); if (err = (*pC).rc) goto exitrc

#define gssdomSAFE_SETPW(pC, piece, value, Len, exitrc)\
 osetpi( pC, piece, value, Len ); if (err = (*pC).rc) goto exitrc

#endif /* GSSDOM_H */
